/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import qupath.lib.common.GeneralTools;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.AbstractPathBoundedROI;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class EllipseROI
extends AbstractPathBoundedROI
implements Serializable {
    private static final long serialVersionUID = 1L;

    EllipseROI() {
    }

    EllipseROI(double x, double y, double width, double height, ImagePlane plane) {
        super(x, y, width, height, plane);
    }

    @Override
    public boolean contains(double xx, double yy) {
        double ry;
        double dx = xx - this.getCentroidX();
        double dy = yy - this.getCentroidY();
        double rx = this.getBoundsWidth() * 0.5;
        return dx * dx / (rx * rx) + dy * dy / ((ry = this.getBoundsHeight() * 0.5) * ry) <= 1.0;
    }

    @Override
    public String getRoiName() {
        return "Ellipse";
    }

    public boolean isCircle() {
        return this.isCircle(1.0, 1.0);
    }

    public boolean isCircle(double pixelWidth, double pixelHeight) {
        return GeneralTools.almostTheSame(this.getBoundsWidth() * pixelWidth, this.getBoundsHeight() * pixelHeight, 1.0E-5);
    }

    @Override
    public double getScaledArea(double pixelWidth, double pixelHeight) {
        double a = this.getBoundsWidth() * pixelWidth * 0.5;
        double b = this.getBoundsHeight() * pixelHeight * 0.5;
        return Math.PI * a * b;
    }

    @Override
    public double getScaledLength(double pixelWidth, double pixelHeight) {
        if (this.isCircle(pixelWidth, pixelHeight)) {
            return Math.PI * this.getBoundsWidth() * pixelWidth;
        }
        double a = this.getBoundsWidth() * pixelWidth * 0.5;
        double b = this.getBoundsHeight() * pixelHeight * 0.5;
        double h = (a - b) * (a - b) / ((a + b) * (a + b));
        return Math.PI * (a + b) * (1.0 + 3.0 * h / (10.0 + Math.sqrt(4.0 - 3.0 * h)));
    }

    @Override
    public int getNumPoints() {
        return 4;
    }

    @Override
    @Deprecated
    public ROI duplicate() {
        EllipseROI duplicate = new EllipseROI();
        duplicate.x = this.x;
        duplicate.x2 = this.x2;
        duplicate.y = this.y;
        duplicate.y2 = this.y2;
        duplicate.c = this.c;
        duplicate.z = this.z;
        duplicate.t = this.t;
        return duplicate;
    }

    @Override
    public ROI updatePlane(ImagePlane plane) {
        return new EllipseROI(this.getBoundsX(), this.getBoundsY(), this.getBoundsWidth(), this.getBoundsHeight(), plane);
    }

    @Override
    public List<Point2> getAllPoints() {
        return Arrays.asList(new Point2(this.x / 2.0 + this.x2 / 2.0, this.y), new Point2(this.x2, this.y / 2.0 + this.y2 / 2.0), new Point2(this.x / 2.0 + this.x2 / 2.0, this.y2), new Point2(this.x, this.y / 2.0 + this.y2 / 2.0));
    }

    @Override
    public Shape getShape() {
        return new Ellipse2D.Double(this.x, this.y, this.x2 - this.x, this.y2 - this.y);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required for reading");
    }

    @Override
    public ROI getConvexHull() {
        return this;
    }

    @Override
    public ROI scale(double scaleX, double scaleY, double originX, double originY) {
        double x1 = RoiTools.scaleOrdinate(this.getBoundsX(), scaleX, originX);
        double y1 = RoiTools.scaleOrdinate(this.getBoundsY(), scaleY, originY);
        double x2 = RoiTools.scaleOrdinate(this.getBoundsX() + this.getBoundsWidth(), scaleX, originX);
        double y2 = RoiTools.scaleOrdinate(this.getBoundsY() + this.getBoundsHeight(), scaleY, originY);
        return new EllipseROI(x1, y1, x2 - x1, y2 - y1, this.getImagePlane());
    }

    @Override
    public ROI translate(double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            return this;
        }
        return new EllipseROI(this.getBoundsX() + dx, this.getBoundsY() + dy, this.getBoundsWidth(), this.getBoundsHeight(), this.getImagePlane());
    }

    @Override
    public ROI.RoiType getRoiType() {
        return ROI.RoiType.AREA;
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final double x;
        private final double x2;
        private final double y;
        private final double y2;
        private final String name;
        private final int c;
        private final int z;
        private final int t;

        SerializationProxy(EllipseROI roi) {
            this.x = roi.x;
            this.x2 = roi.x2;
            this.y = roi.y;
            this.y2 = roi.y2;
            this.name = null;
            this.c = roi.c;
            this.z = roi.z;
            this.t = roi.t;
        }

        private Object readResolve() {
            EllipseROI roi = new EllipseROI(this.x, this.y, this.x2 - this.x, this.y2 - this.y, ImagePlane.getPlaneWithChannel(this.c, this.z, this.t));
            return roi;
        }
    }
}

