/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import qupath.lib.common.GeneralTools;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.AbstractPathROI;
import qupath.lib.roi.ClosedShapeStatistics;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.Vertices;
import qupath.lib.roi.VerticesFactory;
import qupath.lib.roi.WindingTest;
import qupath.lib.roi.interfaces.ROI;

public class PolygonROI
extends AbstractPathROI
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Vertices vertices;
    private transient ClosedShapeStatistics stats = null;
    private transient SoftReference<Geometry> cachedGeometry;

    PolygonROI() {
    }

    PolygonROI(double x, double y) {
        this(x, y, null);
    }

    PolygonROI(List<Point2> points) {
        this(points, null);
    }

    PolygonROI(double x, double y, ImagePlane plane) {
        super(plane);
        this.vertices = VerticesFactory.createVertices(new float[]{(float)x, (float)x}, new float[]{(float)y, (float)y}, false);
    }

    PolygonROI(List<Point2> points, ImagePlane plane) {
        super(plane);
        float[] x = new float[points.size()];
        float[] y = new float[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            Point2 p = points.get(i);
            x[i] = (float)p.getX();
            y[i] = (float)p.getY();
        }
        this.vertices = VerticesFactory.createVertices(x, y, false);
    }

    PolygonROI(float[] x, float[] y, ImagePlane plane) {
        this(x, y, plane, true);
    }

    PolygonROI(float[] x, float[] y, ImagePlane plane, boolean copyVertices) {
        super(plane);
        this.vertices = VerticesFactory.createVertices(x, y, copyVertices);
    }

    @Override
    public Geometry getGeometry() {
        Geometry geom;
        Geometry geometry = geom = this.cachedGeometry == null ? null : this.cachedGeometry.get();
        if (geom == null) {
            geom = super.getGeometry();
            this.cachedGeometry = new SoftReference<Geometry>(geom);
        }
        return geom.copy();
    }

    public int nVertices() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getNVertices();
    }

    @Override
    @Deprecated
    public ROI duplicate() {
        return new PolygonROI(this.vertices.getPoints(), this.getImagePlane());
    }

    @Override
    public double getCentroidX() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getCentroidX();
    }

    @Override
    public double getCentroidY() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getCentroidY();
    }

    @Override
    public boolean contains(double x, double y) {
        return WindingTest.getWindingNumber(this.vertices, x, y) != 0;
    }

    @Override
    public ROI translate(double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            return this;
        }
        float[] x = this.vertices.getX(null);
        float[] y = this.vertices.getY(null);
        for (int i = 0; i < x.length; ++i) {
            x[i] = (float)((double)x[i] + dx);
            y[i] = (float)((double)y[i] + dy);
        }
        return new PolygonROI(x, y, this.getImagePlane());
    }

    @Override
    public ROI scale(double scaleX, double scaleY, double originX, double originY) {
        return new PolygonROI(this.getAllPoints().stream().map(p -> RoiTools.scalePoint(p, scaleX, scaleY, originX, originY)).toList(), this.getImagePlane());
    }

    @Override
    public String getRoiName() {
        return "Polygon";
    }

    @Override
    public double getArea() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getArea();
    }

    @Override
    public double getLength() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getPerimeter();
    }

    @Override
    public Shape getShape() {
        Path2D.Float path = new Path2D.Float();
        Vertices vertices = this.getVertices();
        for (int i = 0; i < vertices.size(); ++i) {
            if (i == 0) {
                ((Path2D)path).moveTo(vertices.getX(i), vertices.getY(i));
                continue;
            }
            ((Path2D)path).lineTo(vertices.getX(i), vertices.getY(i));
        }
        path.closePath();
        return path;
    }

    @Override
    public ROI updatePlane(ImagePlane plane) {
        return new PolygonROI(this.getAllPoints(), plane);
    }

    @Override
    public List<Point2> getAllPoints() {
        return this.vertices.getPoints();
    }

    Vertices getVertices() {
        return this.vertices;
    }

    void calculateShapeMeasurements() {
        this.stats = new ClosedShapeStatistics(this.vertices);
    }

    @Override
    public double getScaledArea(double pixelWidth, double pixelHeight) {
        if (GeneralTools.almostTheSame(pixelWidth, pixelHeight, 1.0E-4)) {
            return this.getArea() * pixelWidth * pixelHeight;
        }
        return new ClosedShapeStatistics(this.vertices, pixelWidth, pixelHeight).getArea();
    }

    @Override
    public double getScaledLength(double pixelWidth, double pixelHeight) {
        if (GeneralTools.almostTheSame(pixelWidth, pixelHeight, 1.0E-4)) {
            return this.getLength() * (pixelWidth + pixelHeight) * 0.5;
        }
        return new ClosedShapeStatistics(this.vertices, pixelWidth, pixelHeight).getPerimeter();
    }

    @Override
    public double getBoundsX() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getBoundsX();
    }

    @Override
    public double getBoundsY() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getBoundsY();
    }

    @Override
    public double getBoundsWidth() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getBoundsWidth();
    }

    @Override
    public double getBoundsHeight() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getBoundsHeight();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required for reading");
    }

    @Override
    public ROI.RoiType getRoiType() {
        return ROI.RoiType.AREA;
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final float[] x;
        private final float[] y;
        private final String name;
        private final int c;
        private final int z;
        private final int t;
        private ClosedShapeStatistics stats;

        SerializationProxy(PolygonROI roi) {
            this.x = roi.vertices.getX(null);
            this.y = roi.vertices.getY(null);
            this.name = null;
            this.c = roi.c;
            this.z = roi.z;
            this.t = roi.t;
            this.stats = roi.stats;
        }

        private Object readResolve() {
            PolygonROI roi = new PolygonROI(this.x, this.y, ImagePlane.getPlaneWithChannel(this.c, this.z, this.t), false);
            roi.stats = this.stats;
            return roi;
        }
    }
}

