/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import qupath.lib.common.GeneralTools;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.AbstractPathROI;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.Vertices;
import qupath.lib.roi.VerticesFactory;
import qupath.lib.roi.interfaces.ROI;

public class PolylineROI
extends AbstractPathROI
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Vertices vertices;
    private transient PolylineStats stats;

    PolylineROI(List<Point2> points, ImagePlane plane) {
        super(plane);
        float[] x = new float[points.size()];
        float[] y = new float[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            Point2 p = points.get(i);
            x[i] = (float)p.getX();
            y[i] = (float)p.getY();
        }
        this.vertices = VerticesFactory.createVertices(x, y, false);
    }

    PolylineROI(float[] x, float[] y, ImagePlane plane) {
        this(x, y, plane, true);
    }

    private PolylineROI(float[] x, float[] y, ImagePlane plane, boolean copyVertices) {
        super(plane);
        this.vertices = VerticesFactory.createVertices(x, y, copyVertices);
    }

    @Override
    public String getRoiName() {
        return "Polyline";
    }

    @Override
    public double getCentroidX() {
        return this.getStats().centroidX;
    }

    @Override
    public double getCentroidY() {
        return this.getStats().centroidY;
    }

    @Override
    public double getBoundsX() {
        return this.getStats().boundsX;
    }

    @Override
    public double getBoundsY() {
        return this.getStats().boundsY;
    }

    @Override
    public double getBoundsWidth() {
        return this.getStats().boundsWidth;
    }

    @Override
    public double getBoundsHeight() {
        return this.getStats().boundsHeight;
    }

    @Override
    public List<Point2> getAllPoints() {
        return this.vertices.getPoints();
    }

    Vertices getVertices() {
        return this.vertices;
    }

    @Override
    @Deprecated
    public ROI duplicate() {
        return new PolylineROI(this.vertices.getX(null), this.vertices.getY(null), this.getImagePlane());
    }

    @Override
    public ROI translate(double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            return this;
        }
        float[] x = this.vertices.getX(null);
        float[] y = this.vertices.getY(null);
        for (int i = 0; i < x.length; ++i) {
            x[i] = (float)((double)x[i] + dx);
            y[i] = (float)((double)y[i] + dy);
        }
        return new PolylineROI(x, y, this.getImagePlane(), false);
    }

    @Override
    public double getLength() {
        return this.getStats().length;
    }

    @Override
    public double getScaledLength(double pixelWidth, double pixelHeight) {
        if (pixelWidth == 1.0 && pixelHeight == 1.0) {
            return this.getLength();
        }
        if (GeneralTools.almostTheSame(pixelWidth, pixelHeight, 1.0E-7)) {
            return this.getLength() * ((pixelWidth + pixelHeight) / 2.0);
        }
        return new PolylineStats((Vertices)this.vertices, (double)pixelWidth, (double)pixelHeight).length;
    }

    private PolylineStats getStats() {
        if (this.stats == null) {
            this.stats = new PolylineStats(this.vertices, 1.0, 1.0);
        }
        return this.stats;
    }

    @Override
    public ROI scale(double scaleX, double scaleY, double originX, double originY) {
        return new PolylineROI(this.getAllPoints().stream().map(p -> RoiTools.scalePoint(p, scaleX, scaleY, originX, originY)).toList(), this.getImagePlane());
    }

    @Override
    public double getArea() {
        return 0.0;
    }

    @Override
    public double getScaledArea(double pixelWidth, double pixelHeight) {
        return 0.0;
    }

    @Override
    public ROI.RoiType getRoiType() {
        return ROI.RoiType.LINE;
    }

    @Override
    public Shape getShape() {
        Path2D.Float path = new Path2D.Float();
        Vertices vertices = this.getVertices();
        for (int i = 0; i < vertices.size(); ++i) {
            if (i == 0) {
                ((Path2D)path).moveTo(vertices.getX(i), vertices.getY(i));
                continue;
            }
            ((Path2D)path).lineTo(vertices.getX(i), vertices.getY(i));
        }
        return path;
    }

    @Override
    public ROI updatePlane(ImagePlane plane) {
        return new PolylineROI(this.getAllPoints(), plane);
    }

    @Override
    public boolean contains(double x, double y) {
        return false;
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required for reading");
    }

    private static class PolylineStats {
        private double boundsX = Double.NaN;
        private double boundsY = Double.NaN;
        private double boundsWidth = 0.0;
        private double boundsHeight = 0.0;
        private double centroidX = Double.NaN;
        private double centroidY = Double.NaN;
        private double length = 0.0;

        PolylineStats(Vertices vertices, double pixelWidth, double pixelHeight) {
            if (vertices.size() == 0) {
                return;
            }
            this.length = 0.0;
            double x = vertices.getX(0);
            double y = vertices.getY(0);
            double xMin = x;
            double xMax = x;
            double yMin = y;
            double yMax = y;
            double sumCenterX = 0.0;
            double sumCenterY = 0.0;
            for (int i = 1; i < vertices.size(); ++i) {
                double x2 = vertices.getX(i);
                double y2 = vertices.getY(i);
                double dx = (x2 - x) * pixelWidth;
                double dy = (y2 - y) * pixelHeight;
                double segLength = Math.sqrt(dx * dx + dy * dy);
                this.length += segLength;
                double xCenter = (x + x2) / 2.0;
                double yCenter = (y + y2) / 2.0;
                sumCenterX += xCenter * segLength;
                sumCenterY += yCenter * segLength;
                x = x2;
                y = y2;
                if (x < xMin) {
                    xMin = x;
                }
                if (y < yMin) {
                    yMin = y;
                }
                if (x > xMax) {
                    xMax = x;
                }
                if (!(y > yMax)) continue;
                yMax = y;
            }
            this.boundsX = xMin;
            this.boundsY = yMin;
            this.boundsWidth = xMax - xMin;
            this.boundsHeight = yMax - yMin;
            this.centroidX = sumCenterX / this.length;
            this.centroidY = sumCenterY / this.length;
            assert (this.centroidX >= this.boundsX && this.centroidX <= this.boundsX + this.boundsWidth);
            assert (this.centroidY >= this.boundsY && this.centroidY <= this.boundsY + this.boundsHeight);
        }
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final float[] x;
        private final float[] y;
        private final int c;
        private final int z;
        private final int t;

        SerializationProxy(PolylineROI roi) {
            this.x = roi.vertices.getX(null);
            this.y = roi.vertices.getY(null);
            this.c = roi.c;
            this.z = roi.z;
            this.t = roi.t;
        }

        private Object readResolve() {
            return new PolylineROI(this.x, this.y, ImagePlane.getPlaneWithChannel(this.c, this.z, this.t), false);
        }
    }
}

