/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.AbstractPathBoundedROI;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class RectangleROI
extends AbstractPathBoundedROI
implements Serializable {
    private static final long serialVersionUID = 1L;

    RectangleROI() {
    }

    RectangleROI(double x, double y, double width, double height) {
        this(x, y, width, height, null);
    }

    RectangleROI(double x, double y, double width, double height, ImagePlane plane) {
        super(x, y, width, height, plane);
    }

    @Override
    public boolean contains(double x, double y) {
        return x >= this.x && x < this.x2 && y >= this.y && y < this.y2;
    }

    @Override
    public String getRoiName() {
        return "Rectangle";
    }

    @Override
    public int getNumPoints() {
        return 4;
    }

    @Override
    public double getScaledArea(double pixelWidth, double pixelHeight) {
        return this.getBoundsWidth() * this.getBoundsHeight() * pixelWidth * pixelHeight;
    }

    @Override
    public double getScaledLength(double pixelWidth, double pixelHeight) {
        return (this.getBoundsWidth() * pixelWidth + this.getBoundsHeight() * pixelHeight) * 2.0;
    }

    @Override
    @Deprecated
    public ROI duplicate() {
        RectangleROI duplicate = new RectangleROI();
        duplicate.x = this.x;
        duplicate.x2 = this.x2;
        duplicate.y = this.y;
        duplicate.y2 = this.y2;
        duplicate.c = this.c;
        duplicate.z = this.z;
        duplicate.t = this.t;
        return duplicate;
    }

    @Override
    public List<Point2> getAllPoints() {
        return Arrays.asList(new Point2(this.x, this.y), new Point2(this.x2, this.y), new Point2(this.x2, this.y2), new Point2(this.x, this.y2));
    }

    @Override
    public Shape getShape() {
        return new Rectangle2D.Double(this.x, this.y, this.x2 - this.x, this.y2 - this.y);
    }

    @Override
    public ROI translate(double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            return this;
        }
        return new RectangleROI(this.getBoundsX() + dx, this.getBoundsY() + dy, this.getBoundsWidth(), this.getBoundsHeight(), this.getImagePlane());
    }

    @Override
    public ROI getConvexHull() {
        return this;
    }

    @Override
    public ROI.RoiType getRoiType() {
        return ROI.RoiType.AREA;
    }

    @Override
    public ROI updatePlane(ImagePlane plane) {
        return new RectangleROI(this.getBoundsX(), this.getBoundsY(), this.getBoundsWidth(), this.getBoundsHeight(), plane);
    }

    @Override
    public ROI scale(double scaleX, double scaleY, double originX, double originY) {
        double x1 = RoiTools.scaleOrdinate(this.getBoundsX(), scaleX, originX);
        double y1 = RoiTools.scaleOrdinate(this.getBoundsY(), scaleY, originY);
        double x2 = RoiTools.scaleOrdinate(this.getBoundsX() + this.getBoundsWidth(), scaleX, originX);
        double y2 = RoiTools.scaleOrdinate(this.getBoundsY() + this.getBoundsHeight(), scaleY, originY);
        return new RectangleROI(x1, y1, x2 - x1, y2 - y1, this.getImagePlane());
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required for reading");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final double x;
        private final double x2;
        private final double y;
        private final double y2;
        private final String name;
        private final int c;
        private final int z;
        private final int t;

        SerializationProxy(RectangleROI roi) {
            this.x = roi.x;
            this.x2 = roi.x2;
            this.y = roi.y;
            this.y2 = roi.y2;
            this.name = null;
            this.c = roi.c;
            this.z = roi.z;
            this.t = roi.t;
        }

        private Object readResolve() {
            RectangleROI roi = new RectangleROI(this.x, this.y, this.x2 - this.x, this.y2 - this.y, ImagePlane.getPlaneWithChannel(this.c, this.z, this.t));
            return roi;
        }
    }
}

