/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.AbstractPathBoundedROI;
import qupath.lib.roi.AbstractPathROI;
import qupath.lib.roi.EllipseROI;
import qupath.lib.roi.LineROI;
import qupath.lib.roi.PointsROI;
import qupath.lib.roi.PolygonROI;
import qupath.lib.roi.PolylineROI;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.interfaces.ROI;

public class RoiEditor {
    private static final Logger logger = LoggerFactory.getLogger(RoiEditor.class);
    private ROI pathROI;
    private MutablePoint activeHandle;
    private boolean isTranslating = false;
    private ROI roiTranslateOrigin;
    private MutablePoint pTranslateOrigin;
    private MutablePoint pTranslateCurrent;
    private boolean translateSnapToPixel;
    private transient RoiHandleAdjuster<?> adjuster;

    private RoiEditor() {
    }

    public static RoiEditor createInstance() {
        return new RoiEditor();
    }

    public void setROI(ROI roi) {
        this.setROI(roi, true);
    }

    public void setROI(ROI roi, boolean stopTranslating) {
        if (this.pathROI == roi) {
            return;
        }
        if (this.isTranslating() && stopTranslating) {
            this.finishTranslation();
            this.activeHandle = null;
        }
        this.pathROI = roi;
        if (this.pathROI instanceof RectangleROI) {
            this.adjuster = new RectangleHandleAdjuster((RectangleROI)this.pathROI);
        } else if (this.pathROI instanceof EllipseROI) {
            this.adjuster = new EllipseHandleAdjuster((EllipseROI)this.pathROI);
        } else if (this.pathROI instanceof PolygonROI) {
            this.adjuster = new PolygonHandleAdjuster((PolygonROI)this.pathROI);
        } else if (this.pathROI instanceof PolylineROI) {
            this.adjuster = new PolylineHandleAdjuster((PolylineROI)this.pathROI);
        } else if (this.pathROI instanceof LineROI) {
            this.adjuster = new LineHandleAdjuster(this, (LineROI)this.pathROI);
        } else if (this.pathROI instanceof PointsROI) {
            this.adjuster = new PointsHandleAdjuster((PointsROI)this.pathROI);
        } else {
            this.adjuster = null;
            return;
        }
    }

    public boolean startTranslation(double x, double y, boolean snapToPixel) {
        if (this.pathROI == null) {
            return false;
        }
        this.pTranslateOrigin = new MutablePoint(x, y);
        this.pTranslateCurrent = new MutablePoint(x, y);
        this.isTranslating = true;
        this.roiTranslateOrigin = this.pathROI;
        this.translateSnapToPixel = snapToPixel;
        return true;
    }

    public ROI updateTranslation(double x, double y, ImageRegion constrainRegion) {
        if (!this.isTranslating()) {
            return this.pathROI;
        }
        double dx = x - this.pTranslateCurrent.getX();
        double dy = y - this.pTranslateCurrent.getY();
        Rect constrainBounds = new Rect(constrainRegion.getX(), constrainRegion.getY(), constrainRegion.getWidth(), constrainRegion.getHeight());
        if (constrainBounds != null) {
            Rect bounds = new Rect(this.pathROI.getBoundsX(), this.pathROI.getBoundsY(), this.pathROI.getBoundsWidth(), this.pathROI.getBoundsHeight());
            if (bounds.getMinX() + dx < constrainBounds.getMinX()) {
                dx = constrainBounds.getMinX() - bounds.getMinX();
            } else if (bounds.getMaxX() + dx >= constrainBounds.getMaxX()) {
                dx = constrainBounds.getMaxX() - bounds.getMaxX();
            }
            if (bounds.getMinY() + dy < constrainBounds.getMinY()) {
                dy = constrainBounds.getMinY() - bounds.getMinY();
            } else if (bounds.getMaxY() + dy >= constrainBounds.getMaxY()) {
                dy = constrainBounds.getMaxY() - bounds.getMaxY();
            }
        }
        this.pTranslateCurrent.setLocation(this.pTranslateCurrent.getX() + dx, this.pTranslateCurrent.getY() + dy);
        if (dx == 0.0 && dy == 0.0) {
            return this.pathROI;
        }
        this.setROI(this.pathROI.translate(dx, dy), false);
        return this.pathROI;
    }

    public boolean finishTranslation() {
        boolean displacement;
        boolean bl = displacement = this.isTranslating && this.pTranslateOrigin.distanceSq(this.pTranslateCurrent) > 0.0;
        if (displacement && this.translateSnapToPixel && this.roiTranslateOrigin != null) {
            double dx = Math.round(this.pTranslateCurrent.getX() - this.pTranslateOrigin.getX());
            double dy = Math.round(this.pTranslateCurrent.getY() - this.pTranslateOrigin.getY());
            this.isTranslating = false;
            this.pTranslateOrigin = null;
            this.pTranslateCurrent = null;
            this.setROI(this.roiTranslateOrigin.translate(dx, dy), false);
        } else {
            this.isTranslating = false;
            this.pTranslateOrigin = null;
            this.pTranslateCurrent = null;
        }
        return displacement;
    }

    public boolean isTranslating() {
        return this.isTranslating;
    }

    public void ensureHandlesUpdated() {
        if (this.adjuster == null) {
            return;
        }
        this.adjuster.ensureHandlesUpdated();
    }

    public List<Point2> getHandles() {
        if (this.adjuster == null) {
            return Collections.emptyList();
        }
        return RoiEditor.createPoint2List(this.adjuster.getHandles());
    }

    public boolean hasROI() {
        return this.pathROI != null;
    }

    public ROI getROI() {
        return this.pathROI;
    }

    public boolean hasActiveHandle() {
        return this.activeHandle != null;
    }

    public void resetActiveHandle() {
        this.activeHandle = null;
    }

    public ROI requestNewHandle(double x, double y) {
        if (this.adjuster == null) {
            return this.pathROI;
        }
        this.pathROI = this.adjuster.requestNewHandle(x, y);
        return this.pathROI;
    }

    public boolean grabHandle(double x, double y, double maxDist, boolean shiftDown) {
        if (this.adjuster == null) {
            return false;
        }
        if (this.isTranslating()) {
            logger.error("Cannot grab handle while ROI is being translated - request will be ignored");
            return false;
        }
        this.activeHandle = this.adjuster.grabHandle(x, y, maxDist, shiftDown);
        return this.activeHandle != null;
    }

    public ROI setActiveHandlePosition(double x, double y, double minDisplacement, boolean shiftDown) {
        if (this.adjuster == null || this.activeHandle != null && this.activeHandle.distanceSq(x, y) < minDisplacement * minDisplacement) {
            return this.pathROI;
        }
        this.pathROI = this.adjuster.updateActiveHandleLocation(x, y, shiftDown);
        return this.pathROI;
    }

    static void addPointsToMutablePointList(List<MutablePoint> mutablePoints, List<Point2> points) {
        for (Point2 p : points) {
            mutablePoints.add(new MutablePoint(p.getX(), p.getY()));
        }
    }

    static List<Point2> createPoint2List(List<MutablePoint> mutablePoints) {
        ArrayList<Point2> points = new ArrayList<Point2>(mutablePoints.size());
        for (MutablePoint p : mutablePoints) {
            points.add(new Point2(p.getX(), p.getY()));
        }
        return points;
    }

    static class MutablePoint {
        private double x;
        private double y;

        MutablePoint(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public void setLocation(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double distanceSq(MutablePoint point) {
            return this.distanceSq(point.getX(), point.getY());
        }

        public double distanceSq(double x2, double y2) {
            return (this.x - x2) * (this.x - x2) + (this.y - y2) * (this.y - y2);
        }

        public String toString() {
            return String.format("Mutable point: %.2f, %.2f", this.x, this.y);
        }
    }

    static class RectangleHandleAdjuster
    extends BoundedHandleAdjuster<RectangleROI> {
        RectangleHandleAdjuster(RectangleROI roi) {
            super(roi);
        }

        @Override
        RectangleROI createROI(double x, double y, double width, double height, ImagePlane plane) {
            return new RectangleROI(x, y, width, height, plane);
        }
    }

    static abstract class RoiHandleAdjuster<T extends ROI> {
        final int TOP_LEFT = 0;
        final int TOP_CENTER = 1;
        final int TOP_RIGHT = 2;
        final int CENTER_RIGHT = 3;
        final int BOTTOM_RIGHT = 4;
        final int BOTTOM_CENTER = 5;
        final int BOTTOM_LEFT = 6;
        final int CENTER_LEFT = 7;

        RoiHandleAdjuster() {
        }

        abstract T updateActiveHandleLocation(double var1, double var3, boolean var5);

        abstract void ensureHandlesUpdated();

        abstract MutablePoint grabHandle(double var1, double var3, double var5, boolean var7);

        protected static int getClosestHandleIndex(List<MutablePoint> handles, double x, double y, double maxDist) {
            double closestDist = Double.POSITIVE_INFINITY;
            double distSq = maxDist * maxDist;
            int activeHandleIndex = -1;
            int counter = 0;
            for (MutablePoint p : handles) {
                double dist = p.distanceSq(x, y);
                if (dist <= distSq && dist <= closestDist) {
                    closestDist = dist;
                    activeHandleIndex = counter;
                }
                ++counter;
            }
            return activeHandleIndex;
        }

        abstract List<MutablePoint> getHandles();

        abstract T requestNewHandle(double var1, double var3);
    }

    static class EllipseHandleAdjuster
    extends BoundedHandleAdjuster<EllipseROI> {
        EllipseHandleAdjuster(EllipseROI roi) {
            super(roi);
        }

        @Override
        EllipseROI createROI(double x, double y, double width, double height, ImagePlane plane) {
            return new EllipseROI(x, y, width, height, plane);
        }
    }

    class PolygonHandleAdjuster
    extends RoiHandleAdjuster<PolygonROI> {
        private PolygonROI roi;
        private List<MutablePoint> handles;

        PolygonHandleAdjuster(PolygonROI roi) {
            this.roi = roi;
            this.ensureHandlesUpdated();
        }

        @Override
        void ensureHandlesUpdated() {
            if (this.handles == null) {
                this.handles = new ArrayList<MutablePoint>();
            } else {
                this.handles.clear();
            }
            RoiEditor.addPointsToMutablePointList(this.handles, this.roi.getAllPoints());
            if (this.handles.size() == 1) {
                this.handles.add(new MutablePoint(this.handles.get(0).getX(), this.handles.get(0).getY()));
            }
        }

        @Override
        MutablePoint grabHandle(double x, double y, double maxDist, boolean shiftDown) {
            int activeHandleIndex = PolygonHandleAdjuster.getClosestHandleIndex(this.handles, x, y, maxDist);
            RoiEditor.this.activeHandle = activeHandleIndex >= 0 ? this.handles.get(activeHandleIndex) : null;
            return RoiEditor.this.activeHandle;
        }

        @Override
        PolygonROI updateActiveHandleLocation(double xNew, double yNew, boolean shiftDown) {
            if (RoiEditor.this.activeHandle == null) {
                return this.roi;
            }
            RoiEditor.this.activeHandle.setLocation(xNew, yNew);
            this.roi = new PolygonROI(RoiEditor.createPoint2List(this.handles), this.roi.getImagePlane());
            return this.roi;
        }

        @Override
        List<MutablePoint> getHandles() {
            return this.handles;
        }

        @Override
        public PolygonROI requestNewHandle(double x, double y) {
            if (RoiEditor.this.activeHandle == null) {
                return this.roi;
            }
            boolean lastHandleSame = false;
            if (this.handles.size() >= 2 && RoiEditor.this.activeHandle == this.handles.get(this.handles.size() - 1)) {
                MutablePoint lastHandle = this.handles.get(this.handles.size() - 2);
                if (lastHandle.distanceSq(x, y) < 0.5) {
                    return this.roi;
                }
                boolean bl = lastHandleSame = lastHandle.distanceSq(RoiEditor.this.activeHandle) == 0.0;
            }
            if (lastHandleSame) {
                RoiEditor.this.activeHandle.setLocation(x, y);
            } else {
                RoiEditor.this.activeHandle = new MutablePoint(x, y);
                this.roi = new PolygonROI(RoiEditor.createPoint2List(this.handles), this.roi.getImagePlane());
                this.handles.add(RoiEditor.this.activeHandle);
            }
            return this.roi;
        }
    }

    class PolylineHandleAdjuster
    extends RoiHandleAdjuster<PolylineROI> {
        private PolylineROI roi;
        private List<MutablePoint> handles;

        PolylineHandleAdjuster(PolylineROI roi) {
            this.roi = roi;
            this.ensureHandlesUpdated();
        }

        @Override
        void ensureHandlesUpdated() {
            if (this.handles == null) {
                this.handles = new ArrayList<MutablePoint>();
            } else {
                this.handles.clear();
            }
            RoiEditor.addPointsToMutablePointList(this.handles, this.roi.getAllPoints());
            if (this.handles.size() == 1) {
                this.handles.add(new MutablePoint(this.handles.get(0).getX(), this.handles.get(0).getY()));
            }
        }

        @Override
        MutablePoint grabHandle(double x, double y, double maxDist, boolean shiftDown) {
            int activeHandleIndex = PolylineHandleAdjuster.getClosestHandleIndex(this.handles, x, y, maxDist);
            RoiEditor.this.activeHandle = activeHandleIndex >= 0 ? this.handles.get(activeHandleIndex) : null;
            return RoiEditor.this.activeHandle;
        }

        @Override
        PolylineROI updateActiveHandleLocation(double xNew, double yNew, boolean shiftDown) {
            if (RoiEditor.this.activeHandle == null) {
                return this.roi;
            }
            RoiEditor.this.activeHandle.setLocation(xNew, yNew);
            this.roi = new PolylineROI(RoiEditor.createPoint2List(this.handles), this.roi.getImagePlane());
            return this.roi;
        }

        @Override
        List<MutablePoint> getHandles() {
            return this.handles;
        }

        @Override
        public PolylineROI requestNewHandle(double x, double y) {
            if (RoiEditor.this.activeHandle == null) {
                return this.roi;
            }
            if (this.handles.size() >= 2 && RoiEditor.this.activeHandle == this.handles.get(this.handles.size() - 1) && this.handles.get(this.handles.size() - 2).distanceSq(x, y) < 0.5) {
                return this.roi;
            }
            RoiEditor.this.activeHandle = new MutablePoint(x, y);
            this.roi = new PolylineROI(RoiEditor.createPoint2List(this.handles), this.roi.getImagePlane());
            this.handles.add(RoiEditor.this.activeHandle);
            return this.roi;
        }
    }

    class LineHandleAdjuster
    extends RoiHandleAdjuster<LineROI> {
        private LineROI roi;
        private List<MutablePoint> handles;
        private MutablePoint activeHandle = null;
        private MutablePoint inactiveHandle = null;

        LineHandleAdjuster(RoiEditor this$0, LineROI roi) {
            this.roi = roi;
            this.handles = new ArrayList<MutablePoint>(2);
            this.ensureHandlesUpdated();
        }

        @Override
        MutablePoint grabHandle(double x, double y, double maxDist, boolean shiftDown) {
            int activeHandleIndex = LineHandleAdjuster.getClosestHandleIndex(this.handles, x, y, maxDist);
            if (activeHandleIndex >= 0) {
                this.activeHandle = this.handles.get(activeHandleIndex);
                this.inactiveHandle = this.handles.get(1 - activeHandleIndex);
            } else {
                this.activeHandle = null;
                this.inactiveHandle = null;
            }
            return this.activeHandle;
        }

        @Override
        LineROI updateActiveHandleLocation(double xNew, double yNew, boolean shiftDown) {
            if (this.activeHandle == null) {
                return this.roi;
            }
            double x = this.inactiveHandle.getX();
            double y = this.inactiveHandle.getY();
            if (shiftDown) {
                double w = x - xNew;
                double h = y - yNew;
                if (w != 0.0 && h != 0.0) {
                    int theta = (int)Math.round(Math.atan2(h, w) / Math.PI * 4.0);
                    if (theta % 2 == 0) {
                        if (theta % 4 == 0) {
                            h = 0.0;
                        } else {
                            w = 0.0;
                        }
                    } else {
                        double len = Math.min(Math.abs(w), Math.abs(h));
                        w = Math.signum(w) * len;
                        h = Math.signum(h) * len;
                    }
                }
                xNew = x - w;
                yNew = y - h;
            }
            this.activeHandle.setLocation(xNew, yNew);
            this.roi = new LineROI(this.handles.get(0).getX(), this.handles.get(0).getY(), this.handles.get(1).getX(), this.handles.get(1).getY(), this.roi.getImagePlane());
            return this.roi;
        }

        @Override
        List<MutablePoint> getHandles() {
            return this.handles;
        }

        @Override
        void ensureHandlesUpdated() {
            this.handles.clear();
            this.handles.add(new MutablePoint(this.roi.getX1(), this.roi.getY1()));
            this.handles.add(new MutablePoint(this.roi.getX2(), this.roi.getY2()));
        }

        @Override
        public LineROI requestNewHandle(double x, double y) {
            return this.roi;
        }
    }

    class PointsHandleAdjuster
    extends RoiHandleAdjuster<PointsROI> {
        private PointsROI roi;
        private List<MutablePoint> handles;

        PointsHandleAdjuster(PointsROI roi) {
            this.roi = roi;
            this.ensureHandlesUpdated();
        }

        @Override
        void ensureHandlesUpdated() {
            if (this.handles == null) {
                this.handles = new ArrayList<MutablePoint>();
            } else {
                this.handles.clear();
            }
            RoiEditor.addPointsToMutablePointList(this.handles, this.roi.getAllPoints());
        }

        @Override
        MutablePoint grabHandle(double x, double y, double maxDist, boolean shiftDown) {
            int activeHandleIndex = PointsHandleAdjuster.getClosestHandleIndex(this.handles, x, y, maxDist);
            RoiEditor.this.activeHandle = activeHandleIndex >= 0 ? this.handles.get(activeHandleIndex) : null;
            return RoiEditor.this.activeHandle;
        }

        @Override
        PointsROI updateActiveHandleLocation(double xNew, double yNew, boolean shiftDown) {
            if (RoiEditor.this.activeHandle == null) {
                return this.roi;
            }
            RoiEditor.this.activeHandle.setLocation(xNew, yNew);
            this.roi = new PointsROI(RoiEditor.createPoint2List(this.handles), this.roi.getImagePlane());
            this.ensureHandlesUpdated();
            RoiEditor.this.activeHandle = this.grabHandle(xNew, yNew, Double.POSITIVE_INFINITY, shiftDown);
            return this.roi;
        }

        @Override
        List<MutablePoint> getHandles() {
            return this.handles;
        }

        @Override
        public PointsROI requestNewHandle(double x, double y) {
            RoiEditor.this.activeHandle = new MutablePoint(x, y);
            this.handles.add(RoiEditor.this.activeHandle);
            this.roi = new PointsROI(RoiEditor.createPoint2List(this.handles), this.roi.getImagePlane());
            this.ensureHandlesUpdated();
            RoiEditor.this.activeHandle = this.grabHandle(x, y, Double.POSITIVE_INFINITY, false);
            return this.roi;
        }
    }

    static class Rect {
        private double x;
        private double y;
        private double width;
        private double height;

        Rect(double x, double y, double width, double height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public double getMinX() {
            return this.x;
        }

        public double getMinY() {
            return this.y;
        }

        public double getCenterX() {
            return this.x + this.width / 2.0;
        }

        public double getCenterY() {
            return this.y + this.height / 2.0;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public double getMaxX() {
            return this.x + this.width;
        }

        public double getMaxY() {
            return this.y + this.height;
        }
    }

    static abstract class BoundedHandleAdjuster<T extends AbstractPathBoundedROI>
    extends RoiHandleAdjuster<T> {
        private T roi;
        private List<MutablePoint> handles = new ArrayList<MutablePoint>(8);
        private Rect bounds;
        private double x;
        private double y;
        private double x2;
        private double y2;
        protected int activeHandleIndex = -1;

        BoundedHandleAdjuster(T roi) {
            this.roi = roi;
            this.bounds = new Rect(((AbstractPathBoundedROI)roi).getBoundsX(), ((AbstractPathBoundedROI)roi).getBoundsY(), ((AbstractPathBoundedROI)roi).getBoundsWidth(), ((AbstractPathBoundedROI)roi).getBoundsHeight());
            this.handles.clear();
            for (int i = 0; i < 8; ++i) {
                this.handles.add(new MutablePoint(Double.NaN, Double.NaN));
            }
        }

        @Override
        void ensureHandlesUpdated() {
            this.updateHandles();
        }

        private void setupCoords(boolean xMinChange, boolean yMinChange) {
            if (xMinChange) {
                this.x = this.bounds.getMaxX();
                this.x2 = this.bounds.getMinX();
            } else {
                this.x = this.bounds.getMinX();
                this.x2 = this.bounds.getMaxX();
            }
            if (yMinChange) {
                this.y = this.bounds.getMaxY();
                this.y2 = this.bounds.getMinY();
            } else {
                this.y = this.bounds.getMinY();
                this.y2 = this.bounds.getMaxY();
            }
        }

        static boolean handlesOverlap(List<MutablePoint> handles) {
            if (handles.isEmpty()) {
                return false;
            }
            MutablePoint h1 = handles.get(0);
            for (MutablePoint h : handles) {
                if (!(h1.distanceSq(h) > 0.0)) continue;
                return false;
            }
            return true;
        }

        @Override
        MutablePoint grabHandle(double x, double y, double maxDist, boolean shiftDown) {
            List<MutablePoint> handles = this.getHandles();
            this.activeHandleIndex = BoundedHandleAdjuster.handlesOverlap(handles) ? 4 : BoundedHandleAdjuster.getClosestHandleIndex(handles, x, y, maxDist);
            if (this.activeHandleIndex < 0) {
                return null;
            }
            switch (this.activeHandleIndex) {
                case 0: {
                    this.setupCoords(true, true);
                    break;
                }
                case 1: {
                    this.setupCoords(false, true);
                    break;
                }
                case 2: {
                    this.setupCoords(false, true);
                    break;
                }
                case 3: {
                    this.setupCoords(false, false);
                    break;
                }
                case 4: {
                    this.setupCoords(false, false);
                    break;
                }
                case 5: {
                    this.setupCoords(false, false);
                    break;
                }
                case 6: {
                    this.setupCoords(true, false);
                    break;
                }
                case 7: {
                    this.setupCoords(true, false);
                }
            }
            return handles.get(this.activeHandleIndex);
        }

        void updateHandles() {
            this.bounds = new Rect(((AbstractPathBoundedROI)this.roi).getBoundsX(), ((AbstractPathBoundedROI)this.roi).getBoundsY(), ((AbstractPathBoundedROI)this.roi).getBoundsWidth(), ((AbstractPathBoundedROI)this.roi).getBoundsHeight());
            this.handles.get(0).setLocation(this.bounds.getMinX(), this.bounds.getMinY());
            this.handles.get(1).setLocation(this.bounds.getCenterX(), this.bounds.getMinY());
            this.handles.get(2).setLocation(this.bounds.getMaxX(), this.bounds.getMinY());
            this.handles.get(3).setLocation(this.bounds.getMaxX(), this.bounds.getCenterY());
            this.handles.get(4).setLocation(this.bounds.getMaxX(), this.bounds.getMaxY());
            this.handles.get(5).setLocation(this.bounds.getCenterX(), this.bounds.getMaxY());
            this.handles.get(6).setLocation(this.bounds.getMinX(), this.bounds.getMaxY());
            this.handles.get(7).setLocation(this.bounds.getMinX(), this.bounds.getCenterY());
        }

        @Override
        T updateActiveHandleLocation(double xNew, double yNew, boolean shiftDown) {
            if (this.activeHandleIndex < 0) {
                return this.roi;
            }
            boolean isCorner = false;
            switch (this.activeHandleIndex) {
                case 0: {
                    this.x2 = xNew;
                    this.y2 = yNew;
                    isCorner = true;
                    break;
                }
                case 1: {
                    this.y2 = yNew;
                    break;
                }
                case 2: {
                    this.x2 = xNew;
                    this.y2 = yNew;
                    isCorner = true;
                    break;
                }
                case 3: {
                    this.x2 = xNew;
                    break;
                }
                case 4: {
                    this.x2 = xNew;
                    this.y2 = yNew;
                    isCorner = true;
                    break;
                }
                case 5: {
                    this.y2 = yNew;
                    break;
                }
                case 6: {
                    this.x2 = xNew;
                    this.y2 = yNew;
                    isCorner = true;
                    break;
                }
                case 7: {
                    this.x2 = xNew;
                }
            }
            if (shiftDown && isCorner) {
                double w = this.x - xNew;
                double h = this.y - yNew;
                if (w != 0.0 && h != 0.0) {
                    double len = Math.min(Math.abs(w), Math.abs(h));
                    w = Math.signum(w) * len;
                    h = Math.signum(h) * len;
                }
                this.x2 = this.x - w;
                this.y2 = this.y - h;
            }
            this.roi = this.createROI(Math.min(this.x, this.x2), Math.min(this.y, this.y2), Math.abs(this.x - this.x2), Math.abs(this.y - this.y2), ((AbstractPathROI)this.roi).getImagePlane());
            return this.roi;
        }

        abstract T createROI(double var1, double var3, double var5, double var7, ImagePlane var9);

        @Override
        List<MutablePoint> getHandles() {
            this.updateHandles();
            return this.handles;
        }

        @Override
        public T requestNewHandle(double x, double y) {
            return this.roi;
        }
    }
}

