/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.PolygonROI;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class ShapeSimplifier {
    public static void simplifyPolygonPoints(List<Point2> points, double altitudeThreshold) {
        PointWithArea pwa;
        double altitude;
        if (points.size() <= 1) {
            return;
        }
        Iterator<Point2> iter = points.iterator();
        Point2 lastPoint = iter.next();
        while (iter.hasNext()) {
            Point2 nextPoint = iter.next();
            if (nextPoint.equals(lastPoint)) {
                iter.remove();
                continue;
            }
            lastPoint = nextPoint;
        }
        if (lastPoint.equals(points.get(0))) {
            iter.remove();
        }
        if (points.size() <= 3) {
            return;
        }
        int n = points.size();
        PriorityQueue<PointWithArea> queue = new PriorityQueue<PointWithArea>();
        Point2 pPrevious = points.get(points.size() - 1);
        Point2 pCurrent = points.get(0);
        PointWithArea pwaPrevious = null;
        PointWithArea pwaFirst = null;
        for (int i = 0; i < n; ++i) {
            Point2 pNext = points.get((i + 1) % n);
            PointWithArea pwa2 = new PointWithArea(pCurrent, ShapeSimplifier.calculateArea(pPrevious, pCurrent, pNext));
            pwa2.setPrevious(pwaPrevious);
            if (pwaPrevious != null) {
                pwaPrevious.setNext(pwa2);
            }
            queue.add(pwa2);
            pwaPrevious = pwa2;
            pPrevious = pCurrent;
            pCurrent = pNext;
            if (i == n - 1) {
                pwa2.setNext(pwaFirst);
                pwaFirst.setPrevious(pwa2);
                continue;
            }
            if (i != 0) continue;
            pwaFirst = pwa2;
        }
        double maxArea = 0.0;
        int minSize = Math.max(n / 100, 3);
        HashSet<Point2> toRemove = new HashSet<Point2>();
        while (queue.size() > minSize && !((altitude = (pwa = (PointWithArea)queue.poll()).getArea() * 2.0 / pwa.getNext().getPoint().distance(pwa.getPrevious().getPoint())) > altitudeThreshold)) {
            if (pwa.getArea() < maxArea) {
                pwa.setArea(maxArea);
            } else {
                maxArea = pwa.getArea();
            }
            toRemove.add(pwa.getPoint());
            pwaPrevious = pwa.getPrevious();
            PointWithArea pwaNext = pwa.getNext();
            pwaPrevious.setNext(pwaNext);
            pwaPrevious.updateArea();
            pwaNext.setPrevious(pwaPrevious);
            pwaNext.updateArea();
            queue.remove(pwaPrevious);
            queue.remove(pwaNext);
            queue.add(pwaPrevious);
            queue.add(pwaNext);
        }
        points.removeAll(toRemove);
    }

    public static PolygonROI simplifyPolygon(PolygonROI polygon, double altitudeThreshold) {
        List<Point2> points = polygon.getAllPoints();
        ShapeSimplifier.simplifyPolygonPoints(points, altitudeThreshold);
        return ROIs.createPolygonROI(points, ImagePlane.getPlaneWithChannel(polygon));
    }

    static double calculateArea(Point2 p1, Point2 p2, Point2 p3) {
        return Math.abs(0.5 * (p1.getX() * (p2.getY() - p3.getY()) + p2.getX() * (p3.getY() - p1.getY()) + p3.getX() * (p1.getY() - p2.getY())));
    }

    public static ROI simplifyShape(ROI shapeROI, double altitudeThreshold) {
        Shape shape = RoiTools.getShape(shapeROI);
        Path2D path = shape instanceof Path2D ? (Path2D)shape : new Path2D.Float(shape);
        path = ShapeSimplifier.simplifyPath(path, altitudeThreshold);
        return RoiTools.getShapeROI(path, shapeROI.getImagePlane(), 0.5);
    }

    public static Path2D simplifyPath(Path2D path, double altitudeThreshold) {
        ArrayList<Point2> points = new ArrayList<Point2>();
        PathIterator iter = path.getPathIterator(null, 0.5);
        Path2D.Float pathNew = new Path2D.Float();
        while (!iter.isDone()) {
            points.clear();
            ShapeSimplifier.getNextClosedSegment(iter, points);
            if (points.isEmpty()) break;
            ShapeSimplifier.simplifyPolygonPoints(points, altitudeThreshold);
            boolean firstPoint = true;
            for (Point2 p : points) {
                double xx = p.getX();
                double yy = p.getY();
                if (firstPoint) {
                    ((Path2D)pathNew).moveTo(xx, yy);
                    firstPoint = false;
                    continue;
                }
                ((Path2D)pathNew).lineTo(xx, yy);
            }
            pathNew.closePath();
        }
        return pathNew;
    }

    private static void getNextClosedSegment(PathIterator iter, List<Point2> points) {
        double[] seg = new double[6];
        while (!iter.isDone()) {
            switch (iter.currentSegment(seg)) {
                case 0: 
                case 1: {
                    points.add(new Point2(seg[0], seg[1]));
                    break;
                }
                case 4: {
                    iter.next();
                    return;
                }
                default: {
                    throw new RuntimeException("Invalid path iterator " + String.valueOf(iter) + " - only line connections are allowed");
                }
            }
            iter.next();
        }
    }

    public static List<Point2> smoothPoints(List<Point2> points) {
        ArrayList<Point2> points2 = new ArrayList<Point2>(points.size());
        for (int i = 0; i < points.size(); ++i) {
            Point2 p1 = points.get((i + points.size() - 1) % points.size());
            Point2 p2 = points.get(i);
            Point2 p3 = points.get((i + 1) % points.size());
            points2.add(new Point2((p1.getX() + p2.getX() + p3.getX()) / 3.0, (p1.getY() + p2.getY() + p3.getY()) / 3.0));
        }
        return points2;
    }

    static class PointWithArea
    implements Comparable<PointWithArea> {
        private PointWithArea pPrevious;
        private PointWithArea pNext;
        private Point2 p;
        private double area;

        PointWithArea(Point2 p, double area) {
            this.p = p;
            this.area = area;
        }

        public void setArea(double area) {
            this.area = area;
        }

        public void updateArea() {
            this.area = ShapeSimplifier.calculateArea(this.pPrevious.getPoint(), this.p, this.pNext.getPoint());
        }

        public double getX() {
            return this.p.getX();
        }

        public double getY() {
            return this.p.getY();
        }

        public double getArea() {
            return this.area;
        }

        public Point2 getPoint() {
            return this.p;
        }

        public void setPrevious(PointWithArea pPrevious) {
            this.pPrevious = pPrevious;
        }

        public void setNext(PointWithArea pNext) {
            this.pNext = pNext;
        }

        public PointWithArea getPrevious() {
            return this.pPrevious;
        }

        public PointWithArea getNext() {
            return this.pNext;
        }

        @Override
        public int compareTo(PointWithArea p) {
            return this.area < p.area ? -1 : (this.area == p.area ? 0 : 1);
        }

        public String toString() {
            return this.getX() + ", " + this.getY() + ", Area: " + this.getArea();
        }
    }
}

