/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.util.List;
import qupath.lib.geom.Point2;
import qupath.lib.roi.Vertices;

class WindingTest {
    WindingTest() {
    }

    public static int isLeft(double x1, double y1, double x2, double y2, double x3, double y3) {
        return (int)Math.signum((x2 - x1) * (y3 - y1) - (x3 - x1) * (y2 - y1));
    }

    public static int getWindingNumber(List<Point2> points, double x, double y) {
        if (points.size() <= 2) {
            return 0;
        }
        int nPoints = points.size();
        int wn = 0;
        for (int i = 0; i < nPoints; ++i) {
            Point2 p = points.get(i);
            Point2 p2 = points.get((i + 1) % nPoints);
            if (p.getY() <= y) {
                if (!(p2.getY() > y) || WindingTest.isLeft(p.getX(), p.getY(), p2.getX(), p2.getY(), x, y) <= 0) continue;
                ++wn;
                continue;
            }
            if (!(p2.getY() <= y) || WindingTest.isLeft(p.getX(), p.getY(), p2.getX(), p2.getY(), x, y) >= 0) continue;
            --wn;
        }
        return wn;
    }

    public static int getWindingNumber(Vertices vertices, double x, double y) {
        if (vertices.size() <= 2) {
            return 0;
        }
        int nPoints = vertices.size();
        int wn = 0;
        for (int i = 0; i < nPoints; ++i) {
            Point2 p = vertices.get(i);
            Point2 p2 = vertices.get((i + 1) % nPoints);
            if (p.getY() <= y) {
                if (!(p2.getY() > y) || WindingTest.isLeft(p.getX(), p.getY(), p2.getX(), p2.getY(), x, y) <= 0) continue;
                ++wn;
                continue;
            }
            if (!(p2.getY() <= y) || WindingTest.isLeft(p.getX(), p.getY(), p2.getX(), p2.getY(), x, y) >= 0) continue;
            --wn;
        }
        return wn;
    }
}

