/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi.interfaces;

import java.awt.Shape;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;

public interface ROI {
    public String getRoiName();

    public int getC();

    public int getT();

    public int getZ();

    public ImagePlane getImagePlane();

    public double getCentroidX();

    public double getCentroidY();

    public double getBoundsX();

    public double getBoundsY();

    public double getBoundsWidth();

    public double getBoundsHeight();

    public List<Point2> getAllPoints();

    public int getNumPoints();

    public boolean isEmpty();

    @Deprecated
    public ROI duplicate();

    public Shape getShape();

    public Geometry getGeometry();

    public RoiType getRoiType();

    public boolean isLine();

    public boolean isArea();

    public boolean isPoint();

    public ROI translate(double var1, double var3);

    public ROI scale(double var1, double var3, double var5, double var7);

    default public ROI scale(double scaleX, double scaleY) {
        return this.scale(scaleX, scaleY, 0.0, 0.0);
    }

    public double getArea();

    public double getScaledArea(double var1, double var3);

    public double getLength();

    public double getScaledLength(double var1, double var3);

    public ROI getConvexHull();

    public double getSolidity();

    public boolean contains(double var1, double var3);

    public ROI updatePlane(ImagePlane var1);

    public static enum RoiType {
        AREA,
        LINE,
        POINT;

    }
}

