/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.bioformats;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.servers.FileFormatInfo;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.bioformats.BioFormatsImageServer;
import qupath.lib.images.servers.bioformats.BioFormatsServerOptions;

public class BioFormatsServerBuilder
implements ImageServerBuilder<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(BioFormatsServerBuilder.class);

    public ImageServer<BufferedImage> buildServer(URI uri, String ... args) {
        try {
            BioFormatsImageServer server = new BioFormatsImageServer(uri, args);
            return server;
        }
        catch (Exception e) {
            logger.error("Unable to open {}: {}", new Object[]{uri, e.getMessage(), e});
            return null;
        }
    }

    public ImageServerBuilder.UriImageSupport<BufferedImage> checkImageSupport(URI uri, String ... args) throws IOException {
        float supportLevel = BioFormatsServerBuilder.supportLevel(uri, args);
        if (supportLevel > 0.0f) {
            ImageServerBuilder.UriImageSupport nPixels2;
            block13: {
                BioFormatsImageServer server = BioFormatsImageServer.checkSupport(uri, BioFormatsServerOptions.getInstance(), args);
                try {
                    Map<String, Object> builders = args.length > 0 && (Arrays.asList(args).contains("--series") || Arrays.asList(args).contains("--name")) ? Collections.singletonMap(server.getMetadata().getName(), server.getBuilder()) : server.getImageBuilders();
                    if ("OME-TIFF".equals(server.getFormat())) {
                        supportLevel = 5.0f;
                    }
                    if (server.nResolutions() == 1) {
                        long nPixels2 = (long)server.getWidth() * (long)server.getHeight();
                        long nBytes = nPixels2 * (long)server.nChannels() * (long)server.getMetadata().getPixelType().getBytesPerPixel();
                        if (nPixels2 >= Integer.MAX_VALUE || nBytes > Runtime.getRuntime().maxMemory() / 2L) {
                            supportLevel = 1.0f;
                        }
                    }
                    nPixels2 = ImageServerBuilder.UriImageSupport.createInstance(this.getClass(), (float)supportLevel, builders.values());
                    if (server == null) break block13;
                }
                catch (Throwable builders) {
                    try {
                        if (server != null) {
                            try {
                                server.close();
                            }
                            catch (Throwable nPixels2) {
                                builders.addSuppressed(nPixels2);
                            }
                        }
                        throw builders;
                    }
                    catch (Exception e) {
                        IOException ioe;
                        String msg;
                        if (e instanceof IOException && (msg = (ioe = (IOException)e).getLocalizedMessage()) != null && msg.toLowerCase().contains("apple silicon")) {
                            throw ioe;
                        }
                        logger.debug("Unable to create server using Bio-Formats", (Throwable)e);
                    }
                }
                server.close();
            }
            return nPixels2;
        }
        return null;
    }

    private static float supportLevel(URI uri, String ... args) {
        if (BioFormatsServerBuilder.getBioFormatsVersion() == null) {
            return 0.0f;
        }
        FileFormatInfo.ImageCheckType type = FileFormatInfo.checkType((URI)uri);
        String path = uri.getPath();
        if (path == null) {
            return 0.0f;
        }
        BioFormatsServerOptions options = BioFormatsServerOptions.getInstance();
        if (type.isURL() && options.getFilesOnly()) {
            logger.debug("Cannot open URL with Bio-Formats - 'Bio-Formats files only' preference is turned on");
            return 0.0f;
        }
        switch (BioFormatsServerBuilder.checkPath(options, path)) {
            case YES: {
                return 5.0f;
            }
            case NO: {
                return 0.0f;
            }
        }
        path = path.toLowerCase();
        float support = type.isURL() ? 1.0f : 3.0f;
        String description = type.getDescription();
        if (path.endsWith(".zip")) {
            support = 1.0f;
        } else if (type.isTiff()) {
            if (!type.isBigTiff() && type.getFile().length() >= 0x100000000L) {
                support = 2.0f;
            }
            if (description != null) {
                if (description.contains("<OME ")) {
                    support = 5.0f;
                }
                if (description.contains("imagej")) {
                    support = 3.5f;
                }
                if (path.endsWith(".qptiff")) {
                    support = 3.5f;
                }
            }
            if (path.endsWith(".ome.tif") || path.endsWith(".ome.tiff")) {
                support = 5.0f;
            }
        } else {
            File file = type.getFile();
            String string = path = file != null ? file.getAbsolutePath() : path;
            if (path != null) {
                String supportedReader = null;
                try {
                    supportedReader = BioFormatsImageServer.getSupportedReaderClass(path);
                }
                catch (Exception e) {
                    logger.warn("Error checking file " + path, (Throwable)e);
                }
                if (supportedReader == null) {
                    logger.debug("No supported reader found for {}", (Object)path);
                    return file == null ? 0.0f : 1.0f;
                }
                logger.debug("Potential Bio-Formats reader: {}", (Object)supportedReader);
            }
        }
        return support;
    }

    public String getName() {
        return "Bio-Formats builder";
    }

    public String getDescription() {
        String bfVersion = BioFormatsServerBuilder.getBioFormatsVersion();
        if (bfVersion == null) {
            return "Image server using the Bio-Formats library - but it won't work because 'bioformats_package.jar' is missing.";
        }
        return "Image server using the Bio-Formats library (" + bfVersion + ")";
    }

    public Class<BufferedImage> getImageType() {
        return BufferedImage.class;
    }

    public boolean matchClassName(String ... classNames) {
        for (String className : classNames) {
            if (!this.getClass().getName().equals(className) && !this.getClass().getSimpleName().equals(className) && !BioFormatsImageServer.class.getName().equals(className) && !BioFormatsImageServer.class.getSimpleName().equals(className) && !"bioformats".equalsIgnoreCase(className)) continue;
            return true;
        }
        return false;
    }

    static String getBioFormatsVersion() {
        try {
            Class<?> cls = Class.forName("loci.formats.FormatTools");
            return (String)cls.getField("VERSION").get(null);
        }
        catch (Exception e) {
            logger.error("Error requesting version from Bio-Formats", (Throwable)e);
            return null;
        }
    }

    static BioFormatsServerOptions.UseBioformats checkPath(BioFormatsServerOptions options, String path) {
        if (!options.bioformatsEnabled()) {
            return BioFormatsServerOptions.UseBioformats.NO;
        }
        String pathLower = path.toLowerCase();
        for (String ext : options.getSkipAlwaysExtensions()) {
            if (!pathLower.endsWith(ext.toLowerCase())) continue;
            return BioFormatsServerOptions.UseBioformats.NO;
        }
        for (String ext : options.getUseAlwaysExtensions()) {
            if (!pathLower.endsWith(ext.toLowerCase())) continue;
            return BioFormatsServerOptions.UseBioformats.YES;
        }
        return BioFormatsServerOptions.UseBioformats.MAYBE;
    }
}

