/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.bioformats;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.Version;
import qupath.lib.images.servers.bioformats.BioFormatsServerBuilder;

public class BioFormatsServerOptions {
    private static final Logger logger = LoggerFactory.getLogger(BioFormatsServerOptions.class);
    public static String ALLOW_MEMOIZATION_PROPERTY = "qupath.bioformats.allow.memoization";
    private static boolean allowMemoization = BioFormatsServerOptions.checkIfMemoizationSupported();
    private static BioFormatsServerOptions instance = new BioFormatsServerOptions();
    private boolean bioformatsEnabled = true;
    private int maxReaders = -1;
    private Set<String> skipExtensions = new TreeSet<String>();
    private Set<String> useExtensions = new TreeSet<String>();
    private boolean requestParallelization = true;
    private boolean filesOnly = true;
    private int memoizationTimeMillis = -1;
    private String pathMemoization;
    private Map<String, String> readerOptions = new LinkedHashMap<String, String>();

    private static boolean checkIfMemoizationSupported() {
        String prop = System.getProperty(ALLOW_MEMOIZATION_PROPERTY);
        if (prop != null) {
            prop = prop.strip().toLowerCase();
        }
        if ("true".equals(prop)) {
            logger.info("Bio-Formats memoization is enabled (based on system property)");
            return true;
        }
        if ("false".equals(prop)) {
            logger.info("Bio-Formats memoization is unavailable (based on system property)");
            return false;
        }
        try {
            boolean compatibleBioFormats;
            Runtime.Version javaVersion = Runtime.version();
            if (javaVersion.feature() < 17) {
                return true;
            }
            String bfVersionString = BioFormatsServerBuilder.getBioFormatsVersion();
            Version bfVersion = bfVersionString == null ? Version.parse((String)"0.0.1") : Version.parse((String)bfVersionString);
            boolean bl = compatibleBioFormats = bfVersion.compareTo(Version.parse((String)"6.12.0")) >= 0;
            if (compatibleBioFormats) {
                logger.debug("Bio-Formats memoization is enabled (based on Java " + String.valueOf(javaVersion) + ", Bio-Formats " + String.valueOf(bfVersion) + ")");
                return true;
            }
            logger.debug("Bio-Formats memoization is unavailable (based on Java " + String.valueOf(javaVersion) + ", Bio-Formats " + String.valueOf(bfVersion) + ")");
            return false;
        }
        catch (Exception e) {
            logger.warn("Bio-Formats memoization is enabled, but may not be supported (unknown Java or Bio-Formats version)");
            return true;
        }
    }

    private BioFormatsServerOptions() {
    }

    int getMaxReaders() {
        if (this.maxReaders <= 0) {
            this.maxReaders = Math.min(Math.max(2, Runtime.getRuntime().availableProcessors()), 32);
            logger.info("Setting max Bio-Formats readers to {}", (Object)this.maxReaders);
        }
        return this.requestParallelization ? this.maxReaders : 1;
    }

    void setMaxReaders(int maxReaders) {
        this.maxReaders = maxReaders;
    }

    public String getPathMemoization() {
        return this.pathMemoization;
    }

    public void setPathMemoization(String pathMemoization) {
        this.pathMemoization = pathMemoization;
    }

    public synchronized Map<String, String> getReaderOptions() {
        return new LinkedHashMap<String, String>(this.readerOptions);
    }

    public synchronized void clearReaderOptions() {
        this.readerOptions.clear();
    }

    public synchronized void setReaderOptions(Map<String, String> options) {
        this.readerOptions.clear();
        if (options != null && !options.isEmpty()) {
            this.readerOptions.putAll(options);
        }
    }

    public static BioFormatsServerOptions getInstance() {
        return instance;
    }

    public boolean bioformatsEnabled() {
        return this.bioformatsEnabled;
    }

    public void setBioformatsEnabled(boolean bioformatsEnabled) {
        this.bioformatsEnabled = bioformatsEnabled;
    }

    public void setFilesOnly(boolean filesOnly) {
        this.filesOnly = filesOnly;
    }

    public boolean getFilesOnly() {
        return this.filesOnly;
    }

    public int getMemoizationTimeMillis() {
        return this.memoizationTimeMillis;
    }

    public void setMemoizationTimeMillis(int memoizationTimeMillis) {
        this.memoizationTimeMillis = memoizationTimeMillis;
    }

    public boolean requestParallelization() {
        return this.requestParallelization;
    }

    public void setRequestParallelization(boolean requestParallelization) {
        this.requestParallelization = requestParallelization;
    }

    public Set<String> getSkipAlwaysExtensions() {
        return this.skipExtensions;
    }

    public Set<String> getUseAlwaysExtensions() {
        return this.useExtensions;
    }

    public static boolean allowMemoization() {
        return allowMemoization;
    }

    static enum UseBioformats {
        YES,
        NO,
        MAYBE;

    }
}

