/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.bioformats;

import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import loci.common.DataTools;
import qupath.lib.images.servers.PixelType;

public class OMEPixelParser {
    private final boolean isInterleaved;
    private final PixelType pixelType;
    private final ByteOrder byteOrder;
    private final boolean normalizeFloats;
    private final int effectiveNChannels;
    private final int[] samplesPerPixel;

    private OMEPixelParser(Builder builder) {
        this.isInterleaved = builder.isInterleaved;
        this.pixelType = builder.pixelType;
        this.byteOrder = builder.byteOrder;
        this.normalizeFloats = builder.normalizeFloats;
        this.effectiveNChannels = builder.effectiveNChannels;
        this.samplesPerPixel = builder.samplesPerPixel;
    }

    public BufferedImage parse(byte[][] pixels, int width, int height, int nChannels, ColorModel colorModel) {
        DataBuffer dataBuffer = this.bytesToDataBuffer(pixels);
        SampleModel sampleModel = this.createSampleModel(width, height, nChannels, dataBuffer.getDataType());
        WritableRaster raster = WritableRaster.createWritableRaster(sampleModel, dataBuffer, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    private DataBuffer bytesToDataBuffer(byte[][] bytes) {
        return switch (this.pixelType) {
            default -> throw new MatchException(null, null);
            case PixelType.UINT8 -> new DataBufferByte(bytes, bytes[0].length);
            case PixelType.UINT16, PixelType.INT16 -> {
                short[][] array = new short[bytes.length][];
                for (int i = 0; i < bytes.length; ++i) {
                    ShortBuffer buffer = ByteBuffer.wrap(bytes[i]).order(this.byteOrder).asShortBuffer();
                    array[i] = new short[buffer.limit()];
                    buffer.get(array[i]);
                }
                if (this.pixelType == PixelType.UINT16) {
                    yield new DataBufferUShort(array, bytes[0].length / 2);
                }
                yield new DataBufferShort(array, bytes[0].length / 2);
            }
            case PixelType.INT32 -> {
                int[][] array = new int[bytes.length][];
                for (int i = 0; i < bytes.length; ++i) {
                    IntBuffer buffer = ByteBuffer.wrap(bytes[i]).order(this.byteOrder).asIntBuffer();
                    array[i] = new int[buffer.limit()];
                    buffer.get(array[i]);
                }
                yield new DataBufferInt(array, bytes[0].length / 4);
            }
            case PixelType.FLOAT32 -> {
                float[][] array = new float[bytes.length][];
                for (int i = 0; i < bytes.length; ++i) {
                    FloatBuffer buffer = ByteBuffer.wrap(bytes[i]).order(this.byteOrder).asFloatBuffer();
                    array[i] = new float[buffer.limit()];
                    buffer.get(array[i]);
                    if (!this.normalizeFloats) continue;
                    array[i] = DataTools.normalizeFloats((float[])array[i]);
                }
                yield new DataBufferFloat(array, bytes[0].length / 4);
            }
            case PixelType.FLOAT64 -> {
                double[][] array = new double[bytes.length][];
                for (int i = 0; i < bytes.length; ++i) {
                    DoubleBuffer buffer = ByteBuffer.wrap(bytes[i]).order(this.byteOrder).asDoubleBuffer();
                    array[i] = new double[buffer.limit()];
                    buffer.get(array[i]);
                    if (!this.normalizeFloats) continue;
                    array[i] = DataTools.normalizeDoubles((double[])array[i]);
                }
                yield new DataBufferDouble(array, bytes[0].length / 8);
            }
            case PixelType.INT8, PixelType.UINT32 -> throw new UnsupportedOperationException("Unsupported pixel type " + String.valueOf(this.pixelType));
        };
    }

    private SampleModel createSampleModel(int width, int height, int nChannels, int datatype) {
        if (this.effectiveNChannels == 1 && nChannels > 1) {
            int[] offsets = new int[nChannels];
            if (this.isInterleaved) {
                for (int b = 0; b < nChannels; ++b) {
                    offsets[b] = b;
                }
                return new PixelInterleavedSampleModel(datatype, width, height, nChannels, nChannels * width, offsets);
            }
            for (int b = 0; b < nChannels; ++b) {
                offsets[b] = b * width * height;
            }
            return new ComponentSampleModel(datatype, width, height, 1, width, offsets);
        }
        if (nChannels > this.effectiveNChannels) {
            int[] offsets = new int[nChannels];
            int[] bandInds = new int[nChannels];
            int ind = 0;
            for (int cInd = 0; cInd < this.samplesPerPixel.length; ++cInd) {
                int nSamples = this.samplesPerPixel[cInd];
                for (int s = 0; s < nSamples; ++s) {
                    bandInds[ind] = cInd;
                    offsets[ind] = this.isInterleaved ? s : s * width * height;
                    ++ind;
                }
            }
            int pixelStride = nChannels / this.effectiveNChannels;
            int scanlineStride = pixelStride * width;
            return new ComponentSampleModel(datatype, width, height, pixelStride, scanlineStride, bandInds, offsets);
        }
        return new BandedSampleModel(datatype, width, height, nChannels);
    }

    public static class Builder {
        private boolean isInterleaved = false;
        private PixelType pixelType;
        private ByteOrder byteOrder;
        private boolean normalizeFloats;
        private int effectiveNChannels;
        private int[] samplesPerPixel;

        public Builder isInterleaved(boolean isInterleaved) {
            this.isInterleaved = isInterleaved;
            return this;
        }

        public Builder pixelType(PixelType pixelType) {
            this.pixelType = pixelType;
            return this;
        }

        public Builder byteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public Builder effectiveNChannels(int effectiveNChannels) {
            this.effectiveNChannels = effectiveNChannels;
            return this;
        }

        public Builder normalizeFloats(boolean normalizeFloats) {
            this.normalizeFloats = normalizeFloats;
            return this;
        }

        public Builder samplesPerPixel(int[] samplesPerPixel) {
            this.samplesPerPixel = samplesPerPixel;
            return this;
        }

        public OMEPixelParser build() {
            return new OMEPixelParser(this);
        }
    }
}

