/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.writers.ome;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import loci.common.ByteArrayHandle;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.formats.FormatException;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.WrappedBufferedImageServer;
import qupath.lib.images.writers.ImageWriter;
import qupath.lib.images.writers.ome.OMEPyramidWriter;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

public class OMETiffWriter
implements ImageWriter<BufferedImage> {
    public String getName() {
        return "OME TIFF";
    }

    public Collection<String> getExtensions() {
        return Arrays.asList("ome.tif", "ome.tiff");
    }

    public boolean supportsT() {
        return true;
    }

    public boolean supportsZ() {
        return true;
    }

    public boolean supportsRGB() {
        return true;
    }

    public boolean supportsImageType(ImageServer<BufferedImage> server) {
        return true;
    }

    public boolean supportsPyramidal() {
        return true;
    }

    public boolean supportsPixelSize() {
        return true;
    }

    public String getDetails() {
        return "Write image as an OME-TIFF image using Bio-Formats. Format is flexible, preserving most image metadata.";
    }

    public Class<BufferedImage> getImageClass() {
        return BufferedImage.class;
    }

    public void writeImage(ImageServer<BufferedImage> server, RegionRequest region, String pathOutput) throws IOException {
        try {
            OMEPyramidWriter.writeImage(server, pathOutput, OMEPyramidWriter.CompressionType.DEFAULT, (ImageRegion)region);
        }
        catch (FormatException e) {
            throw new IOException(e);
        }
    }

    public void writeImage(BufferedImage img, String pathOutput) throws IOException {
        this.writeImage((ImageServer<BufferedImage>)new WrappedBufferedImageServer(pathOutput, img), RegionRequest.createInstance((String)pathOutput, (double)1.0, (int)0, (int)0, (int)img.getWidth(), (int)img.getHeight(), (int)0, (int)0), pathOutput);
    }

    public void writeImage(ImageServer<BufferedImage> server, String pathOutput) throws IOException {
        try {
            OMEPyramidWriter.writeImage(server, pathOutput, OMEPyramidWriter.CompressionType.DEFAULT);
        }
        catch (FormatException e) {
            throw new IOException(e);
        }
    }

    private String createInMemoryID(IRandomAccess access) {
        String id = UUID.randomUUID().toString() + "." + this.getDefaultExtension();
        Location.mapFile((String)id, (IRandomAccess)access);
        return id;
    }

    public void writeImage(ImageServer<BufferedImage> server, RegionRequest region, OutputStream stream) throws IOException {
        ByteArrayHandle bytes = new ByteArrayHandle();
        String id = this.createInMemoryID((IRandomAccess)bytes);
        this.writeImage(server, region, id);
        stream.write(bytes.getBytes());
    }

    public void writeImage(BufferedImage img, OutputStream stream) throws IOException {
        ByteArrayHandle bytes = new ByteArrayHandle();
        String id = this.createInMemoryID((IRandomAccess)bytes);
        this.writeImage(img, id);
        stream.write(bytes.getBytes());
    }

    public void writeImage(ImageServer<BufferedImage> server, OutputStream stream) throws IOException {
        ByteArrayHandle bytes = new ByteArrayHandle();
        String id = this.createInMemoryID((IRandomAccess)bytes);
        this.writeImage(server, id);
        stream.write(bytes.getBytes());
    }
}

