/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.writers.ome.zarr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import qupath.lib.common.ColorTools;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.images.servers.PixelType;

class OMEZarrAttributesCreator {
    private static final String VERSION = "0.4";
    private final String imageName;
    private final int numberOfZSlices;
    private final int numberOfTimePoints;
    private final int numberOfChannels;
    private final PixelCalibration pixelCalibration;
    private final TimeUnit timeUnit;
    private final double[] downsamples;
    private final List<ImageChannel> channels;
    private final boolean isRGB;
    private final PixelType pixelType;

    public OMEZarrAttributesCreator(String imageName, int numberOfZSlices, int numberOfTimePoints, int numberOfChannels, PixelCalibration pixelCalibration, TimeUnit timeUnit, double[] downsamples, List<ImageChannel> channels, boolean isRGB, PixelType pixelType) {
        this.imageName = imageName;
        this.numberOfZSlices = numberOfZSlices;
        this.numberOfTimePoints = numberOfTimePoints;
        this.numberOfChannels = numberOfChannels;
        this.pixelCalibration = pixelCalibration;
        this.timeUnit = timeUnit;
        this.downsamples = downsamples;
        this.channels = channels;
        this.isRGB = isRGB;
        this.pixelType = pixelType;
    }

    public Map<String, Object> getGroupAttributes() {
        return Map.of("multiscales", List.of(Map.of("axes", this.getAxes(), "datasets", this.getDatasets(), "name", this.imageName, "version", VERSION)), "omero", Map.of("name", this.imageName, "version", VERSION, "channels", this.getChannels(), "rdefs", Map.of("defaultT", 0, "defaultZ", 0, "model", "color")));
    }

    public Map<String, Object> getLevelAttributes() {
        ArrayList<String> arrayDimensions = new ArrayList<String>();
        if (this.numberOfTimePoints > 1) {
            arrayDimensions.add("t");
        }
        if (this.numberOfChannels > 1) {
            arrayDimensions.add("c");
        }
        if (this.numberOfZSlices > 1) {
            arrayDimensions.add("z");
        }
        arrayDimensions.add("y");
        arrayDimensions.add("x");
        return Map.of("_ARRAY_DIMENSIONS", arrayDimensions);
    }

    private List<Map<String, Object>> getAxes() {
        ArrayList<Map<String, Object>> axes = new ArrayList<Map<String, Object>>();
        if (this.numberOfTimePoints > 1) {
            axes.add(this.getAxis(Dimension.T));
        }
        if (this.numberOfChannels > 1) {
            axes.add(this.getAxis(Dimension.C));
        }
        if (this.numberOfZSlices > 1) {
            axes.add(this.getAxis(Dimension.Z));
        }
        axes.add(this.getAxis(Dimension.Y));
        axes.add(this.getAxis(Dimension.X));
        return axes;
    }

    private List<Map<String, Object>> getDatasets() {
        return IntStream.range(0, this.downsamples.length).mapToObj(level -> Map.of("path", "s" + level, "coordinateTransformations", List.of(this.getCoordinateTransformation((float)this.downsamples[level])))).toList();
    }

    private List<Map<String, Object>> getChannels() {
        double d;
        if (this.isRGB) {
            d = 2.147483647E9;
        } else {
            switch (this.pixelType) {
                default: {
                    throw new MatchException(null, null);
                }
                case UINT8: 
                case INT8: {
                    d = 127.0;
                    break;
                }
                case UINT16: 
                case INT16: {
                    d = 32767.0;
                    break;
                }
                case UINT32: 
                case INT32: {
                    d = 2.147483647E9;
                    break;
                }
                case FLOAT32: {
                    d = 3.4028234663852886E38;
                    break;
                }
                case FLOAT64: {
                    d = Double.MAX_VALUE;
                }
            }
        }
        Double maxValue = d;
        return this.channels.stream().map(channel -> Map.of("active", true, "coefficient", 1.0, "color", String.format("%02X%02X%02X", ColorTools.unpackRGB((int)channel.getColor())[0], ColorTools.unpackRGB((int)channel.getColor())[1], ColorTools.unpackRGB((int)channel.getColor())[2]), "family", "linear", "inverted", false, "label", channel.getName(), "window", Map.of("start", 0.0, "end", maxValue, "min", 0.0, "max", maxValue))).toList();
    }

    private Map<String, Object> getAxis(Dimension dimension) {
        HashMap<String, Object> axis = new HashMap<String, Object>();
        axis.put("name", switch (dimension.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "x";
            case 1 -> "y";
            case 2 -> "z";
            case 4 -> "t";
            case 3 -> "c";
        });
        axis.put("type", switch (dimension.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 2 -> "space";
            case 4 -> "time";
            case 3 -> "channel";
        });
        switch (dimension.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                if (!this.pixelCalibration.getPixelWidthUnit().equals(PixelCalibration.MICROMETER)) break;
                axis.put("unit", "micrometer");
                break;
            }
            case 4: {
                axis.put("unit", switch (this.timeUnit) {
                    default -> throw new MatchException(null, null);
                    case TimeUnit.NANOSECONDS -> "nanosecond";
                    case TimeUnit.MICROSECONDS -> "microsecond";
                    case TimeUnit.MILLISECONDS -> "millisecond";
                    case TimeUnit.SECONDS -> "second";
                    case TimeUnit.MINUTES -> "minute";
                    case TimeUnit.HOURS -> "hour";
                    case TimeUnit.DAYS -> "day";
                });
            }
        }
        return axis;
    }

    private Map<String, Object> getCoordinateTransformation(float downsample) {
        ArrayList<Float> scales = new ArrayList<Float>();
        if (this.numberOfTimePoints > 1) {
            if (!Double.isNaN(this.pixelCalibration.getTimepoint(0)) && !Double.isNaN(this.pixelCalibration.getTimepoint(1))) {
                scales.add(Float.valueOf((float)(this.pixelCalibration.getTimepoint(1) - this.pixelCalibration.getTimepoint(0))));
            } else {
                scales.add(Float.valueOf(1.0f));
            }
        }
        if (this.numberOfChannels > 1) {
            scales.add(Float.valueOf(1.0f));
        }
        if (this.numberOfZSlices > 1) {
            scales.add(Float.valueOf(this.pixelCalibration.getZSpacing().floatValue()));
        }
        scales.add(Float.valueOf(this.pixelCalibration.getPixelHeight().floatValue() * downsample));
        scales.add(Float.valueOf(this.pixelCalibration.getPixelWidth().floatValue() * downsample));
        return Map.of("type", "scale", "scale", scales);
    }

    private static enum Dimension {
        X,
        Y,
        Z,
        C,
        T;

    }
}

