/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import java.lang.reflect.Field;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.HackWindowManager;
import razerdp.basepopup.PopupTouchController;
import razerdp.util.PopupUtil;
import razerdp.util.UnsafeHelper;
import razerdp.util.log.LogTag;
import razerdp.util.log.PopupLogUtil;

abstract class BasePopupWindowProxy
extends PopupWindow {
    private static final String TAG = "BasePopupWindowProxy";
    private static final int MAX_SCAN_ACTIVITY_COUNT = 50;
    private int tryScanActivityCount = 0;
    private PopupTouchController mController;
    private HackWindowManager hackWindowManager;

    public BasePopupWindowProxy(Context context, PopupTouchController mController) {
        super(context);
        this.mController = mController;
        this.init(context);
    }

    public BasePopupWindowProxy(Context context, AttributeSet attrs, PopupTouchController mController) {
        super(context, attrs);
        this.mController = mController;
        this.init(context);
    }

    public BasePopupWindowProxy(Context context, AttributeSet attrs, int defStyleAttr, PopupTouchController mController) {
        super(context, attrs, defStyleAttr);
        this.mController = mController;
        this.init(context);
    }

    public BasePopupWindowProxy(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, PopupTouchController mController) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mController = mController;
        this.init(context);
    }

    public BasePopupWindowProxy(View contentView, PopupTouchController mController) {
        super(contentView);
        this.mController = mController;
        this.init(contentView.getContext());
    }

    public BasePopupWindowProxy(View contentView, int width, int height, PopupTouchController mController) {
        super(contentView, width, height);
        this.mController = mController;
        this.init(contentView.getContext());
    }

    public BasePopupWindowProxy(View contentView, int width, int height, boolean focusable, PopupTouchController mController) {
        super(contentView, width, height, focusable);
        this.mController = mController;
        this.init(contentView.getContext());
    }

    void bindPopupHelper(BasePopupHelper mHelper) {
        if (this.hackWindowManager == null) {
            this.tryToProxyWindowManagerMethod(this);
        }
        this.hackWindowManager.bindPopupHelper(mHelper);
    }

    private void init(Context context) {
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.setBackgroundDrawable((Drawable)new ColorDrawable());
        this.tryToProxyWindowManagerMethod(this);
    }

    public void setContentView(View contentView) {
        super.setContentView(contentView);
        this.tryToProxyWindowManagerMethod(this);
    }

    void callSuperShowAsDropDown(View anchor, int xoff, int yoff, int gravity) {
        Activity activity = this.scanForActivity(anchor.getContext());
        if (activity == null) {
            Log.e((String)TAG, (String)"please make sure that context is instance of activity");
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            super.showAsDropDown(anchor, xoff, yoff, gravity);
        } else {
            super.showAsDropDown(anchor, xoff, yoff);
        }
    }

    void callSuperShowAtLocation(View parent, int gravity, int x, int y) {
        super.showAtLocation(parent, gravity, x, y);
    }

    boolean callSuperIsShowing() {
        return super.isShowing();
    }

    void resetTryScanActivityCount() {
        this.tryScanActivityCount = 0;
    }

    Activity scanForActivity(Context from) {
        Context result = from;
        while (result instanceof ContextWrapper) {
            if (result instanceof Activity) {
                return (Activity)result;
            }
            if (this.tryScanActivityCount > 50) {
                return null;
            }
            ++this.tryScanActivityCount;
            PopupLogUtil.trace(LogTag.i, TAG, "scanForActivity: " + this.tryScanActivityCount);
            result = ((ContextWrapper)result).getBaseContext();
        }
        return null;
    }

    public void dismiss() {
        if (this.mController == null) {
            return;
        }
        boolean performDismiss = this.mController.onBeforeDismiss();
        if (!performDismiss) {
            return;
        }
        boolean dismissAtOnce = this.mController.callDismissAtOnce();
        if (dismissAtOnce) {
            this.callSuperDismiss();
        }
    }

    void callSuperDismiss() {
        try {
            super.dismiss();
            this.clear();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"dismiss error");
            e.printStackTrace();
            this.clear();
        }
    }

    void clear() {
        if (this.hackWindowManager != null) {
            this.hackWindowManager.clear();
        }
        PopupUtil.clearViewFromParent(this.getContentView());
    }

    private void tryToProxyWindowManagerMethod(PopupWindow popupWindow) {
        if (this.mController == null || this.hackWindowManager != null) {
            return;
        }
        if (Build.VERSION.SDK_INT <= 27) {
            this.troToProxyWindowManagerMethodBeforeP(popupWindow);
        } else {
            this.troToProxyWindowManagerMethodOverP(popupWindow);
        }
    }

    private void troToProxyWindowManagerMethodOverP(PopupWindow popupWindow) {
        try {
            long baseOffset = UnsafeHelper.addressOf(popupWindow);
            long offset = baseOffset + 28L;
            Object object = UnsafeHelper.getObject(popupWindow, baseOffset);
            WindowManager windowManager = (WindowManager)UnsafeHelper.getObject(popupWindow, offset);
            if (windowManager == null) {
                return;
            }
            this.hackWindowManager = new HackWindowManager(windowManager, this.mController);
            UnsafeHelper.putObject(popupWindow, offset, this.hackWindowManager);
            PopupLogUtil.trace(LogTag.i, TAG, "\u5c1d\u8bd5\u4ee3\u7406WindowManager\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void troToProxyWindowManagerMethodBeforeP(PopupWindow popupWindow) {
        try {
            Field fieldWindowManager = PopupWindow.class.getDeclaredField("mWindowManager");
            fieldWindowManager.setAccessible(true);
            WindowManager windowManager = (WindowManager)fieldWindowManager.get(popupWindow);
            if (windowManager == null) {
                return;
            }
            this.hackWindowManager = new HackWindowManager(windowManager, this.mController);
            fieldWindowManager.set(popupWindow, this.hackWindowManager);
            PopupLogUtil.trace(LogTag.i, TAG, "\u5c1d\u8bd5\u4ee3\u7406WindowManager\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

