/*
 * Decompiled with CFR 0.152.
 */
package razerdp.blur;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.util.TypedValue;
import android.view.View;
import razerdp.blur.FastBlur;
import razerdp.util.log.LogTag;
import razerdp.util.log.PopupLogUtil;

public class BlurHelper {
    private static final String TAG = "BlurHelper";
    private static int statusBarHeight = 0;

    public static boolean renderScriptSupported() {
        return Build.VERSION.SDK_INT > 17;
    }

    public static Bitmap blur(Context context, View view, float scaledRatio, float radius) {
        return BlurHelper.blur(context, view, scaledRatio, radius, true);
    }

    public static Bitmap blur(Context context, View view, float scaledRatio, float radius, boolean fullScreen) {
        return BlurHelper.blur(context, BlurHelper.getViewBitmap(view, fullScreen), scaledRatio, radius);
    }

    public static Bitmap blur(Context context, Bitmap origin, float scaledRatio, float radius) {
        if (BlurHelper.renderScriptSupported()) {
            PopupLogUtil.trace(LogTag.i, TAG, "\u811a\u672c\u6a21\u7cca");
            return BlurHelper.renderScriptblur(context, origin, scaledRatio, radius);
        }
        PopupLogUtil.trace(LogTag.i, TAG, "\u5feb\u901f\u6a21\u7cca");
        scaledRatio = BlurHelper.checkFloatRange(scaledRatio / 8.0f, 1.0f, scaledRatio);
        return BlurHelper.fastBlur(context, origin, scaledRatio, radius);
    }

    @TargetApi(value=17)
    public static Bitmap renderScriptblur(Context context, Bitmap origin, float scaledRatio, float radius) {
        ScriptIntrinsicBlur blur;
        Allocation blurOutput;
        Allocation blurInput;
        RenderScript renderScript;
        Bitmap result;
        Bitmap scaledBitmap;
        int originHeight;
        int originWidth;
        block6: {
            if (origin == null || origin.isRecycled()) {
                return null;
            }
            radius = BlurHelper.checkFloatRange(radius, 0.0f, 20.0f);
            scaledRatio = BlurHelper.checkFloatRange(scaledRatio, 0.0f, 1.0f);
            originWidth = origin.getWidth();
            originHeight = origin.getHeight();
            PopupLogUtil.trace(LogTag.i, "originWidth  >>  " + originWidth + "   originHeight  >>  " + originHeight);
            int scaledWidth = originWidth;
            int scaledHeight = originHeight;
            if (scaledRatio > 0.0f) {
                scaledWidth = (int)((float)scaledWidth * scaledRatio);
                scaledHeight = (int)((float)scaledHeight * scaledRatio);
            }
            PopupLogUtil.trace(LogTag.i, "scaledWidth  >>  " + scaledWidth + "   scaledHeight  >>  " + scaledHeight);
            scaledBitmap = Bitmap.createScaledBitmap((Bitmap)origin, (int)scaledWidth, (int)scaledHeight, (boolean)false);
            result = Bitmap.createBitmap((Bitmap)scaledBitmap);
            if (scaledBitmap.isRecycled() || result == null || result.isRecycled()) {
                return null;
            }
            renderScript = RenderScript.create((Context)context);
            blurInput = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)scaledBitmap);
            blurOutput = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)result);
            blur = null;
            try {
                blur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)blurInput.getElement());
            }
            catch (RSIllegalArgumentException e) {
                if (!e.getMessage().contains("Unsuported element type")) break block6;
                blur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)Element.U8_4((RenderScript)renderScript));
            }
        }
        if (blur == null) {
            return null;
        }
        blur.setRadius(radius);
        blur.setInput(blurInput);
        blur.forEach(blurOutput);
        blurOutput.copyTo(result);
        renderScript.destroy();
        blurInput.destroy();
        blurOutput.destroy();
        scaledBitmap.recycle();
        origin.recycle();
        result = Bitmap.createScaledBitmap((Bitmap)result, (int)originWidth, (int)originHeight, (boolean)false);
        PopupLogUtil.trace(LogTag.i, "resultWidth  >>  " + result.getWidth() + "   resultHeight  >>  " + result.getHeight());
        return result;
    }

    public static Bitmap fastBlur(Context context, Bitmap origin, float scaledRatio, float radius) {
        if (origin == null || origin.isRecycled()) {
            return null;
        }
        radius = BlurHelper.checkFloatRange(radius, 0.0f, 20.0f);
        scaledRatio = BlurHelper.checkFloatRange(scaledRatio, 0.0f, 1.0f);
        int originWidth = origin.getWidth();
        int originHeight = origin.getHeight();
        PopupLogUtil.trace(LogTag.i, "originWidth  >>  " + originWidth + "   originHeight  >>  " + originHeight);
        int scaledWidth = originWidth;
        int scaledHeight = originHeight;
        if (scaledRatio > 0.0f) {
            scaledWidth = (int)((float)scaledWidth * scaledRatio);
            scaledHeight = (int)((float)scaledHeight * scaledRatio);
        }
        PopupLogUtil.trace(LogTag.i, "scaledWidth  >>  " + scaledWidth + "   scaledHeight  >>  " + scaledHeight);
        Bitmap result = Bitmap.createScaledBitmap((Bitmap)origin, (int)scaledWidth, (int)scaledHeight, (boolean)false);
        if (result == null || result.isRecycled()) {
            return null;
        }
        result = FastBlur.doBlur(result, (int)radius, false);
        origin.recycle();
        result = Bitmap.createScaledBitmap((Bitmap)result, (int)originWidth, (int)originHeight, (boolean)false);
        PopupLogUtil.trace(LogTag.i, "resultWidth  >>  " + result.getWidth() + "   resultHeight  >>  " + result.getHeight());
        return result;
    }

    public static Bitmap getViewBitmap(View v, boolean fullScreen) {
        if (v == null || v.getWidth() <= 0 || v.getHeight() <= 0) {
            PopupLogUtil.trace(LogTag.e, "getViewBitmap  >>  \u5bbd\u6216\u8005\u9ad8\u4e3a\u7a7a");
            return null;
        }
        if (statusBarHeight <= 0) {
            statusBarHeight = BlurHelper.getStatusBarHeight(v.getContext());
        }
        Bitmap b = Bitmap.createBitmap((int)v.getWidth(), (int)v.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(b);
        if (v.getBackground() == null) {
            TypedValue tv = new TypedValue();
            v.getContext().getTheme().resolveAttribute(0x1010031, tv, true);
            if (tv.type >= 28 && tv.type <= 31) {
                c.drawColor(tv.data);
            } else {
                c.drawColor(Color.parseColor((String)"#FAFAFA"));
            }
        }
        if (fullScreen && statusBarHeight > 0 && Build.VERSION.SDK_INT >= 21 && v.getContext() instanceof Activity) {
            int statusBarColor = ((Activity)v.getContext()).getWindow().getStatusBarColor();
            Paint p = new Paint(1);
            p.setColor(statusBarColor);
            Rect rect = new Rect(0, 0, v.getWidth(), statusBarHeight);
            c.drawRect(rect, p);
        }
        v.draw(c);
        return b;
    }

    private static float checkFloatRange(float originValue, float rangeFrom, float rangeTo) {
        if (originValue < rangeFrom) {
            originValue = rangeFrom;
        } else if (originValue > rangeTo) {
            originValue = rangeTo;
        }
        return originValue;
    }

    private static int getStatusBarHeight(Context context) {
        if (context == null) {
            return 0;
        }
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }
}

