/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.data.datadescription.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntryCondition;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntryContainer;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntryExecSql;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntryGroup;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntryRename;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.DataDescriptionEntryConditionImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.DataDescriptionEntryExecSqlImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.DataDescriptionEntryGroupImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.DataDescriptionEntryRenameImpl;
import io.proleap.cobol.asg.metamodel.impl.CobolDivisionElementImpl;
import io.proleap.cobol.asg.util.StringUtils;
import io.proleap.cobol.asg.util.TagUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DataDescriptionEntryContainerImpl
extends CobolDivisionElementImpl
implements DataDescriptionEntryContainer {
    private static final Logger LOG = LogManager.getLogger(DataDescriptionEntryContainerImpl.class);
    protected List<DataDescriptionEntry> dataDescriptionEntries = new ArrayList<DataDescriptionEntry>();
    protected Map<String, DataDescriptionEntry> dataDescriptionEntriesSymbolTable = new HashMap<String, DataDescriptionEntry>();

    public DataDescriptionEntryContainerImpl(ProgramUnit programUnit, ParserRuleContext ctx) {
        super(programUnit, ctx);
    }

    @Override
    public DataDescriptionEntryCondition addDataDescriptionEntryCondition(Cobol85Parser.DataDescriptionEntryFormat3Context ctx) {
        DataDescriptionEntryCondition result = (DataDescriptionEntryCondition)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new DataDescriptionEntryConditionImpl(name, (DataDescriptionEntryContainer)this, this.programUnit, ctx);
            result.setLevelNumber(88);
            result.addValueClause(ctx.dataValueClause());
            this.registerASGElement(result);
            this.dataDescriptionEntries.add(result);
            this.dataDescriptionEntriesSymbolTable.put(name, result);
        }
        return result;
    }

    @Override
    public DataDescriptionEntryExecSql addDataDescriptionEntryExecSql(Cobol85Parser.DataDescriptionEntryExecSqlContext ctx) {
        DataDescriptionEntryExecSql result = (DataDescriptionEntryExecSql)this.getASGElement(ctx);
        if (result == null) {
            result = new DataDescriptionEntryExecSqlImpl(this, this.programUnit, ctx);
            String execSqlText = TagUtils.getUntaggedText(ctx.EXECSQLLINE(), "*>EXECSQL", "^");
            result.setExecSqlText(execSqlText);
            this.registerASGElement(result);
            this.dataDescriptionEntries.add(result);
        }
        return result;
    }

    @Override
    public DataDescriptionEntryGroup addDataDescriptionEntryGroup(Cobol85Parser.DataDescriptionEntryFormat1Context ctx) {
        DataDescriptionEntryGroup result = (DataDescriptionEntryGroup)this.getASGElement(ctx);
        if (result == null) {
            Cobol85Parser.DataWithLowerBoundsClauseContext dataWithLowerBoundsClauseContext;
            List<Cobol85Parser.DataValueClauseContext> dataValueClauseContexts;
            List<Cobol85Parser.DataUsingClauseContext> dataUsingClauseContexts;
            List<Cobol85Parser.DataUsageClauseContext> dataUsageClauseContexts;
            Cobol85Parser.DataTypeDefClauseContext dataTypeDefClauseContext;
            List<Cobol85Parser.DataTypeClauseContext> dataTypeClauseContexts;
            Cobol85Parser.DataThreadLocalClauseContext dataThreadLocalClauseContext;
            List<Cobol85Parser.DataSynchronizedClauseContext> dataSynchronizedClauseContexts;
            List<Cobol85Parser.DataSignClauseContext> dataSignClauseContexts;
            Cobol85Parser.DataRedefinesClauseContext dataRedefinesClauseContext;
            Cobol85Parser.DataRecordAreaClauseContext dataRecordAreaClauseContext;
            List<Cobol85Parser.DataReceivedByClauseContext> dataReceivedByClauseContexts;
            List<Cobol85Parser.DataJustifiedClauseContext> dataJustifiedClauseContexts;
            Cobol85Parser.DataIntegerStringClauseContext dataIntegerStringClauseContext;
            Cobol85Parser.DataGlobalClauseContext dataGlobalClauseContext;
            Cobol85Parser.DataExternalClauseContext dataExternalClauseContext;
            List<Cobol85Parser.DataCommonOwnLocalClauseContext> dataCommonOwnLocalClauseContexts;
            List<Cobol85Parser.DataBlankWhenZeroClauseContext> dataBlankWhenZeroClauseContexts;
            Cobol85Parser.DataAlignedClauseContext dataAlignedClauseContext;
            String name = this.determineName(ctx);
            result = new DataDescriptionEntryGroupImpl(name, (DataDescriptionEntryContainer)this, this.programUnit, ctx);
            Integer levelNumber = ctx.LEVEL_NUMBER_77() != null ? Integer.valueOf(77) : (ctx.INTEGERLITERAL() != null ? StringUtils.parseInteger(ctx.INTEGERLITERAL().getText()) : null);
            result.setLevelNumber(levelNumber);
            if (ctx.FILLER() != null) {
                result.setFiller(true);
                result.setFillerNumber(this.compilationUnit.incrementFillerCounter());
            }
            if ((dataAlignedClauseContext = ctx.dataAlignedClause()) != null) {
                result.addAlignedClause(dataAlignedClauseContext);
            }
            if (!(dataBlankWhenZeroClauseContexts = ctx.dataBlankWhenZeroClause()).isEmpty()) {
                Cobol85Parser.DataBlankWhenZeroClauseContext dataBlankWhenZeroClauseContext = dataBlankWhenZeroClauseContexts.get(0);
                result.addBlankWhenZeroClause(dataBlankWhenZeroClauseContext);
            }
            if (!(dataCommonOwnLocalClauseContexts = ctx.dataCommonOwnLocalClause()).isEmpty()) {
                Cobol85Parser.DataCommonOwnLocalClauseContext dataCommonOwnLocalClauseContext = dataCommonOwnLocalClauseContexts.get(0);
                result.addCommonOwnLocalClause(dataCommonOwnLocalClauseContext);
            }
            if ((dataExternalClauseContext = ctx.dataExternalClause()) != null) {
                result.addExternalClause(dataExternalClauseContext);
            }
            if ((dataGlobalClauseContext = ctx.dataGlobalClause()) != null) {
                result.addGlobalClause(dataGlobalClauseContext);
            }
            if ((dataIntegerStringClauseContext = ctx.dataIntegerStringClause()) != null) {
                result.addIntegerStringClause(dataIntegerStringClauseContext);
            }
            if (!(dataJustifiedClauseContexts = ctx.dataJustifiedClause()).isEmpty()) {
                Cobol85Parser.DataJustifiedClauseContext dataJustifiedClauseContext = dataJustifiedClauseContexts.get(0);
                result.addJustifiedClause(dataJustifiedClauseContext);
            }
            List<Cobol85Parser.DataOccursClauseContext> dataOccursClauseContexts = ctx.dataOccursClause();
            for (Cobol85Parser.DataOccursClauseContext dataOccursClauseContext : dataOccursClauseContexts) {
                result.addOccursClause(dataOccursClauseContext);
            }
            List<Cobol85Parser.DataPictureClauseContext> dataPictureClauseContexts = ctx.dataPictureClause();
            if (!dataPictureClauseContexts.isEmpty()) {
                Cobol85Parser.DataPictureClauseContext dataPictureClauseContext = ctx.dataPictureClause().get(0);
                result.addPictureClause(dataPictureClauseContext);
            }
            if (!(dataReceivedByClauseContexts = ctx.dataReceivedByClause()).isEmpty()) {
                Cobol85Parser.DataReceivedByClauseContext dataReceivedByClauseContext = dataReceivedByClauseContexts.get(0);
                result.addReceivedByClause(dataReceivedByClauseContext);
            }
            if ((dataRecordAreaClauseContext = ctx.dataRecordAreaClause()) != null) {
                result.addRecordAreaClause(dataRecordAreaClauseContext);
            }
            if ((dataRedefinesClauseContext = ctx.dataRedefinesClause()) != null) {
                result.addRedefinesClause(dataRedefinesClauseContext);
            }
            if (!(dataSignClauseContexts = ctx.dataSignClause()).isEmpty()) {
                Cobol85Parser.DataSignClauseContext dataSignClauseContext = dataSignClauseContexts.get(0);
                result.addSignClause(dataSignClauseContext);
            }
            if (!(dataSynchronizedClauseContexts = ctx.dataSynchronizedClause()).isEmpty()) {
                Cobol85Parser.DataSynchronizedClauseContext dataSynchronizedClauseContext = dataSynchronizedClauseContexts.get(0);
                result.addSynchronizedClause(dataSynchronizedClauseContext);
            }
            if ((dataThreadLocalClauseContext = ctx.dataThreadLocalClause()) != null) {
                result.addThreadLocalClause(dataThreadLocalClauseContext);
            }
            if (!(dataTypeClauseContexts = ctx.dataTypeClause()).isEmpty()) {
                Cobol85Parser.DataTypeClauseContext dataTypeClauseContext = dataTypeClauseContexts.get(0);
                result.addTypeClause(dataTypeClauseContext);
            }
            if ((dataTypeDefClauseContext = ctx.dataTypeDefClause()) != null) {
                result.addTypeDefClause(dataTypeDefClauseContext);
            }
            if (!(dataUsageClauseContexts = ctx.dataUsageClause()).isEmpty()) {
                Cobol85Parser.DataUsageClauseContext dataUsageClauseContext = dataUsageClauseContexts.get(0);
                result.addUsageClause(dataUsageClauseContext);
            }
            if (!(dataUsingClauseContexts = ctx.dataUsingClause()).isEmpty()) {
                Cobol85Parser.DataUsingClauseContext dataUsingClauseContext = dataUsingClauseContexts.get(0);
                result.addUsingClause(dataUsingClauseContext);
            }
            if (!(dataValueClauseContexts = ctx.dataValueClause()).isEmpty()) {
                Cobol85Parser.DataValueClauseContext dataValueClauseContext = dataValueClauseContexts.get(0);
                result.addValueClause(dataValueClauseContext);
            }
            if ((dataWithLowerBoundsClauseContext = ctx.dataWithLowerBoundsClause()) != null) {
                result.addWithLowerBoundClause(dataWithLowerBoundsClauseContext);
            }
            this.registerASGElement(result);
            this.dataDescriptionEntries.add(result);
            this.dataDescriptionEntriesSymbolTable.put(name, result);
        }
        return result;
    }

    @Override
    public DataDescriptionEntryRename addDataDescriptionEntryRename(Cobol85Parser.DataDescriptionEntryFormat2Context ctx) {
        DataDescriptionEntryRename result = (DataDescriptionEntryRename)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new DataDescriptionEntryRenameImpl(name, (DataDescriptionEntryContainer)this, this.programUnit, ctx);
            result.setLevelNumber(66);
            result.addRenamesClause(ctx.dataRenamesClause());
            this.registerASGElement(result);
            this.dataDescriptionEntries.add(result);
            this.dataDescriptionEntriesSymbolTable.put(name, result);
        }
        return result;
    }

    @Override
    public DataDescriptionEntry createDataDescriptionEntry(DataDescriptionEntryGroup currentDataDescriptionEntryGroup, Cobol85Parser.DataDescriptionEntryContext ctx) {
        DataDescriptionEntry result;
        if (ctx.dataDescriptionEntryFormat1() != null) {
            result = this.addDataDescriptionEntryGroup(ctx.dataDescriptionEntryFormat1());
        } else if (ctx.dataDescriptionEntryFormat2() != null) {
            result = this.addDataDescriptionEntryRename(ctx.dataDescriptionEntryFormat2());
        } else if (ctx.dataDescriptionEntryFormat3() != null) {
            result = this.addDataDescriptionEntryCondition(ctx.dataDescriptionEntryFormat3());
        } else if (ctx.dataDescriptionEntryExecSql() != null) {
            result = this.addDataDescriptionEntryExecSql(ctx.dataDescriptionEntryExecSql());
        } else {
            LOG.warn("unknown data description entry {}", (Object)ctx);
            result = null;
        }
        if (currentDataDescriptionEntryGroup != null && result != null) {
            this.groupDataDescriptionEntry(currentDataDescriptionEntryGroup, result);
        }
        return result;
    }

    @Override
    public List<DataDescriptionEntry> getDataDescriptionEntries() {
        return this.dataDescriptionEntries;
    }

    @Override
    public DataDescriptionEntry getDataDescriptionEntry(String name) {
        return this.dataDescriptionEntriesSymbolTable.get(name);
    }

    @Override
    public List<DataDescriptionEntry> getRootDataDescriptionEntries() {
        ArrayList<DataDescriptionEntry> result = new ArrayList<DataDescriptionEntry>();
        for (DataDescriptionEntry dataDescriptionEntry : this.dataDescriptionEntries) {
            if (dataDescriptionEntry.getParentDataDescriptionEntryGroup() != null) continue;
            result.add(dataDescriptionEntry);
        }
        return result;
    }

    protected void groupDataDescriptionEntry(DataDescriptionEntryGroup currentDataDescriptionEntryGroup, DataDescriptionEntry dataDescriptionEntry) {
        Integer currentLevelNumber = currentDataDescriptionEntryGroup.getLevelNumber();
        Integer levelNumber = dataDescriptionEntry.getLevelNumber();
        if (this.isGroupableLevelNumber(levelNumber)) {
            if (levelNumber > currentLevelNumber) {
                currentDataDescriptionEntryGroup.addDataDescriptionEntry(dataDescriptionEntry);
                dataDescriptionEntry.setParentDataDescriptionEntryGroup(currentDataDescriptionEntryGroup);
            } else {
                DataDescriptionEntryGroup currentParentDataDescriptionEntryGroup = currentDataDescriptionEntryGroup.getParentDataDescriptionEntryGroup();
                if (currentParentDataDescriptionEntryGroup != null) {
                    this.groupDataDescriptionEntry(currentParentDataDescriptionEntryGroup, dataDescriptionEntry);
                }
            }
        }
    }

    protected boolean isGroupableLevelNumber(Integer levelNumber) {
        boolean result = levelNumber != null && 77 != levelNumber && 66 != levelNumber;
        return result;
    }
}

