/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.data.datadescription.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.IntegerLiteral;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.call.Call;
import io.proleap.cobol.asg.metamodel.data.datadescription.Index;
import io.proleap.cobol.asg.metamodel.data.datadescription.OccursClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.OccursSort;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.IndexImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.OccursSortImpl;
import io.proleap.cobol.asg.metamodel.impl.CobolDivisionElementImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;

public class OccursClauseImpl
extends CobolDivisionElementImpl
implements OccursClause {
    protected Cobol85Parser.DataOccursClauseContext ctx;
    protected Call dependingOnCall;
    protected IntegerLiteral from;
    protected List<Index> indices = new ArrayList<Index>();
    protected Map<String, Index> indicesSymbolTable = new HashMap<String, Index>();
    protected List<OccursSort> occursSorts = new ArrayList<OccursSort>();
    protected IntegerLiteral to;

    public OccursClauseImpl(ProgramUnit programUnit, Cobol85Parser.DataOccursClauseContext ctx) {
        super(programUnit, (ParserRuleContext)ctx);
        this.ctx = ctx;
    }

    @Override
    public Index addIndex(Cobol85Parser.IndexNameContext ctx) {
        Index result = (Index)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            IndexImpl index = new IndexImpl(name, this.programUnit, ctx);
            this.indices.add(index);
            this.indicesSymbolTable.put(name, index);
            this.registerASGElement(index);
        }
        return result;
    }

    @Override
    public OccursSort addOccursSort(Cobol85Parser.DataOccursSortContext ctx) {
        OccursSort result = (OccursSort)this.getASGElement(ctx);
        if (result == null) {
            result = new OccursSortImpl(this.programUnit, ctx);
            OccursSort.Order order = ctx.ASCENDING() != null ? OccursSort.Order.ASCENDING : (ctx.DESCENDING() != null ? OccursSort.Order.DESCENDING : null);
            result.setOrder(order);
            for (Cobol85Parser.QualifiedDataNameContext qualifiedDataNameContext : ctx.qualifiedDataName()) {
                Call keyCall = this.createCall(qualifiedDataNameContext);
                result.addKeyCall(keyCall);
            }
            this.occursSorts.add(result);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public Call getDependingOnCall() {
        return this.dependingOnCall;
    }

    @Override
    public IntegerLiteral getFrom() {
        return this.from;
    }

    @Override
    public Index getIndex(String name) {
        return this.indicesSymbolTable.get(name);
    }

    @Override
    public List<Index> getIndices() {
        return this.indices;
    }

    @Override
    public List<OccursSort> getOccursSorts() {
        return this.occursSorts;
    }

    @Override
    public IntegerLiteral getTo() {
        return this.to;
    }

    @Override
    public void setDependingOnCall(Call dependingOnCall) {
        this.dependingOnCall = dependingOnCall;
    }

    @Override
    public void setFrom(IntegerLiteral from) {
        this.from = from;
    }

    @Override
    public void setTo(IntegerLiteral to) {
        this.to = to;
    }
}

