/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.data.file.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.call.Call;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntryGroup;
import io.proleap.cobol.asg.metamodel.data.file.FileDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.file.FileSection;
import io.proleap.cobol.asg.metamodel.data.file.impl.FileDescriptionEntryImpl;
import io.proleap.cobol.asg.metamodel.environment.inputoutput.filecontrol.FileControlEntry;
import io.proleap.cobol.asg.metamodel.impl.CobolDivisionElementImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;

public class FileSectionImpl
extends CobolDivisionElementImpl
implements FileSection {
    protected final Cobol85Parser.FileSectionContext ctx;
    protected List<FileDescriptionEntry> fileDescriptionEntries = new ArrayList<FileDescriptionEntry>();
    protected Map<String, FileDescriptionEntry> fileDescriptionEntriesSymbolTable = new HashMap<String, FileDescriptionEntry>();

    public FileSectionImpl(ProgramUnit programUnit, Cobol85Parser.FileSectionContext ctx) {
        super(programUnit, (ParserRuleContext)ctx);
        this.ctx = ctx;
    }

    @Override
    public FileDescriptionEntry addFileDescriptionEntry(Cobol85Parser.FileDescriptionEntryContext ctx) {
        FileDescriptionEntry result = (FileDescriptionEntry)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new FileDescriptionEntryImpl(name, this.programUnit, ctx);
            FileControlEntry fileControlEntry = this.findFileControlEntry(name);
            if (fileControlEntry != null) {
                this.linkFileDescriptionEntryWithFileControlEntry(result, fileControlEntry);
            }
            Call fileCall = this.createCall(ctx.fileName());
            result.setFileCall(fileCall);
            for (Cobol85Parser.FileDescriptionEntryClauseContext fileDescriptionEntryClause : ctx.fileDescriptionEntryClause()) {
                if (fileDescriptionEntryClause.blockContainsClause() != null) {
                    result.addBlockContainsClause(fileDescriptionEntryClause.blockContainsClause());
                }
                if (fileDescriptionEntryClause.externalClause() != null) {
                    result.addExternalClause(fileDescriptionEntryClause.externalClause());
                }
                if (fileDescriptionEntryClause.globalClause() != null) {
                    result.addGlobalClause(fileDescriptionEntryClause.globalClause());
                }
                if (fileDescriptionEntryClause.codeSetClause() != null) {
                    result.addCodeSetClause(fileDescriptionEntryClause.codeSetClause());
                }
                if (fileDescriptionEntryClause.recordContainsClause() != null) {
                    result.addRecordContainsClause(fileDescriptionEntryClause.recordContainsClause());
                }
                if (fileDescriptionEntryClause.labelRecordsClause() != null) {
                    result.addLabelRecordsClause(fileDescriptionEntryClause.labelRecordsClause());
                }
                if (fileDescriptionEntryClause.valueOfClause() != null) {
                    result.addValueOfClause(fileDescriptionEntryClause.valueOfClause());
                }
                if (fileDescriptionEntryClause.linageClause() != null) {
                    result.addLinageClause(fileDescriptionEntryClause.linageClause());
                }
                if (fileDescriptionEntryClause.dataRecordsClause() != null) {
                    result.addDataRecordsClause(fileDescriptionEntryClause.dataRecordsClause());
                }
                if (fileDescriptionEntryClause.reportClause() == null) continue;
                result.addReportClause(fileDescriptionEntryClause.reportClause());
            }
            DataDescriptionEntryGroup currentDataDescriptionEntryGroup = null;
            for (Cobol85Parser.DataDescriptionEntryContext dataDescriptionEntryContext : ctx.dataDescriptionEntry()) {
                DataDescriptionEntry dataDescriptionEntry = result.createDataDescriptionEntry(currentDataDescriptionEntryGroup, dataDescriptionEntryContext);
                if (!(dataDescriptionEntry instanceof DataDescriptionEntryGroup)) continue;
                currentDataDescriptionEntryGroup = (DataDescriptionEntryGroup)dataDescriptionEntry;
            }
            this.fileDescriptionEntries.add(result);
            this.fileDescriptionEntriesSymbolTable.put(name, result);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public List<FileDescriptionEntry> getFileDescriptionEntries() {
        return this.fileDescriptionEntries;
    }

    @Override
    public FileDescriptionEntry getFileDescriptionEntry(String name) {
        return this.fileDescriptionEntriesSymbolTable.get(name);
    }

    protected void linkFileDescriptionEntryWithFileControlEntry(FileDescriptionEntry fileDescriptionEntry, FileControlEntry fileControlEntry) {
        fileDescriptionEntry.setFileControlEntry(fileControlEntry);
        fileControlEntry.setFileDescriptionEntry(fileDescriptionEntry);
    }
}

