/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.data.programlibrary.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.call.Call;
import io.proleap.cobol.asg.metamodel.data.programlibrary.ExportAttribute;
import io.proleap.cobol.asg.metamodel.data.programlibrary.ExportEntryProcedure;
import io.proleap.cobol.asg.metamodel.data.programlibrary.LibraryDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.programlibrary.LibraryDescriptionEntryExport;
import io.proleap.cobol.asg.metamodel.data.programlibrary.impl.ExportAttributeImpl;
import io.proleap.cobol.asg.metamodel.data.programlibrary.impl.ExportEntryProcedureImpl;
import io.proleap.cobol.asg.metamodel.data.programlibrary.impl.LibraryDescriptionEntryImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LibraryDescriptionEntryExportImpl
extends LibraryDescriptionEntryImpl
implements LibraryDescriptionEntryExport {
    private static final Logger LOG = LogManager.getLogger(LibraryDescriptionEntryExportImpl.class);
    protected final Cobol85Parser.LibraryDescriptionEntryFormat1Context ctx;
    protected ExportAttribute exportAttribute;
    protected ExportEntryProcedure exportEntryProcedure;

    public LibraryDescriptionEntryExportImpl(String name, ProgramUnit programUnit, Cobol85Parser.LibraryDescriptionEntryFormat1Context ctx) {
        super(name, programUnit, ctx);
        this.ctx = ctx;
    }

    @Override
    public ExportAttribute addExportAttribute(Cobol85Parser.LibraryAttributeClauseFormat1Context ctx) {
        ExportAttribute result = (ExportAttribute)this.getASGElement(ctx);
        if (result == null) {
            result = new ExportAttributeImpl(this.programUnit, ctx);
            if (ctx.SHARING() != null) {
                ExportAttribute.Sharing sharing;
                if (ctx.DONTCARE() != null) {
                    sharing = ExportAttribute.Sharing.DONT_CARE;
                } else if (ctx.PRIVATE() != null) {
                    sharing = ExportAttribute.Sharing.PRIVATE;
                } else if (ctx.SHAREDBYRUNUNIT() != null) {
                    sharing = ExportAttribute.Sharing.SHARED_BY_RUN_UNIT;
                } else if (ctx.SHAREDBYALL() != null) {
                    sharing = ExportAttribute.Sharing.SHARED_BY_ALL;
                } else {
                    LOG.warn("unknown sharing at {}", (Object)ctx);
                    sharing = null;
                }
                result.setSharing(sharing);
            }
            this.exportAttribute = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ExportEntryProcedure addExportEntryProcedure(Cobol85Parser.LibraryEntryProcedureClauseFormat1Context ctx) {
        ExportEntryProcedure result = (ExportEntryProcedure)this.getASGElement(ctx);
        if (result == null) {
            result = new ExportEntryProcedureImpl(this.programUnit, ctx);
            Call programCall = this.createCall(ctx.programName());
            result.setProgramCall(programCall);
            if (ctx.libraryEntryProcedureForClause() != null) {
                result.addForClause(ctx.libraryEntryProcedureForClause());
            }
            this.exportEntryProcedure = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ExportAttribute getExportAttribute() {
        return this.exportAttribute;
    }

    @Override
    public ExportEntryProcedure getExportEntryProcedure() {
        return this.exportEntryProcedure;
    }

    @Override
    public LibraryDescriptionEntry.LibraryDescriptionEntryType getLibraryDescriptionEntryType() {
        return LibraryDescriptionEntry.LibraryDescriptionEntryType.EXPORT;
    }
}

