/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.data.programlibrary.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.Literal;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.call.Call;
import io.proleap.cobol.asg.metamodel.data.programlibrary.CommonClause;
import io.proleap.cobol.asg.metamodel.data.programlibrary.GlobalClause;
import io.proleap.cobol.asg.metamodel.data.programlibrary.ImportAttribute;
import io.proleap.cobol.asg.metamodel.data.programlibrary.ImportEntryProcedure;
import io.proleap.cobol.asg.metamodel.data.programlibrary.LibraryDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.programlibrary.LibraryDescriptionEntryImport;
import io.proleap.cobol.asg.metamodel.data.programlibrary.impl.CommonClauseImpl;
import io.proleap.cobol.asg.metamodel.data.programlibrary.impl.GlobalClauseImpl;
import io.proleap.cobol.asg.metamodel.data.programlibrary.impl.ImportAttributeImpl;
import io.proleap.cobol.asg.metamodel.data.programlibrary.impl.ImportEntryProcedureImpl;
import io.proleap.cobol.asg.metamodel.data.programlibrary.impl.LibraryDescriptionEntryImpl;
import java.util.ArrayList;
import java.util.List;

public class LibraryDescriptionEntryImportImpl
extends LibraryDescriptionEntryImpl
implements LibraryDescriptionEntryImport {
    protected CommonClause commonClause;
    protected final Cobol85Parser.LibraryDescriptionEntryFormat2Context ctx;
    protected GlobalClause globalClause;
    protected List<ImportAttribute> importAttributes = new ArrayList<ImportAttribute>();
    protected List<ImportEntryProcedure> importEntryProcedures = new ArrayList<ImportEntryProcedure>();

    public LibraryDescriptionEntryImportImpl(String name, ProgramUnit programUnit, Cobol85Parser.LibraryDescriptionEntryFormat2Context ctx) {
        super(name, programUnit, ctx);
        this.ctx = ctx;
    }

    @Override
    public CommonClause addCommonClause(Cobol85Parser.LibraryIsCommonClauseContext ctx) {
        CommonClause result = (CommonClause)this.getASGElement(ctx);
        if (result == null) {
            result = new CommonClauseImpl(this.programUnit, ctx);
            result.setCommon(true);
            this.commonClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public GlobalClause addGlobalClause(Cobol85Parser.LibraryIsGlobalClauseContext ctx) {
        GlobalClause result = (GlobalClause)this.getASGElement(ctx);
        if (result == null) {
            result = new GlobalClauseImpl(this.programUnit, ctx);
            result.setGlobal(true);
            this.globalClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ImportAttribute addImportAttribute(Cobol85Parser.LibraryAttributeClauseFormat2Context ctx) {
        ImportAttribute result = (ImportAttribute)this.getASGElement(ctx);
        if (result == null) {
            result = new ImportAttributeImpl(this.programUnit, ctx);
            ImportAttribute.ImportAttributeType type = ctx.BYFUNCTION() != null ? ImportAttribute.ImportAttributeType.BY_FUNCTION : (ctx.BYTITLE() != null ? ImportAttribute.ImportAttributeType.BY_TITLE : null);
            result.setImportAttributeType(type);
            if (ctx.libraryAttributeFunction() != null) {
                Literal functionLiteral = this.createLiteral(ctx.libraryAttributeFunction().literal());
                result.setFunctionLiteral(functionLiteral);
            }
            if (ctx.libraryAttributeParameter() != null) {
                Literal parameterLiteral = this.createLiteral(ctx.libraryAttributeParameter().literal());
                result.setParameterLiteral(parameterLiteral);
            }
            if (ctx.libraryAttributeTitle() != null) {
                Literal titleLiteral = this.createLiteral(ctx.libraryAttributeTitle().literal());
                result.setTitleLiteral(titleLiteral);
            }
            this.importAttributes.add(result);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ImportEntryProcedure addImportEntryProcedure(Cobol85Parser.LibraryEntryProcedureClauseFormat2Context ctx) {
        ImportEntryProcedure result = (ImportEntryProcedure)this.getASGElement(ctx);
        if (result == null) {
            result = new ImportEntryProcedureImpl(this.programUnit, ctx);
            Call programCall = this.createCall(ctx.programName());
            result.setProgramCall(programCall);
            if (ctx.libraryEntryProcedureForClause() != null) {
                result.addForClause(ctx.libraryEntryProcedureForClause());
            }
            if (ctx.libraryEntryProcedureWithClause() != null) {
                result.addWithClause(ctx.libraryEntryProcedureWithClause());
            }
            if (ctx.libraryEntryProcedureUsingClause() != null) {
                result.addUsingClause(ctx.libraryEntryProcedureUsingClause());
            }
            if (ctx.libraryEntryProcedureGivingClause() != null) {
                result.addGivingClause(ctx.libraryEntryProcedureGivingClause());
            }
            this.importEntryProcedures.add(result);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public CommonClause getCommonClause() {
        return this.commonClause;
    }

    @Override
    public GlobalClause getGlobalClause() {
        return this.globalClause;
    }

    @Override
    public List<ImportAttribute> getImportAttributes() {
        return this.importAttributes;
    }

    @Override
    public List<ImportEntryProcedure> getImportEntryProcedures() {
        return this.importEntryProcedures;
    }

    @Override
    public LibraryDescriptionEntry.LibraryDescriptionEntryType getLibraryDescriptionEntryType() {
        return LibraryDescriptionEntry.LibraryDescriptionEntryType.IMPORT;
    }
}

