/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.data.programlibrary.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.data.programlibrary.LibraryDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.programlibrary.LibraryDescriptionEntryExport;
import io.proleap.cobol.asg.metamodel.data.programlibrary.LibraryDescriptionEntryImport;
import io.proleap.cobol.asg.metamodel.data.programlibrary.ProgramLibrarySection;
import io.proleap.cobol.asg.metamodel.data.programlibrary.impl.LibraryDescriptionEntryExportImpl;
import io.proleap.cobol.asg.metamodel.data.programlibrary.impl.LibraryDescriptionEntryImportImpl;
import io.proleap.cobol.asg.metamodel.impl.CobolDivisionElementImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProgramLibrarySectionImpl
extends CobolDivisionElementImpl
implements ProgramLibrarySection {
    private static final Logger LOG = LogManager.getLogger(ProgramLibrarySectionImpl.class);
    protected final Cobol85Parser.ProgramLibrarySectionContext ctx;
    protected List<LibraryDescriptionEntry> libraryDescriptionEntries = new ArrayList<LibraryDescriptionEntry>();
    protected Map<String, LibraryDescriptionEntry> libraryDescriptionEntriesSymbolTable = new HashMap<String, LibraryDescriptionEntry>();

    public ProgramLibrarySectionImpl(ProgramUnit programUnit, Cobol85Parser.ProgramLibrarySectionContext ctx) {
        super(programUnit, (ParserRuleContext)ctx);
        this.ctx = ctx;
    }

    @Override
    public LibraryDescriptionEntryExport addLibraryDescriptionEntryExport(Cobol85Parser.LibraryDescriptionEntryFormat1Context ctx) {
        LibraryDescriptionEntryExport result = (LibraryDescriptionEntryExport)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx.libraryName());
            result = new LibraryDescriptionEntryExportImpl(name, this.programUnit, ctx);
            if (ctx.libraryAttributeClauseFormat1() != null) {
                result.addExportAttribute(ctx.libraryAttributeClauseFormat1());
            }
            if (ctx.libraryEntryProcedureClauseFormat1() != null) {
                result.addExportEntryProcedure(ctx.libraryEntryProcedureClauseFormat1());
            }
            this.libraryDescriptionEntries.add(result);
            this.libraryDescriptionEntriesSymbolTable.put(name, result);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public LibraryDescriptionEntryImport addLibraryDescriptionEntryImport(Cobol85Parser.LibraryDescriptionEntryFormat2Context ctx) {
        LibraryDescriptionEntryImport result = (LibraryDescriptionEntryImport)this.getASGElement(ctx);
        if (result == null) {
            Cobol85Parser.LibraryIsCommonClauseContext libraryIsCommonClause;
            String name = this.determineName(ctx.libraryName());
            result = new LibraryDescriptionEntryImportImpl(name, this.programUnit, ctx);
            Cobol85Parser.LibraryIsGlobalClauseContext libraryIsGlobalClause = ctx.libraryIsGlobalClause();
            if (libraryIsGlobalClause != null) {
                result.addGlobalClause(libraryIsGlobalClause);
            }
            if ((libraryIsCommonClause = ctx.libraryIsCommonClause()) != null) {
                result.addCommonClause(libraryIsCommonClause);
            }
            for (Cobol85Parser.LibraryAttributeClauseFormat2Context libraryAttributeClauseFormat2Context : ctx.libraryAttributeClauseFormat2()) {
                result.addImportAttribute(libraryAttributeClauseFormat2Context);
            }
            for (Cobol85Parser.LibraryEntryProcedureClauseFormat2Context libraryEntryProcedureClauseFormat2Context : ctx.libraryEntryProcedureClauseFormat2()) {
                result.addImportEntryProcedure(libraryEntryProcedureClauseFormat2Context);
            }
            this.libraryDescriptionEntries.add(result);
            this.libraryDescriptionEntriesSymbolTable.put(name, result);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public LibraryDescriptionEntry createLibraryDescriptionEntry(Cobol85Parser.LibraryDescriptionEntryContext ctx) {
        LibraryDescriptionEntry result;
        if (ctx.libraryDescriptionEntryFormat1() != null) {
            result = this.addLibraryDescriptionEntryExport(ctx.libraryDescriptionEntryFormat1());
        } else if (ctx.libraryDescriptionEntryFormat2() != null) {
            result = this.addLibraryDescriptionEntryImport(ctx.libraryDescriptionEntryFormat2());
        } else {
            LOG.warn("unknown program library description entry {}", (Object)ctx);
            result = null;
        }
        return result;
    }

    @Override
    public List<LibraryDescriptionEntry> getLibraryDescriptionEntries() {
        return this.libraryDescriptionEntries;
    }

    @Override
    public LibraryDescriptionEntry getLibraryDescriptionEntry(String name) {
        return this.libraryDescriptionEntriesSymbolTable.get(name);
    }
}

