/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.ASGElement;
import io.proleap.cobol.asg.metamodel.CompilationUnit;
import io.proleap.cobol.asg.metamodel.Program;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.impl.ASGElementImpl;
import io.proleap.cobol.asg.metamodel.impl.ProgramUnitImpl;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class CompilationUnitImpl
extends ASGElementImpl
implements CompilationUnit {
    protected Cobol85Parser.CompilationUnitContext ctx;
    protected int fillerCounter = 0;
    protected List<String> lines;
    protected final String name;
    protected final List<ProgramUnit> programUnits = new ArrayList<ProgramUnit>();

    public CompilationUnitImpl(String name, Program program, Cobol85Parser.CompilationUnitContext ctx) {
        super(program, ctx);
        this.name = name;
        this.ctx = ctx;
        this.registerASGElement(this);
        program.registerCompilationUnit(this);
    }

    @Override
    public ProgramUnit addProgramUnit(Cobol85Parser.ProgramUnitContext ctx) {
        ProgramUnit result = (ProgramUnit)this.getASGElement(ctx);
        if (result == null) {
            result = new ProgramUnitImpl((CompilationUnit)this, ctx);
            this.registerASGElement(result);
            this.programUnits.add(result);
            result.addIdentificationDivision(ctx.identificationDivision());
            if (ctx.environmentDivision() != null) {
                result.addEnvironmentDivision(ctx.environmentDivision());
            }
            if (ctx.dataDivision() != null) {
                result.addDataDivision(ctx.dataDivision());
            }
            if (ctx.procedureDivision() != null) {
                result.addProcedureDivision(ctx.procedureDivision());
            }
        }
        return result;
    }

    protected ASGElement getASGElement(ParserRuleContext ctx) {
        ASGElement result = this.program.getASGElementRegistry().getASGElement((ParseTree)ctx);
        return result;
    }

    @Override
    public Cobol85Parser.CompilationUnitContext getCtx() {
        return this.ctx;
    }

    @Override
    public List<String> getLines() {
        return this.lines;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ProgramUnit getProgramUnit() {
        ProgramUnit result = this.programUnits.isEmpty() ? null : this.programUnits.get(0);
        return result;
    }

    @Override
    public List<ProgramUnit> getProgramUnits() {
        return this.programUnits;
    }

    @Override
    public int incrementFillerCounter() {
        return this.fillerCounter++;
    }

    protected void registerASGElement(ASGElement asgElement) {
        assert (asgElement != null);
        assert (asgElement.getCtx() != null);
        this.program.getASGElementRegistry().addASGElement(asgElement);
    }

    @Override
    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    public String toString() {
        return "name=[" + this.name + "]";
    }
}

