/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.ASGElement;
import io.proleap.cobol.asg.metamodel.BooleanLiteral;
import io.proleap.cobol.asg.metamodel.FigurativeConstant;
import io.proleap.cobol.asg.metamodel.IntegerLiteral;
import io.proleap.cobol.asg.metamodel.Literal;
import io.proleap.cobol.asg.metamodel.MnemonicName;
import io.proleap.cobol.asg.metamodel.NumericLiteral;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.ProgramUnitElement;
import io.proleap.cobol.asg.metamodel.call.Call;
import io.proleap.cobol.asg.metamodel.call.CommunicationDescriptionEntryCall;
import io.proleap.cobol.asg.metamodel.call.DataDescriptionEntryCall;
import io.proleap.cobol.asg.metamodel.call.FileControlEntryCall;
import io.proleap.cobol.asg.metamodel.call.FunctionCall;
import io.proleap.cobol.asg.metamodel.call.IndexCall;
import io.proleap.cobol.asg.metamodel.call.ProcedureCall;
import io.proleap.cobol.asg.metamodel.call.ReportCall;
import io.proleap.cobol.asg.metamodel.call.ReportDescriptionEntryCall;
import io.proleap.cobol.asg.metamodel.call.SpecialRegisterCall;
import io.proleap.cobol.asg.metamodel.call.TableCall;
import io.proleap.cobol.asg.metamodel.call.impl.CallDelegateImpl;
import io.proleap.cobol.asg.metamodel.call.impl.CommunicationDescriptionEntryCallImpl;
import io.proleap.cobol.asg.metamodel.call.impl.DataDescriptionEntryCallImpl;
import io.proleap.cobol.asg.metamodel.call.impl.EnvironmentCallImpl;
import io.proleap.cobol.asg.metamodel.call.impl.FileControlEntryCallImpl;
import io.proleap.cobol.asg.metamodel.call.impl.FunctionCallImpl;
import io.proleap.cobol.asg.metamodel.call.impl.IndexCallImpl;
import io.proleap.cobol.asg.metamodel.call.impl.MnemonicCallImpl;
import io.proleap.cobol.asg.metamodel.call.impl.ProcedureCallImpl;
import io.proleap.cobol.asg.metamodel.call.impl.ReportCallImpl;
import io.proleap.cobol.asg.metamodel.call.impl.ReportDescriptionEntryCallImpl;
import io.proleap.cobol.asg.metamodel.call.impl.SpecialRegisterCallImpl;
import io.proleap.cobol.asg.metamodel.call.impl.TableCallImpl;
import io.proleap.cobol.asg.metamodel.call.impl.UndefinedCallImpl;
import io.proleap.cobol.asg.metamodel.data.DataDivision;
import io.proleap.cobol.asg.metamodel.data.communication.CommunicationDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.communication.CommunicationSection;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntryGroup;
import io.proleap.cobol.asg.metamodel.data.datadescription.Index;
import io.proleap.cobol.asg.metamodel.data.datadescription.OccursClause;
import io.proleap.cobol.asg.metamodel.data.file.FileDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.file.FileSection;
import io.proleap.cobol.asg.metamodel.data.linkage.LinkageSection;
import io.proleap.cobol.asg.metamodel.data.localstorage.LocalStorageSection;
import io.proleap.cobol.asg.metamodel.data.report.ReportDescription;
import io.proleap.cobol.asg.metamodel.data.report.ReportDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.report.ReportSection;
import io.proleap.cobol.asg.metamodel.data.workingstorage.WorkingStorageSection;
import io.proleap.cobol.asg.metamodel.environment.EnvironmentDivision;
import io.proleap.cobol.asg.metamodel.environment.inputoutput.InputOutputSection;
import io.proleap.cobol.asg.metamodel.environment.inputoutput.filecontrol.FileControlEntry;
import io.proleap.cobol.asg.metamodel.environment.inputoutput.filecontrol.FileControlParagraph;
import io.proleap.cobol.asg.metamodel.impl.BooleanLiteralImpl;
import io.proleap.cobol.asg.metamodel.impl.CompilationUnitElementImpl;
import io.proleap.cobol.asg.metamodel.impl.FigurativeConstantImpl;
import io.proleap.cobol.asg.metamodel.impl.IntegerLiteralImpl;
import io.proleap.cobol.asg.metamodel.impl.LiteralImpl;
import io.proleap.cobol.asg.metamodel.impl.MnemonicNameImpl;
import io.proleap.cobol.asg.metamodel.impl.NumericLiteralImpl;
import io.proleap.cobol.asg.metamodel.procedure.Paragraph;
import io.proleap.cobol.asg.metamodel.procedure.ProcedureDivision;
import io.proleap.cobol.asg.metamodel.valuestmt.ArithmeticValueStmt;
import io.proleap.cobol.asg.metamodel.valuestmt.BooleanLiteralValueStmt;
import io.proleap.cobol.asg.metamodel.valuestmt.CallValueStmt;
import io.proleap.cobol.asg.metamodel.valuestmt.ConditionValueStmt;
import io.proleap.cobol.asg.metamodel.valuestmt.IntegerLiteralValueStmt;
import io.proleap.cobol.asg.metamodel.valuestmt.LiteralValueStmt;
import io.proleap.cobol.asg.metamodel.valuestmt.RelationConditionValueStmt;
import io.proleap.cobol.asg.metamodel.valuestmt.ValueStmt;
import io.proleap.cobol.asg.metamodel.valuestmt.impl.ArithmeticValueStmtImpl;
import io.proleap.cobol.asg.metamodel.valuestmt.impl.BooleanLiteralValueStmtImpl;
import io.proleap.cobol.asg.metamodel.valuestmt.impl.CallValueStmtImpl;
import io.proleap.cobol.asg.metamodel.valuestmt.impl.ConditionValueStmtImpl;
import io.proleap.cobol.asg.metamodel.valuestmt.impl.IntegerLiteralValueStmtImpl;
import io.proleap.cobol.asg.metamodel.valuestmt.impl.LiteralValueStmtImpl;
import io.proleap.cobol.asg.metamodel.valuestmt.impl.RelationConditionValueStmtImpl;
import io.proleap.cobol.asg.util.StringUtils;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProgramUnitElementImpl
extends CompilationUnitElementImpl
implements ProgramUnitElement {
    private static final String HEX_PREFIX = "X\"";
    private static final Logger LOG = LogManager.getLogger(ProgramUnitElementImpl.class);
    protected ProgramUnit programUnit;

    public ProgramUnitElementImpl(ProgramUnit programUnit, ParserRuleContext ctx) {
        super(programUnit.getCompilationUnit(), ctx);
        this.programUnit = programUnit;
    }

    protected ArithmeticValueStmt createArithmeticValueStmt(Cobol85Parser.ArithmeticExpressionContext ctx) {
        ArithmeticValueStmt result = (ArithmeticValueStmt)this.getASGElement(ctx);
        if (result == null) {
            result = new ArithmeticValueStmtImpl(this.programUnit, ctx);
            result.addMultDivs(ctx.multDivs());
            for (Cobol85Parser.PlusMinusContext plusMinusContext : ctx.plusMinus()) {
                result.addPlusMinus(plusMinusContext);
            }
            this.registerASGElement(result);
        }
        return result;
    }

    protected BooleanLiteral createBooleanLiteral(Cobol85Parser.BooleanLiteralContext ctx) {
        BooleanLiteral result = (BooleanLiteral)this.getASGElement(ctx);
        if (result == null) {
            Boolean value = StringUtils.parseBoolean(ctx.getText());
            result = new BooleanLiteralImpl(value, this.programUnit, ctx);
            this.registerASGElement(result);
        }
        return result;
    }

    protected BooleanLiteralValueStmt createBooleanLiteralValueStmt(Cobol85Parser.BooleanLiteralContext ctx) {
        BooleanLiteral booleanLiteral = this.createBooleanLiteral(ctx);
        BooleanLiteralValueStmtImpl result = new BooleanLiteralValueStmtImpl(this.programUnit, ctx);
        result.setBooleanLiteral(booleanLiteral);
        return result;
    }

    protected Call createCall(Cobol85Parser.AlphabetNameContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            result = this.createUndefinedCall(ctx);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.AssignmentNameContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            result = this.createUndefinedCall(ctx);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.CdNameContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            CommunicationDescriptionEntry communicationDescriptionEntry = this.findCommunicationDescriptionEntry(name);
            if (communicationDescriptionEntry == null) {
                LOG.warn("call to unknown communication description element {}", (Object)name);
                result = this.createUndefinedCall(ctx);
            } else {
                result = this.createCommunicationDescriptionEntryCall(name, communicationDescriptionEntry, ctx);
            }
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.ClassNameContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            result = this.createUndefinedCall(ctx);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.CobolWordContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            result = this.createUndefinedCall(ctx);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.ConditionNameContext ctx) {
        Call result = this.createDataDescriptionEntryCall(ctx);
        return result;
    }

    protected Call createCall(Cobol85Parser.DataDescNameContext ctx) {
        Call result = this.createDataDescriptionEntryCall(ctx);
        return result;
    }

    protected Call createCall(Cobol85Parser.DataNameContext ctx) {
        Call result = this.createDataDescriptionEntryCall(ctx);
        return result;
    }

    protected Call createCall(Cobol85Parser.EnvironmentNameContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new EnvironmentCallImpl(name, this.programUnit, ctx);
            this.registerASGElement(result);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.FileNameContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            FileControlEntry fileControlEntry = this.findFileControlEntry(name);
            result = fileControlEntry == null ? this.createDataDescriptionEntryCall(ctx) : this.createFileControlEntryCall(name, fileControlEntry, ctx);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.FunctionCallContext ctx) {
        FunctionCall result = (FunctionCall)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            FunctionCallImpl functionCall = new FunctionCallImpl(name, this.programUnit, ctx);
            result = functionCall;
            this.registerASGElement(result);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.IdentifierContext ctx) {
        Call result;
        if (ctx.specialRegister() != null) {
            Call specialRegisterCall = this.createCall(ctx.specialRegister());
            result = new CallDelegateImpl(specialRegisterCall, this.programUnit, ctx);
            this.registerASGElement(result);
        } else if (ctx.tableCall() != null) {
            Call tableCall = this.createCall(ctx.tableCall());
            result = new CallDelegateImpl(tableCall, this.programUnit, ctx);
            this.registerASGElement(result);
        } else if (ctx.functionCall() != null) {
            Call functionCall = this.createCall(ctx.functionCall());
            result = new CallDelegateImpl(functionCall, this.programUnit, ctx);
            this.registerASGElement(result);
        } else {
            result = this.createDataDescriptionEntryCall(ctx);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.LibraryNameContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            result = this.createUndefinedCall(ctx);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.LocalNameContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            result = this.createUndefinedCall(ctx);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.MnemonicNameContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new MnemonicCallImpl(name, this.programUnit, ctx);
            this.registerASGElement(result);
        }
        return result;
    }

    protected Call createCall(ParserRuleContext ... ctxs) {
        Call result = null;
        for (ParserRuleContext ctx : ctxs) {
            if (result != null) break;
            if (ctx == null) continue;
            if (ctx instanceof Cobol85Parser.IdentifierContext) {
                result = this.createCall((Cobol85Parser.IdentifierContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.CdNameContext) {
                result = this.createCall((Cobol85Parser.CdNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.AlphabetNameContext) {
                result = this.createCall((Cobol85Parser.AlphabetNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.AssignmentNameContext) {
                result = this.createCall((Cobol85Parser.AssignmentNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.ClassNameContext) {
                result = this.createCall((Cobol85Parser.ClassNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.CobolWordContext) {
                result = this.createCall((Cobol85Parser.CobolWordContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.ConditionNameContext) {
                result = this.createCall((Cobol85Parser.ConditionNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.DataDescNameContext) {
                result = this.createCall((Cobol85Parser.DataDescNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.DataNameContext) {
                result = this.createCall((Cobol85Parser.DataNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.EnvironmentNameContext) {
                result = this.createCall((Cobol85Parser.EnvironmentNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.FileNameContext) {
                result = this.createCall((Cobol85Parser.FileNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.LibraryNameContext) {
                result = this.createCall((Cobol85Parser.LibraryNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.LocalNameContext) {
                result = this.createCall((Cobol85Parser.LocalNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.MnemonicNameContext) {
                result = this.createCall((Cobol85Parser.MnemonicNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.ProcedureNameContext) {
                result = this.createCall((Cobol85Parser.ProcedureNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.ProgramNameContext) {
                result = this.createCall((Cobol85Parser.ProgramNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.QualifiedDataNameContext) {
                result = this.createCall((Cobol85Parser.QualifiedDataNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.RecordNameContext) {
                result = this.createCall((Cobol85Parser.RecordNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.ReportNameContext) {
                result = this.createCall((Cobol85Parser.ReportNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.SpecialRegisterContext) {
                result = this.createCall((Cobol85Parser.SpecialRegisterContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.SystemNameContext) {
                result = this.createCall((Cobol85Parser.SystemNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.SpecialRegisterContext) {
                result = this.createCall((Cobol85Parser.SpecialRegisterContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.TableCallContext) {
                result = this.createCall((Cobol85Parser.TableCallContext)ctx);
                continue;
            }
            LOG.warn("unknown call at {}", (Object)ctx);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.ProcedureNameContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            Paragraph paragraph = this.findProcedure(name);
            result = paragraph == null ? this.createUndefinedCall(ctx) : this.createProcedureCall(name, paragraph, ctx);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.ProgramNameContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            result = this.createUndefinedCall(ctx);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.QualifiedDataNameContext ctx) {
        Call result = this.createDataDescriptionEntryCall(ctx);
        return result;
    }

    protected Call createCall(Cobol85Parser.RecordNameContext ctx) {
        Call result = this.createDataDescriptionEntryCall(ctx);
        return result;
    }

    protected Call createCall(Cobol85Parser.ReportNameContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            ReportDescription report = this.findReportDescription(name);
            result = report == null ? this.createUndefinedCall(ctx) : this.createReportCall(name, report, ctx);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.SpecialRegisterContext ctx) {
        SpecialRegisterCall result = (SpecialRegisterCall)this.getASGElement(ctx);
        if (result == null) {
            SpecialRegisterCall.SpecialRegisterType type = ctx.ADDRESS() != null ? SpecialRegisterCall.SpecialRegisterType.ADDRESS_OF : (ctx.DATE() != null ? SpecialRegisterCall.SpecialRegisterType.DATE : (ctx.DAY() != null ? SpecialRegisterCall.SpecialRegisterType.DAY : (ctx.DAY_OF_WEEK() != null ? SpecialRegisterCall.SpecialRegisterType.DAY_OF_WEEK : (ctx.DEBUG_CONTENTS() != null ? SpecialRegisterCall.SpecialRegisterType.DEBUG_CONTENTS : (ctx.DEBUG_ITEM() != null ? SpecialRegisterCall.SpecialRegisterType.DEBUG_ITEM : (ctx.DEBUG_LINE() != null ? SpecialRegisterCall.SpecialRegisterType.DEBUG_LINE : (ctx.DEBUG_NAME() != null ? SpecialRegisterCall.SpecialRegisterType.DEBUG_NAME : (ctx.DEBUG_SUB_1() != null ? SpecialRegisterCall.SpecialRegisterType.DEBUG_SUB_1 : (ctx.DEBUG_SUB_2() != null ? SpecialRegisterCall.SpecialRegisterType.DEBUG_SUB_2 : (ctx.DEBUG_SUB_3() != null ? SpecialRegisterCall.SpecialRegisterType.DEBUG_SUB_3 : (ctx.LENGTH() != null ? SpecialRegisterCall.SpecialRegisterType.LENGTH_OF : (ctx.LINAGE_COUNTER() != null ? SpecialRegisterCall.SpecialRegisterType.LINAGE_COUNTER : (ctx.LINE_COUNTER() != null ? SpecialRegisterCall.SpecialRegisterType.LINE_COUNTER : (ctx.PAGE_COUNTER() != null ? SpecialRegisterCall.SpecialRegisterType.PAGE_COUNTER : (ctx.RETURN_CODE() != null ? SpecialRegisterCall.SpecialRegisterType.RETURN_CODE : (ctx.SHIFT_IN() != null ? SpecialRegisterCall.SpecialRegisterType.SHIFT_IN : (ctx.SHIFT_OUT() != null ? SpecialRegisterCall.SpecialRegisterType.SHIFT_OUT : (ctx.SORT_CONTROL() != null ? SpecialRegisterCall.SpecialRegisterType.SORT_CONTROL : (ctx.SORT_CORE_SIZE() != null ? SpecialRegisterCall.SpecialRegisterType.SORT_CORE_SIZE : (ctx.SORT_FILE_SIZE() != null ? SpecialRegisterCall.SpecialRegisterType.SORT_FILE_SIZE : (ctx.SORT_MESSAGE() != null ? SpecialRegisterCall.SpecialRegisterType.SORT_MESSAGE : (ctx.SORT_MODE_SIZE() != null ? SpecialRegisterCall.SpecialRegisterType.SORT_MODE_SIZE : (ctx.SORT_RETURN() != null ? SpecialRegisterCall.SpecialRegisterType.SORT_RETURN : (ctx.TALLY() != null ? SpecialRegisterCall.SpecialRegisterType.TALLY : (ctx.TIME() != null ? SpecialRegisterCall.SpecialRegisterType.TIME : (ctx.WHEN_COMPILED() != null ? SpecialRegisterCall.SpecialRegisterType.WHEN_COMPILED : null))))))))))))))))))))))))));
            result = new SpecialRegisterCallImpl(type, this.programUnit, ctx);
            if (ctx.identifier() != null) {
                Call identifierCall = this.createCall(ctx.identifier());
                result.setIdentifierCall(identifierCall);
            }
            this.registerASGElement(result);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.SystemNameContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            result = this.createUndefinedCall(ctx);
        }
        return result;
    }

    protected Call createCall(Cobol85Parser.TableCallContext ctx) {
        Call result = (TableCall)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            DataDescriptionEntry dataDescriptionEntry = this.findDataDescriptionEntry(name);
            if (dataDescriptionEntry != null) {
                TableCallImpl tableCall = new TableCallImpl(name, dataDescriptionEntry, this.programUnit, ctx);
                this.linkDataDescriptionEntryCallWithDataDescriptionEntry(tableCall, dataDescriptionEntry);
                for (Cobol85Parser.SubscriptContext subscriptContext : ctx.subscript()) {
                    tableCall.addSubscript(subscriptContext);
                }
                result = tableCall;
                this.registerASGElement(result);
            } else {
                LOG.warn("call to unknown data element {}", (Object)name);
                result = this.createUndefinedCall(ctx);
            }
        }
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.AlphabetNameContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.AssignmentNameContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.ClassNameContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.CobolWordContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.DataDescNameContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.DataNameContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.FileNameContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.IdentifierContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.IndexNameContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.LibraryNameContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.LocalNameContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.ProgramNameContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.QualifiedDataNameContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.ReportNameContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CallValueStmt createCallValueStmt(Cobol85Parser.SystemNameContext ctx) {
        Call delegatedCall = this.createCall(ctx);
        CallValueStmtImpl result = new CallValueStmtImpl(delegatedCall, this.programUnit, ctx);
        return result;
    }

    protected CommunicationDescriptionEntryCall createCommunicationDescriptionEntryCall(String name, CommunicationDescriptionEntry communicationDescriptionEntry, Cobol85Parser.CdNameContext ctx) {
        CommunicationDescriptionEntryCall result = (CommunicationDescriptionEntryCall)this.getASGElement(ctx);
        if (result == null) {
            result = new CommunicationDescriptionEntryCallImpl(name, communicationDescriptionEntry, this.programUnit, ctx);
            this.linkCommunicationDescriptionEntryCallWithCommunicationDescriptionEntry(result, communicationDescriptionEntry);
            this.registerASGElement(result);
        }
        return result;
    }

    protected ConditionValueStmt createConditionValueStmt(Cobol85Parser.ConditionContext ctx) {
        ConditionValueStmt result = (ConditionValueStmt)this.getASGElement(ctx);
        if (result == null) {
            result = new ConditionValueStmtImpl(this.programUnit, ctx);
            result.addCombinableCondition(ctx.combinableCondition());
            for (Cobol85Parser.AndOrConditionContext andOrConditionContext : ctx.andOrCondition()) {
                result.addAndOrCondition(andOrConditionContext);
            }
            this.registerASGElement(result);
        }
        return result;
    }

    protected Call createDataDescriptionEntryCall(ParserRuleContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            Index index = this.findIndex(name);
            DataDescriptionEntry dataDescriptionEntry = this.findDataDescriptionEntry(name);
            if (index != null) {
                result = this.createIndexCall(ctx);
            } else if (dataDescriptionEntry != null) {
                result = this.createDataDescriptionEntryCall(name, dataDescriptionEntry, ctx);
            } else {
                LOG.warn("call to unknown data element {}", (Object)name);
                result = this.createUndefinedCall(ctx);
            }
        }
        return result;
    }

    protected DataDescriptionEntryCall createDataDescriptionEntryCall(String name, DataDescriptionEntry dataDescriptionEntry, ParserRuleContext ctx) {
        DataDescriptionEntryCall result = (DataDescriptionEntryCall)this.getASGElement(ctx);
        if (result == null) {
            result = new DataDescriptionEntryCallImpl(name, dataDescriptionEntry, this.programUnit, ctx);
            this.linkDataDescriptionEntryCallWithDataDescriptionEntry(result, dataDescriptionEntry);
            this.registerASGElement(result);
        }
        return result;
    }

    protected FigurativeConstant createFigurativeConstant(Cobol85Parser.FigurativeConstantContext ctx) {
        FigurativeConstant result = (FigurativeConstant)this.getASGElement(ctx);
        if (result == null) {
            FigurativeConstant.FigurativeConstantType type = ctx.ALL() != null ? FigurativeConstant.FigurativeConstantType.ALL : (ctx.HIGH_VALUE() != null ? FigurativeConstant.FigurativeConstantType.HIGH_VALUE : (ctx.HIGH_VALUES() != null ? FigurativeConstant.FigurativeConstantType.HIGH_VALUES : (ctx.LOW_VALUE() != null ? FigurativeConstant.FigurativeConstantType.LOW_VALUE : (ctx.LOW_VALUES() != null ? FigurativeConstant.FigurativeConstantType.LOW_VALUES : (ctx.NULL() != null ? FigurativeConstant.FigurativeConstantType.NULL : (ctx.NULLS() != null ? FigurativeConstant.FigurativeConstantType.NULLS : (ctx.QUOTE() != null ? FigurativeConstant.FigurativeConstantType.QUOTE : (ctx.QUOTES() != null ? FigurativeConstant.FigurativeConstantType.QUOTES : (ctx.SPACE() != null ? FigurativeConstant.FigurativeConstantType.SPACE : (ctx.SPACES() != null ? FigurativeConstant.FigurativeConstantType.SPACES : (ctx.ZERO() != null ? FigurativeConstant.FigurativeConstantType.ZERO : (ctx.ZEROS() != null ? FigurativeConstant.FigurativeConstantType.ZEROS : (ctx.ZEROES() != null ? FigurativeConstant.FigurativeConstantType.ZEROES : null)))))))))))));
            result = new FigurativeConstantImpl(type, this.programUnit, ctx);
            if (ctx.literal() != null) {
                Literal literal = this.createLiteral(ctx.literal());
                result.setLiteral(literal);
            }
            this.registerASGElement(result);
        }
        return result;
    }

    protected FileControlEntryCall createFileControlEntryCall(String name, FileControlEntry fileControlEntry, Cobol85Parser.FileNameContext ctx) {
        FileControlEntryCall result = (FileControlEntryCall)this.getASGElement(ctx);
        if (result == null) {
            result = new FileControlEntryCallImpl(name, fileControlEntry, this.programUnit, ctx);
            this.linkFileControlEntryCallWithFileControlEntry(result, fileControlEntry);
            this.registerASGElement(result);
        }
        return result;
    }

    protected IndexCall createIndexCall(ParserRuleContext ctx) {
        IndexCall result = (IndexCall)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            Index index = this.findIndex(name);
            if (index == null) {
                this.createDataDescriptionEntryCall(ctx);
            } else {
                result = new IndexCallImpl(name, index, this.programUnit, ctx);
                this.linkIndexCallWithIndex(result, index);
                this.registerASGElement(result);
            }
        }
        return result;
    }

    protected IntegerLiteral createIntegerLiteral(Cobol85Parser.IntegerLiteralContext ctx) {
        IntegerLiteral result = (IntegerLiteral)this.getASGElement(ctx);
        if (result == null) {
            Integer value = StringUtils.parseInteger(ctx.getText());
            result = new IntegerLiteralImpl(value, this.programUnit, ctx);
            this.registerASGElement(result);
        }
        return result;
    }

    protected IntegerLiteralValueStmt createIntegerLiteralValueStmt(Cobol85Parser.IntegerLiteralContext ctx) {
        IntegerLiteral integerLiteral = this.createIntegerLiteral(ctx);
        IntegerLiteralValueStmtImpl result = new IntegerLiteralValueStmtImpl(this.programUnit, ctx);
        result.setIntegerLiteral(integerLiteral);
        return result;
    }

    protected Literal createLiteral(Cobol85Parser.LiteralContext ctx) {
        Literal result = (Literal)this.getASGElement(ctx);
        if (result == null) {
            Literal.LiteralType type;
            result = new LiteralImpl(this.programUnit, ctx);
            if (ctx.NONNUMERICLITERAL() != null) {
                String text = ctx.getText();
                boolean isHex = text.startsWith(HEX_PREFIX);
                String nonNumericLiteral = isHex ? text : text.substring(1, text.length() - 1);
                result.setNonNumericLiteral(nonNumericLiteral);
                type = Literal.LiteralType.NON_NUMERIC;
            } else if (ctx.numericLiteral() != null) {
                NumericLiteral numericLiteral = this.createNumericLiteral(ctx.numericLiteral());
                result.setNumericLiteral(numericLiteral);
                type = Literal.LiteralType.NUMERIC;
            } else if (ctx.booleanLiteral() != null) {
                BooleanLiteral booleanLiteral = this.createBooleanLiteral(ctx.booleanLiteral());
                result.setBooleanLiteral(booleanLiteral);
                type = Literal.LiteralType.BOOLEAN;
            } else if (ctx.figurativeConstant() != null) {
                FigurativeConstant figurativeConstant = this.createFigurativeConstant(ctx.figurativeConstant());
                result.setFigurativeConstant(figurativeConstant);
                type = Literal.LiteralType.FIGURATIVE_CONSTANT;
            } else {
                type = ctx.cicsDfhRespLiteral() != null ? Literal.LiteralType.CICS_DFH_RESP : (ctx.cicsDfhValueLiteral() != null ? Literal.LiteralType.CICS_DFH_VALUE : null);
            }
            result.setLiteralType(type);
            this.registerASGElement(result);
        }
        return result;
    }

    protected LiteralValueStmt createLiteralValueStmt(Cobol85Parser.LiteralContext ctx) {
        Literal literal = this.createLiteral(ctx);
        LiteralValueStmtImpl result = new LiteralValueStmtImpl(this.programUnit, ctx);
        result.setLiteral(literal);
        return result;
    }

    protected MnemonicName createMnemonicName(Cobol85Parser.MnemonicNameContext ctx) {
        MnemonicName result = (MnemonicName)this.getASGElement(ctx);
        if (result == null) {
            String value = ctx.getText();
            result = new MnemonicNameImpl(value, this.programUnit, ctx);
            this.registerASGElement(result);
        }
        return result;
    }

    protected NumericLiteral createNumericLiteral(Cobol85Parser.NumericLiteralContext ctx) {
        NumericLiteral result = (NumericLiteral)this.getASGElement(ctx);
        if (result == null) {
            NumericLiteral.NumericLiteralType type;
            result = new NumericLiteralImpl(this.programUnit, ctx);
            if (ctx.integerLiteral() != null) {
                Integer integerValue = StringUtils.parseInteger(ctx.getText());
                result.setIntegerValue(integerValue);
                type = NumericLiteral.NumericLiteralType.INTEGER;
            } else if (ctx.ZERO() != null) {
                result.setIntegerValue(0);
                type = NumericLiteral.NumericLiteralType.INTEGER;
            } else if (ctx.NUMERICLITERAL() != null) {
                Double doubleValue = StringUtils.parseDouble(ctx.NUMERICLITERAL().getText());
                result.setDoubleValue(doubleValue);
                type = NumericLiteral.NumericLiteralType.DOUBLE;
            } else {
                type = null;
            }
            result.setNumericLiteralType(type);
            this.registerASGElement(result);
        }
        return result;
    }

    protected ProcedureCall createProcedureCall(String name, Paragraph paragraph, Cobol85Parser.ProcedureNameContext ctx) {
        ProcedureCall result = (ProcedureCall)this.getASGElement(ctx);
        if (result == null) {
            result = new ProcedureCallImpl(name, paragraph, this.programUnit, ctx);
            this.linkProcedureCallWithParagraph(result, paragraph);
            this.registerASGElement(result);
        }
        return result;
    }

    protected RelationConditionValueStmt createRelationConditionValueStmt(Cobol85Parser.RelationConditionContext ctx) {
        RelationConditionValueStmt result = (RelationConditionValueStmt)this.getASGElement(ctx);
        if (result == null) {
            RelationConditionValueStmt.RelationConditionType type;
            result = new RelationConditionValueStmtImpl(this.programUnit, ctx);
            if (ctx.relationSignCondition() != null) {
                result.addRelationSignCondition(ctx.relationSignCondition());
                type = RelationConditionValueStmt.RelationConditionType.SIGN;
            } else if (ctx.relationArithmeticComparison() != null) {
                result.addRelationArithmeticComparison(ctx.relationArithmeticComparison());
                type = RelationConditionValueStmt.RelationConditionType.ARITHMETIC;
            } else if (ctx.relationCombinedComparison() != null) {
                result.addRelationCombinedComparison(ctx.relationCombinedComparison());
                type = RelationConditionValueStmt.RelationConditionType.COMBINED;
            } else {
                type = null;
            }
            result.setRelationConditionType(type);
            this.registerASGElement(result);
        }
        return result;
    }

    protected ReportCall createReportCall(String name, ReportDescription report, Cobol85Parser.ReportNameContext ctx) {
        ReportCall result = (ReportCall)this.getASGElement(ctx);
        if (result == null) {
            result = new ReportCallImpl(name, report, this.programUnit, ctx);
            this.linkReportCallWithReport(result, report);
            this.registerASGElement(result);
        }
        return result;
    }

    protected ReportDescriptionEntryCall createReportDescriptionEntryCall(String name, ReportDescriptionEntry reportDescriptionEntry, Cobol85Parser.ReportNameContext ctx) {
        ReportDescriptionEntryCall result = (ReportDescriptionEntryCall)this.getASGElement(ctx);
        if (result == null) {
            result = new ReportDescriptionEntryCallImpl(name, reportDescriptionEntry, this.programUnit, ctx);
            this.linkReportDescriptionEntryCallWithReportDescriptionEntry(result, reportDescriptionEntry);
            this.registerASGElement(result);
        }
        return result;
    }

    protected Call createUndefinedCall(ParserRuleContext ctx) {
        Call result = (Call)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new UndefinedCallImpl(name, this.programUnit, ctx);
            this.registerASGElement(result);
        }
        return result;
    }

    protected ValueStmt createValueStmt(ParserRuleContext ... ctxs) {
        ValueStmt result = null;
        for (ParserRuleContext ctx : ctxs) {
            if (result != null) break;
            if (ctx == null) continue;
            if (ctx instanceof Cobol85Parser.IdentifierContext) {
                result = this.createCallValueStmt((Cobol85Parser.IdentifierContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.AlphabetNameContext) {
                result = this.createCallValueStmt((Cobol85Parser.AlphabetNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.ArithmeticExpressionContext) {
                result = this.createArithmeticValueStmt((Cobol85Parser.ArithmeticExpressionContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.AssignmentNameContext) {
                result = this.createCallValueStmt((Cobol85Parser.AssignmentNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.ClassNameContext) {
                result = this.createCallValueStmt((Cobol85Parser.ClassNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.CobolWordContext) {
                result = this.createCallValueStmt((Cobol85Parser.CobolWordContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.DataDescNameContext) {
                result = this.createCallValueStmt((Cobol85Parser.DataDescNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.DataNameContext) {
                result = this.createCallValueStmt((Cobol85Parser.DataNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.FileNameContext) {
                result = this.createCallValueStmt((Cobol85Parser.FileNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.IndexNameContext) {
                result = this.createCallValueStmt((Cobol85Parser.IndexNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.LibraryNameContext) {
                result = this.createCallValueStmt((Cobol85Parser.LibraryNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.LocalNameContext) {
                result = this.createCallValueStmt((Cobol85Parser.LocalNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.ProgramNameContext) {
                result = this.createCallValueStmt((Cobol85Parser.ProgramNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.QualifiedDataNameContext) {
                result = this.createCallValueStmt((Cobol85Parser.QualifiedDataNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.ReportNameContext) {
                result = this.createCallValueStmt((Cobol85Parser.ReportNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.SystemNameContext) {
                result = this.createCallValueStmt((Cobol85Parser.SystemNameContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.ConditionContext) {
                result = this.createConditionValueStmt((Cobol85Parser.ConditionContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.RelationConditionContext) {
                result = this.createRelationConditionValueStmt((Cobol85Parser.RelationConditionContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.IntegerLiteralContext) {
                result = this.createIntegerLiteralValueStmt((Cobol85Parser.IntegerLiteralContext)ctx);
                continue;
            }
            if (ctx instanceof Cobol85Parser.LiteralContext) {
                result = this.createLiteralValueStmt((Cobol85Parser.LiteralContext)ctx);
                continue;
            }
            LOG.warn("unknown value stmt at {}", (Object)ctx);
        }
        return result;
    }

    protected CommunicationDescriptionEntry findCommunicationDescriptionEntry(String name) {
        CommunicationSection communicationSection = this.findCommunicationSection();
        CommunicationDescriptionEntry result = communicationSection == null ? null : communicationSection.getCommunicationDescriptionEntry(name);
        return result;
    }

    protected CommunicationSection findCommunicationSection() {
        DataDivision dataDivision = this.programUnit.getDataDivision();
        CommunicationSection result = dataDivision == null ? null : dataDivision.getCommunicationSection();
        return result;
    }

    protected DataDescriptionEntry findDataDescriptionEntry(String name) {
        DataDescriptionEntry fileSectionResult;
        WorkingStorageSection workingStorageSection = this.findWorkingStorageSection();
        DataDescriptionEntry workingStorageSectionResult = workingStorageSection == null ? null : workingStorageSection.getDataDescriptionEntry(name);
        CommunicationSection communicationSection = this.findCommunicationSection();
        DataDescriptionEntry communicationSectionResult = communicationSection == null ? null : communicationSection.getDataDescriptionEntry(name);
        LinkageSection linkageSection = this.findLinkageSection();
        DataDescriptionEntry linkageSectionResult = linkageSection == null ? null : linkageSection.getDataDescriptionEntry(name);
        LocalStorageSection localStorageSection = this.findLocalStorageSection();
        DataDescriptionEntry localStorageSectionResult = localStorageSection == null ? null : localStorageSection.getDataDescriptionEntry(name);
        FileSection fileSection = this.findFileSection();
        if (fileSection == null) {
            fileSectionResult = null;
        } else {
            DataDescriptionEntry dataDescriptionEntryFound = null;
            for (FileDescriptionEntry fileDescriptionEntry : fileSection.getFileDescriptionEntries()) {
                DataDescriptionEntry dataDescriptionEntry = fileDescriptionEntry.getDataDescriptionEntry(name);
                if (dataDescriptionEntry == null) continue;
                dataDescriptionEntryFound = dataDescriptionEntry;
                break;
            }
            fileSectionResult = dataDescriptionEntryFound;
        }
        DataDescriptionEntry result = workingStorageSectionResult != null ? workingStorageSectionResult : (fileSectionResult != null ? fileSectionResult : (communicationSectionResult != null ? communicationSectionResult : (linkageSectionResult != null ? linkageSectionResult : (localStorageSectionResult != null ? localStorageSectionResult : null))));
        return result;
    }

    protected FileControlEntry findFileControlEntry(String name) {
        FileControlParagraph fileControlParagraph = this.findFileControlParagraph();
        FileControlEntry result = fileControlParagraph == null ? null : fileControlParagraph.getFileControlEntry(name);
        return result;
    }

    protected FileControlParagraph findFileControlParagraph() {
        InputOutputSection inputOutputSection = this.findInputOutputSection();
        FileControlParagraph result = inputOutputSection == null ? null : inputOutputSection.getFileControlParagraph();
        return result;
    }

    protected FileDescriptionEntry findFileDescriptionEntry(String name) {
        FileSection fileSection = this.findFileSection();
        FileDescriptionEntry result = fileSection == null ? null : fileSection.getFileDescriptionEntry(name);
        return result;
    }

    protected FileSection findFileSection() {
        DataDivision dataDivision = this.programUnit.getDataDivision();
        FileSection result = dataDivision == null ? null : dataDivision.getFileSection();
        return result;
    }

    protected Index findIndex(String name) {
        WorkingStorageSection workingStorageSection = this.findWorkingStorageSection();
        if (workingStorageSection != null) {
            for (DataDescriptionEntry dataDescriptionEntry : workingStorageSection.getDataDescriptionEntries()) {
                if (!DataDescriptionEntry.DataDescriptionEntryType.GROUP.equals((Object)dataDescriptionEntry.getDataDescriptionEntryType())) continue;
                DataDescriptionEntryGroup dataDescriptionEntryGroup = (DataDescriptionEntryGroup)dataDescriptionEntry;
                for (OccursClause occursClause : dataDescriptionEntryGroup.getOccursClauses()) {
                    Index index = occursClause.getIndex(name);
                    if (index == null) continue;
                    return index;
                }
            }
        }
        return null;
    }

    protected InputOutputSection findInputOutputSection() {
        EnvironmentDivision environmentDivision = this.programUnit.getEnvironmentDivision();
        InputOutputSection result = environmentDivision == null ? null : environmentDivision.getInputOutputSection();
        return result;
    }

    protected LinkageSection findLinkageSection() {
        DataDivision dataDivision = this.programUnit.getDataDivision();
        LinkageSection result = dataDivision == null ? null : dataDivision.getLinkageSection();
        return result;
    }

    protected LocalStorageSection findLocalStorageSection() {
        DataDivision dataDivision = this.programUnit.getDataDivision();
        LocalStorageSection result = dataDivision == null ? null : dataDivision.getLocalStorageSection();
        return result;
    }

    protected Paragraph findProcedure(String name) {
        ProcedureDivision procedureDivision = this.programUnit.getProcedureDivision();
        Paragraph result = procedureDivision == null ? null : procedureDivision.getParagraph(name);
        return result;
    }

    protected ReportDescription findReportDescription(String name) {
        ReportSection reportSection = this.findReportSection();
        ReportDescription result = reportSection == null ? null : reportSection.getReportDescription(name);
        return result;
    }

    protected ReportDescriptionEntry findReportDescriptionEntry(String name) {
        ReportDescription reportDescription = this.findReportDescription(name);
        ReportDescriptionEntry result = reportDescription == null ? null : reportDescription.getReportDescriptionEntry();
        return result;
    }

    protected ReportSection findReportSection() {
        DataDivision dataDivision = this.programUnit.getDataDivision();
        ReportSection result = dataDivision == null ? null : dataDivision.getReportSection();
        return result;
    }

    protected WorkingStorageSection findWorkingStorageSection() {
        DataDivision dataDivision = this.programUnit.getDataDivision();
        WorkingStorageSection result = dataDivision == null ? null : dataDivision.getWorkingStorageSection();
        return result;
    }

    protected ASGElement getASGElement(ParserRuleContext ctx) {
        ASGElement result = this.programUnit.getProgram().getASGElementRegistry().getASGElement((ParseTree)ctx);
        return result;
    }

    @Override
    public ProgramUnit getProgramUnit() {
        return this.programUnit;
    }

    protected void linkCommunicationDescriptionEntryCallWithCommunicationDescriptionEntry(CommunicationDescriptionEntryCall call, CommunicationDescriptionEntry communicationDescriptionEntry) {
        communicationDescriptionEntry.addCall(call);
    }

    protected void linkDataDescriptionEntryCallWithDataDescriptionEntry(DataDescriptionEntryCall call, DataDescriptionEntry dataDescriptionEntry) {
        dataDescriptionEntry.addCall(call);
    }

    protected void linkFileControlEntryCallWithFileControlEntry(FileControlEntryCall call, FileControlEntry fileControlEntry) {
        fileControlEntry.addCall(call);
    }

    protected void linkIndexCallWithIndex(IndexCall call, Index index) {
        index.addCall(call);
    }

    protected void linkProcedureCallWithParagraph(ProcedureCall call, Paragraph paragraph) {
        paragraph.addCall(call);
    }

    protected void linkReportCallWithReport(ReportCall reportCall, ReportDescription report) {
        report.addCall(reportCall);
    }

    protected void linkReportDescriptionEntryCallWithReportDescriptionEntry(ReportDescriptionEntryCall call, ReportDescriptionEntry reportDescriptionEntry) {
        reportDescriptionEntry.addCall(call);
    }

    protected void registerASGElement(ASGElement asgElement) {
        this.programUnit.getProgram().getASGElementRegistry().addASGElement(asgElement);
    }
}

