/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.procedure.evaluate.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.impl.CobolDivisionElementImpl;
import io.proleap.cobol.asg.metamodel.procedure.evaluate.AlsoCondition;
import io.proleap.cobol.asg.metamodel.procedure.evaluate.Condition;
import io.proleap.cobol.asg.metamodel.procedure.evaluate.When;
import io.proleap.cobol.asg.metamodel.procedure.evaluate.impl.AlsoConditionImpl;
import io.proleap.cobol.asg.metamodel.procedure.evaluate.impl.ConditionImpl;
import io.proleap.cobol.asg.metamodel.valuestmt.ValueStmt;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;

public class WhenImpl
extends CobolDivisionElementImpl
implements When {
    protected List<AlsoCondition> alsoConditions = new ArrayList<AlsoCondition>();
    protected Condition condition;
    protected final Cobol85Parser.EvaluateWhenContext ctx;

    public WhenImpl(ProgramUnit programUnit, Cobol85Parser.EvaluateWhenContext ctx) {
        super(programUnit, (ParserRuleContext)ctx);
        this.ctx = ctx;
    }

    @Override
    public AlsoCondition addAlsoCondition(Cobol85Parser.EvaluateAlsoConditionContext ctx) {
        AlsoCondition result = (AlsoCondition)this.getASGElement(ctx);
        if (result == null) {
            result = new AlsoConditionImpl(this.programUnit, ctx);
            result.addCondition(ctx.evaluateCondition());
            this.alsoConditions.add(result);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public Condition addCondition(Cobol85Parser.EvaluateConditionContext ctx) {
        Condition result = (Condition)this.getASGElement(ctx);
        if (result == null) {
            ValueStmt conditionValueStmt;
            Condition.ConditionType type;
            result = new ConditionImpl(this.programUnit, ctx);
            if (ctx.ANY() != null) {
                type = Condition.ConditionType.ANY;
                conditionValueStmt = null;
            } else if (ctx.condition() != null) {
                type = Condition.ConditionType.CONDITION;
                conditionValueStmt = this.createConditionValueStmt(ctx.condition());
            } else if (ctx.booleanLiteral() != null) {
                type = Condition.ConditionType.BOOLEAN;
                conditionValueStmt = this.createBooleanLiteralValueStmt(ctx.booleanLiteral());
            } else if (ctx.evaluateThrough() != null) {
                type = Condition.ConditionType.VALUE_THROUGH;
                conditionValueStmt = null;
            } else if (ctx.evaluateValue() != null) {
                type = Condition.ConditionType.VALUE;
                conditionValueStmt = null;
            } else {
                type = null;
                conditionValueStmt = null;
            }
            result.setConditionType(type);
            result.setConditionValueStmt(conditionValueStmt);
            if (ctx.NOT() != null) {
                result.setNot(true);
            }
            if (ctx.evaluateValue() != null) {
                result.addValue(ctx.evaluateValue());
            }
            if (ctx.evaluateThrough() != null) {
                result.addThrough(ctx.evaluateThrough());
            }
            this.condition = result;
            this.registerASGElement(result);
        }
        return result;
    }

    protected ValueStmt createValueStmt(Cobol85Parser.EvaluateValueContext ctx) {
        ValueStmt result = this.createValueStmt(ctx.identifier(), ctx.literal(), ctx.arithmeticExpression());
        return result;
    }

    @Override
    public List<AlsoCondition> getAlsoConditions() {
        return this.alsoConditions;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }
}

