/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.procedure.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.call.ProcedureCall;
import io.proleap.cobol.asg.metamodel.impl.ScopeImpl;
import io.proleap.cobol.asg.metamodel.procedure.Paragraph;
import io.proleap.cobol.asg.metamodel.procedure.ParagraphName;
import io.proleap.cobol.asg.metamodel.procedure.Section;
import io.proleap.cobol.asg.metamodel.procedure.impl.ParagraphImpl;
import io.proleap.cobol.asg.metamodel.procedure.impl.ParagraphNameImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;

public class SectionImpl
extends ScopeImpl
implements Section {
    protected final List<ProcedureCall> calls = new ArrayList<ProcedureCall>();
    protected final Cobol85Parser.ProcedureSectionContext ctx;
    protected final String name;
    protected List<Paragraph> paragraphs = new ArrayList<Paragraph>();
    protected Map<String, Paragraph> paragraphsSymbolTable = new HashMap<String, Paragraph>();

    public SectionImpl(String name, ProgramUnit programUnit, Cobol85Parser.ProcedureSectionContext ctx) {
        super(programUnit, (ParserRuleContext)ctx);
        this.name = name;
        this.ctx = ctx;
    }

    @Override
    public void addCall(ProcedureCall procedureCall) {
        this.calls.add(procedureCall);
    }

    @Override
    public Paragraph addParagraph(Cobol85Parser.ParagraphContext ctx) {
        Paragraph result = (Paragraph)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new ParagraphImpl(name, this.programUnit, ctx);
            this.paragraphs.add(result);
            this.paragraphsSymbolTable.put(name, result);
            ParagraphName paragraphName = this.addParagraphName(ctx.paragraphName());
            result.addParagraphName(paragraphName);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ParagraphName addParagraphName(Cobol85Parser.ParagraphNameContext ctx) {
        ParagraphName result = (ParagraphName)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new ParagraphNameImpl(name, this.programUnit, ctx);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public List<ProcedureCall> getCalls() {
        return this.calls;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Paragraph getParagraph(String name) {
        return this.paragraphsSymbolTable.get(name);
    }

    @Override
    public List<Paragraph> getParagraphs() {
        return this.paragraphs;
    }

    public String toString() {
        return "name=[" + this.name + "]";
    }
}

