/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.runner.impl;

import com.google.common.collect.Lists;
import io.proleap.cobol.Cobol85Lexer;
import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.CompilationUnit;
import io.proleap.cobol.asg.metamodel.Program;
import io.proleap.cobol.asg.metamodel.impl.ProgramImpl;
import io.proleap.cobol.asg.runner.CobolParserRunner;
import io.proleap.cobol.asg.visitor.impl.CobolCompilationUnitVisitorImpl;
import io.proleap.cobol.asg.visitor.impl.CobolDataDivisionVisitorImpl;
import io.proleap.cobol.asg.visitor.impl.CobolEnvironmentDivisionVisitorImpl;
import io.proleap.cobol.asg.visitor.impl.CobolIdentificationDivisionVisitorImpl;
import io.proleap.cobol.asg.visitor.impl.CobolProcedureDivisionVisitorImpl;
import io.proleap.cobol.asg.visitor.impl.CobolProcedureStatementVisitorImpl;
import io.proleap.cobol.asg.visitor.impl.CobolProgramUnitVisitorImpl;
import io.proleap.cobol.preprocessor.CobolPreprocessor;
import io.proleap.cobol.preprocessor.impl.CobolPreprocessorImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CobolParserRunnerImpl
implements CobolParserRunner {
    protected static final Logger LOG = LogManager.getLogger(CobolParserRunnerImpl.class);

    protected void analyze(Program program) {
        this.analyzeProgramUnits(program);
        this.analyzeIdentificationDivisions(program);
        this.analyzeEnvironmentDivisions(program);
        this.analyzeDataDivisions(program);
        this.analyzeProcedureDivisions(program);
        this.analyzeProcedureStatements(program);
    }

    protected void analyzeDataDivisions(Program program) {
        for (CompilationUnit compilationUnit : program.getCompilationUnits()) {
            CobolDataDivisionVisitorImpl visitor = new CobolDataDivisionVisitorImpl(program);
            LOG.info("Analyzing data divisions of compilation unit {}.", (Object)compilationUnit.getName());
            visitor.visit((ParseTree)compilationUnit.getCtx());
        }
    }

    protected void analyzeEnvironmentDivisions(Program program) {
        for (CompilationUnit compilationUnit : program.getCompilationUnits()) {
            CobolEnvironmentDivisionVisitorImpl visitor = new CobolEnvironmentDivisionVisitorImpl(program);
            LOG.info("Analyzing environment divisions of compilation unit {}.", (Object)compilationUnit.getName());
            visitor.visit((ParseTree)compilationUnit.getCtx());
        }
    }

    @Override
    public Program analyzeFile(File inputFile, CobolPreprocessor.CobolSourceFormatEnum format) throws IOException {
        File libDirectory = inputFile.getParentFile();
        List<File> copyFiles = this.getCopyFiles(libDirectory);
        return this.analyzeFile(inputFile, copyFiles, format, null);
    }

    @Override
    public Program analyzeFile(File inputFile, List<File> copyFiles, CobolPreprocessor.CobolSourceFormatEnum format, CobolPreprocessor.CobolDialect dialect) throws IOException {
        ProgramImpl program = new ProgramImpl();
        this.parseFile(inputFile, copyFiles, program, format, dialect);
        this.analyze(program);
        return program;
    }

    @Override
    public Program analyzeFiles(List<File> inputFiles, CobolPreprocessor.CobolSourceFormatEnum format) throws IOException {
        File libDirectory = inputFiles.isEmpty() ? null : inputFiles.get(0).getParentFile();
        List<File> copyFiles = this.getCopyFiles(libDirectory);
        return this.analyzeFiles(inputFiles, copyFiles, format, null);
    }

    @Override
    public Program analyzeFiles(List<File> inputFiles, List<File> copyFiles, CobolPreprocessor.CobolSourceFormatEnum format, CobolPreprocessor.CobolDialect dialect) throws IOException {
        ProgramImpl program = new ProgramImpl();
        for (File inputFile : inputFiles) {
            this.parseFile(inputFile, copyFiles, program, format, dialect);
        }
        this.analyze(program);
        return program;
    }

    protected void analyzeIdentificationDivisions(Program program) {
        for (CompilationUnit compilationUnit : program.getCompilationUnits()) {
            CobolIdentificationDivisionVisitorImpl visitor = new CobolIdentificationDivisionVisitorImpl(program);
            LOG.info("Analyzing identification divisions of compilation unit {}.", (Object)compilationUnit.getName());
            visitor.visit((ParseTree)compilationUnit.getCtx());
        }
    }

    protected void analyzeProcedureDivisions(Program program) {
        for (CompilationUnit compilationUnit : program.getCompilationUnits()) {
            CobolProcedureDivisionVisitorImpl visitor = new CobolProcedureDivisionVisitorImpl(program);
            LOG.info("Analyzing procedure divisions of compilation unit {}.", (Object)compilationUnit.getName());
            visitor.visit((ParseTree)compilationUnit.getCtx());
        }
    }

    protected void analyzeProcedureStatements(Program program) {
        for (CompilationUnit compilationUnit : program.getCompilationUnits()) {
            CobolProcedureStatementVisitorImpl visitor = new CobolProcedureStatementVisitorImpl(program);
            LOG.info("Analyzing statements of compilation unit {}.", (Object)compilationUnit.getName());
            visitor.visit((ParseTree)compilationUnit.getCtx());
        }
    }

    protected void analyzeProgramUnits(Program program) {
        for (CompilationUnit compilationUnit : program.getCompilationUnits()) {
            CobolProgramUnitVisitorImpl visitor = new CobolProgramUnitVisitorImpl(compilationUnit);
            LOG.info("Analyzing program units of compilation unit {}.", (Object)compilationUnit.getName());
            visitor.visit((ParseTree)compilationUnit.getCtx());
        }
    }

    protected String getCompilationUnitName(File inputFile) {
        return StringUtils.capitalize((String)FilenameUtils.removeExtension((String)inputFile.getName()));
    }

    protected List<File> getCopyFiles(File libDirectory) {
        return Lists.newArrayList((Object[])libDirectory.listFiles());
    }

    protected boolean isCobolFile(File inputFile) {
        String extension = FilenameUtils.getExtension((String)inputFile.getName()).toLowerCase();
        return "cbl".equals(extension);
    }

    protected void parseFile(File inputFile, List<File> copyFiles, Program program, CobolPreprocessor.CobolSourceFormatEnum format, CobolPreprocessor.CobolDialect dialect) throws IOException {
        if (!inputFile.isFile()) {
            LOG.warn("Could not find file {}", (Object)inputFile.getAbsolutePath());
        } else {
            String preProcessedInput = new CobolPreprocessorImpl().process(inputFile, copyFiles, format, dialect);
            LOG.info("Parsing file {}.", (Object)inputFile.getName());
            Cobol85Lexer lexer = new Cobol85Lexer((CharStream)CharStreams.fromString((String)preProcessedInput));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            Cobol85Parser parser = new Cobol85Parser((TokenStream)tokens);
            Cobol85Parser.StartRuleContext ctx = parser.startRule();
            String compilationUnitName = this.getCompilationUnitName(inputFile);
            List<String> lines = this.splitLines(preProcessedInput);
            CobolCompilationUnitVisitorImpl visitor = new CobolCompilationUnitVisitorImpl(compilationUnitName, lines, program);
            LOG.info("Collecting units in file {}.", (Object)inputFile.getName());
            visitor.visit((ParseTree)ctx);
        }
    }

    public List<String> splitLines(String preProcessedInput) {
        Scanner scanner = new Scanner(preProcessedInput);
        ArrayList<String> result = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            result.add(scanner.nextLine());
        }
        scanner.close();
        return result;
    }
}

