/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.util;

import io.proleap.cobol.asg.metamodel.type.CobolBaseType;
import io.proleap.cobol.asg.metamodel.type.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PictureUtils {
    public static Pattern PATTERN_9 = Pattern.compile("9");
    public static Pattern PATTERN_99 = Pattern.compile("[9]{2,}");
    public static Pattern PATTERN_9Length = Pattern.compile("9\\(([0-9]+)\\)");
    public static Pattern PATTERN_9V9 = Pattern.compile("[9]+V[9]+");
    public static Pattern PATTERN_S9 = Pattern.compile("S9");
    public static Pattern PATTERN_S9Length = Pattern.compile("S9\\(([0-9]+)\\)");
    public static Pattern PATTERN_X = Pattern.compile("X");
    public static Pattern PATTERN_XLength = Pattern.compile("X\\(([0-9]+)\\)");
    public static Pattern PATTERN_XX = Pattern.compile("[X]{2,}");

    public static Type determineType(String pictureString) {
        Matcher matcher9 = PATTERN_9.matcher(pictureString);
        Matcher matcher99 = PATTERN_99.matcher(pictureString);
        Matcher matcher9Length = PATTERN_9Length.matcher(pictureString);
        Matcher matcher9V9 = PATTERN_9V9.matcher(pictureString);
        Matcher matcherS9 = PATTERN_S9.matcher(pictureString);
        Matcher matcherS9Length = PATTERN_S9Length.matcher(pictureString);
        Matcher matcherX = PATTERN_X.matcher(pictureString);
        Matcher matcherXX = PATTERN_XX.matcher(pictureString);
        Matcher matcherXLength = PATTERN_XLength.matcher(pictureString);
        CobolBaseType result = matcher9.matches() ? CobolBaseType.INTEGER : (matcher99.matches() ? CobolBaseType.INTEGER : (matcher9Length.matches() ? CobolBaseType.INTEGER : (matcher9V9.matches() ? CobolBaseType.FLOAT : (matcherS9.matches() ? CobolBaseType.INTEGER : (matcherS9Length.matches() ? CobolBaseType.INTEGER : (matcherX.matches() ? CobolBaseType.STRING : (matcherXX.matches() ? CobolBaseType.STRING : (matcherXLength.matches() ? CobolBaseType.STRING : null))))))));
        return result;
    }
}

