/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.visitor.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.Program;
import io.proleap.cobol.asg.metamodel.data.DataDivision;
import io.proleap.cobol.asg.metamodel.data.communication.CommunicationSection;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntryContainer;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntryGroup;
import io.proleap.cobol.asg.metamodel.data.file.FileDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.file.FileSection;
import io.proleap.cobol.asg.metamodel.data.linkage.LinkageSection;
import io.proleap.cobol.asg.metamodel.data.localstorage.LocalStorageSection;
import io.proleap.cobol.asg.metamodel.data.screen.ScreenDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.screen.ScreenSection;
import io.proleap.cobol.asg.metamodel.data.workingstorage.WorkingStorageSection;
import io.proleap.cobol.asg.util.ANTLRUtils;
import io.proleap.cobol.asg.visitor.impl.AbstractCobolParserVisitorImpl;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;

public class CobolDataDivisionVisitorImpl
extends AbstractCobolParserVisitorImpl {
    public CobolDataDivisionVisitorImpl(Program program) {
        super(program);
    }

    protected DataDivision findDataDivision(ParseTree ctx) {
        return (DataDivision)ANTLRUtils.findParent(DataDivision.class, ctx, this.program.getASGElementRegistry());
    }

    protected void linkDataDescriptionEntries(DataDescriptionEntry predecessor, DataDescriptionEntry successor) {
        predecessor.setDataDescriptionEntrySuccessor(successor);
        successor.setDataDescriptionEntryPredecessor(predecessor);
    }

    protected void linkDataDescriptionEntries(DataDescriptionEntryContainer container) {
        List<DataDescriptionEntry> rootDataDescriptionEntries = container.getRootDataDescriptionEntries();
        this.linkDataDescriptionEntries(rootDataDescriptionEntries);
    }

    protected void linkDataDescriptionEntries(List<DataDescriptionEntry> dataDescriptionEntries) {
        DataDescriptionEntry predecessor = null;
        for (DataDescriptionEntry successor : dataDescriptionEntries) {
            if (predecessor != null) {
                this.linkDataDescriptionEntries(predecessor, successor);
            }
            if (DataDescriptionEntry.DataDescriptionEntryType.GROUP.equals((Object)successor.getDataDescriptionEntryType())) {
                DataDescriptionEntryGroup successorGroup = (DataDescriptionEntryGroup)successor;
                this.linkDataDescriptionEntries(successorGroup.getDataDescriptionEntries());
            }
            predecessor = successor;
        }
    }

    protected void linkScreenDescriptionEntries(List<ScreenDescriptionEntry> screenDescriptionEntries) {
        ScreenDescriptionEntry predecessor = null;
        for (ScreenDescriptionEntry successor : screenDescriptionEntries) {
            if (predecessor != null) {
                this.linkScreenDescriptionEntries(predecessor, successor);
            }
            this.linkScreenDescriptionEntries(successor.getScreenDescriptionEntries());
            predecessor = successor;
        }
    }

    protected void linkScreenDescriptionEntries(ScreenDescriptionEntry predecessor, ScreenDescriptionEntry successor) {
        predecessor.setSuccessor(successor);
        successor.setPredecessor(predecessor);
    }

    protected void linkScreenDescriptionEntries(ScreenSection screenSection) {
        List<ScreenDescriptionEntry> rootScreenDescriptionEntries = screenSection.getRootScreenDescriptionEntries();
        this.linkScreenDescriptionEntries(rootScreenDescriptionEntries);
    }

    @Override
    public Boolean visitCommunicationSection(Cobol85Parser.CommunicationSectionContext ctx) {
        DataDivision dataDivision = this.findDataDivision((ParseTree)ctx);
        CommunicationSection communicationSection = dataDivision.addCommunicationSection(ctx);
        Boolean result = (Boolean)this.visitChildren((RuleNode)ctx);
        this.linkDataDescriptionEntries(communicationSection);
        return result;
    }

    @Override
    public Boolean visitDataBaseSection(Cobol85Parser.DataBaseSectionContext ctx) {
        DataDivision dataDivision = this.findDataDivision((ParseTree)ctx);
        dataDivision.addDataBaseSection(ctx);
        return (Boolean)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Boolean visitFileSection(Cobol85Parser.FileSectionContext ctx) {
        DataDivision dataDivision = this.findDataDivision((ParseTree)ctx);
        FileSection fileSection = dataDivision.addFileSection(ctx);
        Boolean result = (Boolean)this.visitChildren((RuleNode)ctx);
        for (FileDescriptionEntry fileDescriptionEntry : fileSection.getFileDescriptionEntries()) {
            this.linkDataDescriptionEntries(fileDescriptionEntry);
        }
        return result;
    }

    @Override
    public Boolean visitLinkageSection(Cobol85Parser.LinkageSectionContext ctx) {
        DataDivision dataDivision = this.findDataDivision((ParseTree)ctx);
        LinkageSection linkageSection = dataDivision.addLinkageSection(ctx);
        Boolean result = (Boolean)this.visitChildren((RuleNode)ctx);
        this.linkDataDescriptionEntries(linkageSection);
        return result;
    }

    @Override
    public Boolean visitLocalStorageSection(Cobol85Parser.LocalStorageSectionContext ctx) {
        DataDivision dataDivision = this.findDataDivision((ParseTree)ctx);
        LocalStorageSection localStorageSection = dataDivision.addLocalStorageSection(ctx);
        Boolean result = (Boolean)this.visitChildren((RuleNode)ctx);
        this.linkDataDescriptionEntries(localStorageSection);
        return result;
    }

    @Override
    public Boolean visitProgramLibrarySection(Cobol85Parser.ProgramLibrarySectionContext ctx) {
        DataDivision dataDivision = this.findDataDivision((ParseTree)ctx);
        dataDivision.addProgramLibrarySection(ctx);
        return (Boolean)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Boolean visitReportSection(Cobol85Parser.ReportSectionContext ctx) {
        DataDivision dataDivision = this.findDataDivision((ParseTree)ctx);
        dataDivision.addReportSection(ctx);
        return (Boolean)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Boolean visitScreenSection(Cobol85Parser.ScreenSectionContext ctx) {
        DataDivision dataDivision = this.findDataDivision((ParseTree)ctx);
        ScreenSection screenSection = dataDivision.addScreenSection(ctx);
        Boolean result = (Boolean)this.visitChildren((RuleNode)ctx);
        this.linkScreenDescriptionEntries(screenSection);
        return result;
    }

    @Override
    public Boolean visitWorkingStorageSection(Cobol85Parser.WorkingStorageSectionContext ctx) {
        DataDivision dataDivision = this.findDataDivision((ParseTree)ctx);
        WorkingStorageSection workingStorageSection = dataDivision.addWorkingStorageSection(ctx);
        Boolean result = (Boolean)this.visitChildren((RuleNode)ctx);
        this.linkDataDescriptionEntries(workingStorageSection);
        return result;
    }
}

