/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public interface CobolPreprocessor {
    public static final String CHAR_ASTERISK = "*";
    public static final String CHAR_D = "D";
    public static final String CHAR_D_ = "d";
    public static final String CHAR_MINUS = "-";
    public static final String CHAR_SLASH = "/";
    public static final String COMMENT_ENTRY_TAG = "*>CE";
    public static final String COMMENT_TAG = "*>";
    public static final String END_EXEC_TAG = "^";
    public static final String EXEC_CICS_TAG = "*>EXECCICS";
    public static final String EXEC_SQL_TAG = "*>EXECSQL";
    public static final String EXEC_SQLIMS_TAG = "*>EXECSQLIMS";
    public static final String INDICATOR_FIELD = "([ABCdD\\t\\-/*# ])";
    public static final String NEWLINE = "\n";
    public static final String WS = " ";

    public String process(File var1, List<File> var2, CobolSourceFormatEnum var3) throws IOException;

    public String process(File var1, List<File> var2, CobolSourceFormatEnum var3, CobolDialect var4) throws IOException;

    public String process(String var1, List<File> var2, CobolSourceFormatEnum var3);

    public String process(String var1, List<File> var2, CobolSourceFormatEnum var3, CobolDialect var4);

    public static enum CobolSourceFormatEnum {
        FIXED("(.{6})(?:([ABCdD\\t\\-/*# ])(.{0,4})(.{0,61})(.*))?", true),
        TANDEM("()([ABCdD\\t\\-/*# ])(.{0,4})(.*)()", false),
        VARIABLE("(.{6})(?:([ABCdD\\t\\-/*# ])(.{0,4})(.*)())?", true);

        private final boolean commentEntryMultiLine;
        private final Pattern pattern;
        private final String regex;

        private CobolSourceFormatEnum(String regex, boolean commentEntryMultiLine) {
            this.regex = regex;
            this.pattern = Pattern.compile(regex);
            this.commentEntryMultiLine = commentEntryMultiLine;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String getRegex() {
            return this.regex;
        }

        public boolean isCommentEntryMultiLine() {
            return this.commentEntryMultiLine;
        }
    }

    public static enum CobolDialect {
        ANSI85,
        MF,
        OSVS;

    }
}

