/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.impl;

import io.proleap.cobol.preprocessor.CobolPreprocessor;
import io.proleap.cobol.preprocessor.sub.CobolLine;
import io.proleap.cobol.preprocessor.sub.document.impl.CobolDocumentParserImpl;
import io.proleap.cobol.preprocessor.sub.line.reader.impl.CobolLineReaderImpl;
import io.proleap.cobol.preprocessor.sub.line.rewriter.impl.CobolCommentEntriesMarkerImpl;
import io.proleap.cobol.preprocessor.sub.line.rewriter.impl.CobolLineIndicatorProcessorImpl;
import io.proleap.cobol.preprocessor.sub.line.writer.CobolLineWriter;
import io.proleap.cobol.preprocessor.sub.line.writer.impl.CobolLineWriterImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CobolPreprocessorImpl
implements CobolPreprocessor {
    private static final Logger LOG = LogManager.getLogger(CobolPreprocessorImpl.class);

    protected CobolCommentEntriesMarkerImpl createCommentEntriesMarker() {
        return new CobolCommentEntriesMarkerImpl();
    }

    protected CobolDocumentParserImpl createDocumentParser(List<File> copyFiles) {
        return new CobolDocumentParserImpl(copyFiles);
    }

    protected CobolLineIndicatorProcessorImpl createLineIndicatorProcessor() {
        return new CobolLineIndicatorProcessorImpl();
    }

    protected CobolLineReaderImpl createLineReader() {
        return new CobolLineReaderImpl();
    }

    protected CobolLineWriter createLineWriter() {
        return new CobolLineWriterImpl();
    }

    protected String parseDocument(List<CobolLine> lines, List<File> copyFiles, CobolPreprocessor.CobolSourceFormatEnum format, CobolPreprocessor.CobolDialect dialect) {
        String code = this.createLineWriter().serialize(lines);
        String result = this.createDocumentParser(copyFiles).processLines(code, format, dialect);
        return result;
    }

    @Override
    public String process(File cobolFile, List<File> copyFiles, CobolPreprocessor.CobolSourceFormatEnum format) throws IOException {
        return this.process(cobolFile, copyFiles, format, null);
    }

    @Override
    public String process(File cobolFile, List<File> copyFiles, CobolPreprocessor.CobolSourceFormatEnum format, CobolPreprocessor.CobolDialect dialect) throws IOException {
        LOG.info("Preprocessing file {}.", (Object)cobolFile.getName());
        FileInputStream inputStream = new FileInputStream(cobolFile);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedInputStreamReader = new BufferedReader(inputStreamReader);
        StringBuffer outputBuffer = new StringBuffer();
        String line = null;
        while ((line = bufferedInputStreamReader.readLine()) != null) {
            outputBuffer.append(line + "\n");
        }
        bufferedInputStreamReader.close();
        String result = this.process(outputBuffer.toString(), copyFiles, format, dialect);
        return result;
    }

    @Override
    public String process(String cobolSourceCode, List<File> copyFiles, CobolPreprocessor.CobolSourceFormatEnum format) {
        return this.process(cobolSourceCode, copyFiles, format, null);
    }

    @Override
    public String process(String cobolCode, List<File> copyFiles, CobolPreprocessor.CobolSourceFormatEnum format, CobolPreprocessor.CobolDialect dialect) {
        List<CobolLine> lines = this.readLines(cobolCode, format, dialect);
        List<CobolLine> rewrittenLines = this.rewriteLines(lines);
        String result = this.parseDocument(rewrittenLines, copyFiles, format, dialect);
        LOG.debug("Processed input:\n\n{}\n\n", (Object)result);
        return result;
    }

    protected List<CobolLine> readLines(String cobolCode, CobolPreprocessor.CobolSourceFormatEnum format, CobolPreprocessor.CobolDialect dialect) {
        List<CobolLine> lines = this.createLineReader().processLines(cobolCode, format, dialect);
        return lines;
    }

    protected List<CobolLine> rewriteLines(List<CobolLine> lines) {
        List<CobolLine> lineIndicatorProcessedLines = this.createLineIndicatorProcessor().processLines(lines);
        List<CobolLine> result = this.createCommentEntriesMarker().processLines(lineIndicatorProcessedLines);
        return result;
    }
}

