/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub;

import com.google.common.base.Strings;
import io.proleap.cobol.preprocessor.CobolPreprocessor;
import io.proleap.cobol.preprocessor.sub.CobolLineTypeEnum;

public class CobolLine {
    public String comment;
    public String contentAreaA;
    public String contentAreaB;
    public CobolPreprocessor.CobolDialect dialect;
    public CobolPreprocessor.CobolSourceFormatEnum format;
    public String indicatorArea;
    public int number;
    public String sequenceArea;
    public CobolLineTypeEnum type;

    public static String blankSequenceArea(CobolPreprocessor.CobolSourceFormatEnum format) {
        return CobolPreprocessor.CobolSourceFormatEnum.TANDEM.equals((Object)format) ? "" : Strings.repeat((String)" ", (int)6);
    }

    private static String contentAreaA(String contentArea) {
        return contentArea.length() > 4 ? contentArea.substring(0, 4) : contentArea;
    }

    private static String contentAreaB(String contentArea) {
        return contentArea.length() > 4 ? contentArea.substring(4) : "";
    }

    public static CobolLine with(CobolLine line, String indicatorArea, String contentArea) {
        return new CobolLine(line.sequenceArea, indicatorArea, CobolLine.contentAreaA(contentArea), CobolLine.contentAreaB(contentArea), line.comment, line.format, line.dialect, line.number, line.type);
    }

    public static CobolLine withContentArea(CobolLine line, String contentArea) {
        return new CobolLine(line.sequenceArea, line.indicatorArea, CobolLine.contentAreaA(contentArea), CobolLine.contentAreaB(contentArea), line.comment, line.format, line.dialect, line.number, line.type);
    }

    public CobolLine(String sequenceArea, String indicatorArea, String contentAreaA, String contentAreaB, String comment, CobolPreprocessor.CobolSourceFormatEnum format, CobolPreprocessor.CobolDialect dialect, int number, CobolLineTypeEnum type) {
        this.sequenceArea = sequenceArea;
        this.indicatorArea = indicatorArea;
        this.contentAreaA = contentAreaA;
        this.contentAreaB = contentAreaB;
        this.comment = comment;
        this.format = format;
        this.dialect = dialect;
        this.number = number;
        this.type = type;
    }

    public String blankSequenceArea() {
        return CobolLine.blankSequenceArea(this.format);
    }

    public String getContentArea() {
        return this.contentAreaA + this.contentAreaB;
    }

    public String serialize() {
        return this.sequenceArea + this.indicatorArea + this.contentAreaA + this.contentAreaB + this.comment;
    }

    public String toString() {
        return this.serialize();
    }
}

