/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub.document.impl;

import io.proleap.cobol.Cobol85PreprocessorLexer;
import io.proleap.cobol.Cobol85PreprocessorParser;
import io.proleap.cobol.preprocessor.CobolPreprocessor;
import io.proleap.cobol.preprocessor.sub.document.CobolDocumentParser;
import io.proleap.cobol.preprocessor.sub.document.impl.CobolDocumentParserListenerImpl;
import io.proleap.cobol.preprocessor.sub.document.impl.ThrowingErrorListener;
import java.io.File;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class CobolDocumentParserImpl
implements CobolDocumentParser {
    protected final List<File> copyFiles;
    protected final String[] triggers = new String[]{"copy", "exec sql", "exec sqlims", "exec cics", "replace"};

    public CobolDocumentParserImpl(List<File> copyFiles) {
        this.copyFiles = copyFiles;
    }

    protected boolean containsTrigger(String code, String[] triggers) {
        String codeLowerCase = code.toLowerCase();
        boolean result = false;
        for (String trigger : triggers) {
            boolean containsTrigger = codeLowerCase.contains(trigger);
            if (!containsTrigger) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public String processLines(String code, CobolPreprocessor.CobolSourceFormatEnum format, CobolPreprocessor.CobolDialect dialect) {
        boolean requiresProcessorExecution = this.containsTrigger(code, this.triggers);
        String result = requiresProcessorExecution ? this.processWithParser(code, this.copyFiles, format, dialect) : code;
        return result;
    }

    protected String processWithParser(String code, List<File> copyFiles, CobolPreprocessor.CobolSourceFormatEnum format, CobolPreprocessor.CobolDialect dialect) {
        Cobol85PreprocessorLexer lexer = new Cobol85PreprocessorLexer((CharStream)CharStreams.fromString((String)code));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Cobol85PreprocessorParser parser = new Cobol85PreprocessorParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new ThrowingErrorListener());
        Cobol85PreprocessorParser.StartRuleContext startRule = parser.startRule();
        CobolDocumentParserListenerImpl listener = new CobolDocumentParserListenerImpl(copyFiles, format, dialect, (BufferedTokenStream)tokens);
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, (ParseTree)startRule);
        String result = listener.context().read();
        return result;
    }
}

