/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub.document.impl;

import io.proleap.cobol.Cobol85PreprocessorBaseListener;
import io.proleap.cobol.Cobol85PreprocessorParser;
import io.proleap.cobol.preprocessor.CobolPreprocessor;
import io.proleap.cobol.preprocessor.impl.CobolPreprocessorImpl;
import io.proleap.cobol.preprocessor.sub.CobolLine;
import io.proleap.cobol.preprocessor.sub.document.impl.CobolDocumentContext;
import io.proleap.cobol.preprocessor.sub.util.StringUtils;
import io.proleap.cobol.preprocessor.sub.util.TokenUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Scanner;
import java.util.Stack;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CobolDocumentParserListenerImpl
extends Cobol85PreprocessorBaseListener {
    private static final Logger LOG = LogManager.getLogger(CobolDocumentParserListenerImpl.class);
    private final Stack<CobolDocumentContext> contexts = new Stack();
    private final List<File> copyFiles;
    private final CobolPreprocessor.CobolDialect dialect;
    private final CobolPreprocessor.CobolSourceFormatEnum format;
    private final BufferedTokenStream tokens;

    public CobolDocumentParserListenerImpl(List<File> copyFiles, CobolPreprocessor.CobolSourceFormatEnum format, CobolPreprocessor.CobolDialect dialect, BufferedTokenStream tokens) {
        this.copyFiles = copyFiles;
        this.dialect = dialect;
        this.tokens = tokens;
        this.format = format;
        this.contexts.push(new CobolDocumentContext());
    }

    protected String buildLines(String text, String linePrefix) {
        StringBuffer sb = new StringBuffer(text.length());
        Scanner scanner = new Scanner(text);
        boolean firstLine = true;
        while (scanner.hasNextLine()) {
            if (!firstLine) {
                sb.append("\n");
            }
            String line = scanner.nextLine();
            String trimmedLine = line.trim();
            String prefixedLine = linePrefix + " " + trimmedLine;
            String suffixedLine = prefixedLine.replaceAll("(?i)(end-exec)", "$1 ^");
            sb.append(suffixedLine);
            firstLine = false;
        }
        scanner.close();
        return sb.toString();
    }

    public CobolDocumentContext context() {
        return this.contexts.peek();
    }

    @Override
    public void enterControlSpacingStatement(Cobol85PreprocessorParser.ControlSpacingStatementContext ctx) {
        this.push();
    }

    @Override
    public void enterCopyStatement(Cobol85PreprocessorParser.CopyStatementContext ctx) {
        this.push();
    }

    @Override
    public void enterExecCicsStatement(Cobol85PreprocessorParser.ExecCicsStatementContext ctx) {
        this.push();
    }

    @Override
    public void enterExecSqlImsStatement(Cobol85PreprocessorParser.ExecSqlImsStatementContext ctx) {
        this.push();
    }

    @Override
    public void enterExecSqlStatement(Cobol85PreprocessorParser.ExecSqlStatementContext ctx) {
        this.push();
    }

    @Override
    public void enterReplaceArea(Cobol85PreprocessorParser.ReplaceAreaContext ctx) {
        this.push();
    }

    @Override
    public void enterReplaceByStatement(Cobol85PreprocessorParser.ReplaceByStatementContext ctx) {
        this.push();
    }

    @Override
    public void enterReplaceOffStatement(Cobol85PreprocessorParser.ReplaceOffStatementContext ctx) {
        this.push();
    }

    @Override
    public void exitControlSpacingStatement(Cobol85PreprocessorParser.ControlSpacingStatementContext ctx) {
        this.pop();
    }

    @Override
    public void exitCopyStatement(Cobol85PreprocessorParser.CopyStatementContext ctx) {
        this.pop();
        this.push();
        Cobol85PreprocessorParser.ReplacingPhraseContext replacingPhrase = ctx.replacingPhrase();
        if (replacingPhrase != null) {
            this.context().storeReplaceablesAndReplacements(replacingPhrase.replaceClause());
        }
        Cobol85PreprocessorParser.CopySourceContext copySource = ctx.copySource();
        if (this.copyFiles == null || this.copyFiles.isEmpty()) {
            LOG.warn("Could not identify copy file {} due to missing copy files.", (Object)copySource.getText());
        } else {
            String fileContent = this.getCopyFileContent(copySource, this.copyFiles, this.dialect, this.format);
            if (fileContent != null) {
                this.context().write(fileContent + "\n");
                this.context().replaceReplaceablesByReplacements(this.tokens);
            }
        }
        String content = this.context().read();
        this.pop();
        this.context().write(content);
    }

    @Override
    public void exitExecCicsStatement(Cobol85PreprocessorParser.ExecCicsStatementContext ctx) {
        this.pop();
        this.push();
        String text = TokenUtils.getTextIncludingHiddenTokens((ParseTree)ctx, this.tokens);
        String linePrefix = CobolLine.blankSequenceArea(this.format) + "*>EXECCICS";
        String lines = this.buildLines(text, linePrefix);
        this.context().write(lines);
        String content = this.context().read();
        this.pop();
        this.context().write(content);
    }

    @Override
    public void exitExecSqlImsStatement(Cobol85PreprocessorParser.ExecSqlImsStatementContext ctx) {
        this.pop();
        this.push();
        String text = TokenUtils.getTextIncludingHiddenTokens((ParseTree)ctx, this.tokens);
        String linePrefix = CobolLine.blankSequenceArea(this.format) + "*>EXECSQLIMS";
        String lines = this.buildLines(text, linePrefix);
        this.context().write(lines);
        String content = this.context().read();
        this.pop();
        this.context().write(content);
    }

    @Override
    public void exitExecSqlStatement(Cobol85PreprocessorParser.ExecSqlStatementContext ctx) {
        this.pop();
        this.push();
        String text = TokenUtils.getTextIncludingHiddenTokens((ParseTree)ctx, this.tokens);
        String linePrefix = CobolLine.blankSequenceArea(this.format) + "*>EXECSQL";
        String lines = this.buildLines(text, linePrefix);
        this.context().write(lines);
        String content = this.context().read();
        this.pop();
        this.context().write(content);
    }

    @Override
    public void exitReplaceArea(Cobol85PreprocessorParser.ReplaceAreaContext ctx) {
        List<Cobol85PreprocessorParser.ReplaceClauseContext> replaceClauses = ctx.replaceByStatement().replaceClause();
        this.context().storeReplaceablesAndReplacements(replaceClauses);
        this.context().replaceReplaceablesByReplacements(this.tokens);
        String content = this.context().read();
        this.pop();
        this.context().write(content);
    }

    @Override
    public void exitReplaceByStatement(Cobol85PreprocessorParser.ReplaceByStatementContext ctx) {
        this.pop();
    }

    @Override
    public void exitReplaceOffStatement(Cobol85PreprocessorParser.ReplaceOffStatementContext ctx) {
        this.pop();
    }

    protected String getCopyFileContent(Cobol85PreprocessorParser.CopySourceContext copySource, List<File> copyFiles, CobolPreprocessor.CobolDialect dialect, CobolPreprocessor.CobolSourceFormatEnum format) {
        String result;
        File copyFile = this.identifyCopyFile(copySource, copyFiles);
        if (copyFile == null) {
            LOG.warn("Copy file {} not found in copy files {}.", (Object)copySource.getText(), copyFiles);
            result = null;
        } else {
            try {
                result = new CobolPreprocessorImpl().process(copyFile, copyFiles, format, dialect);
            }
            catch (IOException e) {
                result = null;
                LOG.warn(e.getMessage());
            }
        }
        return result;
    }

    protected File identifyCopyFile(Cobol85PreprocessorParser.CopySourceContext copySource, List<File> copyFiles) {
        File result;
        block2: {
            String copyFileIdentifier;
            block3: {
                result = null;
                copyFileIdentifier = copySource.getText();
                if (copySource.cobolWord() == null) break block3;
                for (File file : copyFiles) {
                    String baseName = FilenameUtils.getBaseName((String)file.getName());
                    boolean matchingBaseName = copyFileIdentifier.toLowerCase().equals(baseName.toLowerCase());
                    if (!matchingBaseName) continue;
                    result = file;
                }
                break block2;
            }
            if (copySource.literal() == null) break block2;
            String copyFileIdentifierCleaned = StringUtils.trimQuotes(copyFileIdentifier);
            String copyFileIdentifierPathString = this.normalizeCopyFilePath(Paths.get(copyFileIdentifierCleaned, new String[0]));
            for (File file : copyFiles) {
                String filePathString = this.normalizeCopyFilePath(file.toPath());
                boolean matching = filePathString.endsWith(copyFileIdentifierPathString);
                if (!matching) continue;
                result = file;
                break;
            }
        }
        return result;
    }

    protected String normalizeCopyFilePath(Path copFilePath) {
        Path normalizedPath = copFilePath.normalize();
        String result = normalizedPath.toString().toLowerCase();
        return result;
    }

    protected CobolDocumentContext pop() {
        return this.contexts.pop();
    }

    protected CobolDocumentContext push() {
        return this.contexts.push(new CobolDocumentContext());
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        int tokPos = node.getSourceInterval().a;
        this.context().write(TokenUtils.getHiddenTokensToLeft(tokPos, this.tokens));
        if (!TokenUtils.isEOF(node)) {
            String text = node.getText();
            this.context().write(text);
        }
    }
}

