/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub.document.impl;

import io.proleap.cobol.Cobol85PreprocessorParser;
import io.proleap.cobol.preprocessor.sub.util.TokenUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.codehaus.plexus.util.StringUtils;

public class CobolReplacementMapping
implements Comparable<CobolReplacementMapping> {
    public Cobol85PreprocessorParser.ReplaceableContext replaceable;
    public Cobol85PreprocessorParser.ReplacementContext replacement;

    @Override
    public int compareTo(CobolReplacementMapping o) {
        return o.replaceable.getText().length() - this.replaceable.getText().length();
    }

    private String extractPseudoText(Cobol85PreprocessorParser.PseudoTextContext pseudoTextCtx, BufferedTokenStream tokens) {
        String pseudoText = TokenUtils.getTextIncludingHiddenTokens((ParseTree)pseudoTextCtx, tokens).trim();
        String content = pseudoText.replaceAll("^==", "").replaceAll("==$", "").trim();
        return content;
    }

    private String getRegexFromReplaceable(String replaceable) {
        String result;
        if (replaceable == null) {
            result = null;
        } else {
            String[] parts = StringUtils.split((String)replaceable);
            Object[] regexParts = new String[parts.length];
            String regexSeparator = "[\\r\\n\\s]+";
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                regexParts[i] = Pattern.quote(part);
            }
            result = StringUtils.join((Object[])regexParts, (String)"[\\r\\n\\s]+");
        }
        return result;
    }

    private String getText(Cobol85PreprocessorParser.ReplaceableContext ctx, BufferedTokenStream tokens) {
        String result = ctx.pseudoText() != null ? this.extractPseudoText(ctx.pseudoText(), tokens) : (ctx.charDataLine() != null ? TokenUtils.getTextIncludingHiddenTokens((ParseTree)ctx, tokens) : (ctx.cobolWord() != null ? ctx.getText() : (ctx.literal() != null ? ctx.literal().getText() : null)));
        return result;
    }

    private String getText(Cobol85PreprocessorParser.ReplacementContext ctx, BufferedTokenStream tokens) {
        String result = ctx.pseudoText() != null ? this.extractPseudoText(ctx.pseudoText(), tokens) : (ctx.charDataLine() != null ? TokenUtils.getTextIncludingHiddenTokens((ParseTree)ctx, tokens) : (ctx.cobolWord() != null ? ctx.getText() : (ctx.literal() != null ? ctx.literal().getText() : null)));
        return result;
    }

    protected String replace(String string, BufferedTokenStream tokens) {
        String result;
        String replaceableString = this.getText(this.replaceable, tokens);
        String replacementString = this.getText(this.replacement, tokens);
        if (replaceableString != null && replacementString != null) {
            String replaceableRegex = this.getRegexFromReplaceable(replaceableString);
            String quotedReplacementRegex = Matcher.quoteReplacement(replacementString);
            result = Pattern.compile(replaceableRegex).matcher(string).replaceAll(quotedReplacementRegex);
        } else {
            result = string;
        }
        return result;
    }

    public String toString() {
        return this.replaceable.getText() + " -> " + this.replacement.getText();
    }
}

