/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub.line.reader.impl;

import io.proleap.cobol.preprocessor.CobolPreprocessor;
import io.proleap.cobol.preprocessor.sub.CobolLine;
import io.proleap.cobol.preprocessor.sub.CobolLineTypeEnum;
import io.proleap.cobol.preprocessor.sub.line.reader.CobolLineReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.util.Strings;

public class CobolLineReaderImpl
implements CobolLineReader {
    protected CobolLineTypeEnum determineType(String indicatorArea) {
        CobolLineTypeEnum result;
        switch (indicatorArea) {
            case "D": 
            case "d": {
                result = CobolLineTypeEnum.DEBUG;
                break;
            }
            case "-": {
                result = CobolLineTypeEnum.CONTINUATION;
                break;
            }
            case "*": 
            case "/": {
                result = CobolLineTypeEnum.COMMENT;
                break;
            }
            default: {
                result = CobolLineTypeEnum.NORMAL;
            }
        }
        return result;
    }

    @Override
    public CobolLine parseLine(String line, int lineNumber, CobolPreprocessor.CobolSourceFormatEnum format, CobolPreprocessor.CobolDialect dialect) {
        CobolLine result;
        Pattern pattern = format.getPattern();
        Matcher matcher = pattern.matcher(line);
        if (Strings.isBlank((String)line)) {
            result = new CobolLine(CobolLine.blankSequenceArea(format), " ", "", "", "", format, dialect, lineNumber, CobolLineTypeEnum.BLANK);
        } else {
            if (!matcher.matches()) {
                throw new RuntimeException("Is " + (Object)((Object)format) + " the correct line format? Could not parse line " + (lineNumber + 1) + ": " + line);
            }
            String sequenceAreaGroup = matcher.group(1);
            String indicatorAreaGroup = matcher.group(2);
            String contentAreaAGroup = matcher.group(3);
            String contentAreaBGroup = matcher.group(4);
            String commentAreaGroup = matcher.group(5);
            String sequenceArea = sequenceAreaGroup != null ? sequenceAreaGroup : "";
            String indicatorArea = indicatorAreaGroup != null ? indicatorAreaGroup : " ";
            String contentAreaA = contentAreaAGroup != null ? contentAreaAGroup : "";
            String contentAreaB = contentAreaBGroup != null ? contentAreaBGroup : "";
            String commentArea = commentAreaGroup != null ? commentAreaGroup : "";
            CobolLineTypeEnum type = this.determineType(indicatorArea);
            result = new CobolLine(sequenceArea, indicatorArea, contentAreaA, contentAreaB, commentArea, format, dialect, lineNumber, type);
        }
        return result;
    }

    @Override
    public List<CobolLine> processLines(String lines, CobolPreprocessor.CobolSourceFormatEnum format, CobolPreprocessor.CobolDialect dialect) {
        Scanner scanner = new Scanner(lines);
        ArrayList<CobolLine> result = new ArrayList<CobolLine>();
        String currentLine = null;
        int lineNumber = 0;
        while (scanner.hasNextLine()) {
            currentLine = scanner.nextLine();
            CobolLine parsedLine = this.parseLine(currentLine, lineNumber, format, dialect);
            result.add(parsedLine);
            ++lineNumber;
        }
        scanner.close();
        return result;
    }
}

