/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub.line.rewriter.impl;

import io.proleap.cobol.preprocessor.sub.CobolLine;
import io.proleap.cobol.preprocessor.sub.line.rewriter.CobolLineIndicatorProcessor;
import java.util.ArrayList;
import java.util.List;

public class CobolLineIndicatorProcessorImpl
implements CobolLineIndicatorProcessor {
    protected String handleTrailingComma(String contentArea) {
        char lastCharAtTrimmedLineArea;
        String result = contentArea.isEmpty() ? contentArea : ((lastCharAtTrimmedLineArea = contentArea.charAt(contentArea.length() - 1)) == ',' || lastCharAtTrimmedLineArea == ';' ? contentArea + " " : contentArea);
        return result;
    }

    @Override
    public CobolLine processLine(CobolLine line) {
        CobolLine result;
        String trimmedTrailWsContentArea = line.getContentArea().replaceAll("\\s+$", "");
        String handledContentArea = this.handleTrailingComma(trimmedTrailWsContentArea);
        block0 : switch (line.type) {
            case DEBUG: {
                result = CobolLine.with(line, " ", handledContentArea);
                break;
            }
            case CONTINUATION: {
                String trimmedContentArea = handledContentArea.trim();
                char firstCharOfContentArea = trimmedContentArea.charAt(0);
                switch (firstCharOfContentArea) {
                    case '\"': 
                    case '\'': {
                        result = CobolLine.with(line, " ", trimmedContentArea.substring(1));
                        break block0;
                    }
                }
                result = CobolLine.with(line, " ", trimmedContentArea);
                break;
            }
            case COMMENT: {
                result = CobolLine.with(line, "*> ", handledContentArea);
                break;
            }
            default: {
                result = CobolLine.with(line, " ", handledContentArea);
            }
        }
        return result;
    }

    @Override
    public List<CobolLine> processLines(List<CobolLine> lines) {
        ArrayList<CobolLine> result = new ArrayList<CobolLine>();
        for (CobolLine line : lines) {
            CobolLine processedLine = this.processLine(line);
            result.add(processedLine);
        }
        return result;
    }
}

