/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.data.datadescription.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.IntegerLiteral;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.call.Call;
import io.proleap.cobol.asg.metamodel.data.datadescription.AlignedClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.BlankWhenZeroClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.CommonOwnLocalClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntriesSymbolTableEntry;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntryContainer;
import io.proleap.cobol.asg.metamodel.data.datadescription.DataDescriptionEntryGroup;
import io.proleap.cobol.asg.metamodel.data.datadescription.ExternalClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.GlobalClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.IntegerStringClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.JustifiedClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.OccursClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.PictureClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.ReceivedByClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.RecordAreaClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.RedefinesClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.SignClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.SynchronizedClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.ThreadLocalClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.TypeClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.TypeDefClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.UsageClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.UsingClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.ValueClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.ValueInterval;
import io.proleap.cobol.asg.metamodel.data.datadescription.WithLowerBoundsClause;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.AlignedClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.BlankWhenZeroClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.CommonOwnLocalClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.DataDescriptionEntriesSymbolTableEntryImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.DataDescriptionEntryImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.ExternalClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.GlobalClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.IntegerStringClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.JustifiedClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.OccursClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.PictureClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.ReceivedByClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.RecordAreaClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.RedefinesClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.SignClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.SynchronizedClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.ThreadLocalClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.TypeClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.TypeDefClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.UsageClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.UsingClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.ValueClauseImpl;
import io.proleap.cobol.asg.metamodel.data.datadescription.impl.WithLowerBoundsClauseImpl;
import io.proleap.cobol.asg.metamodel.type.Type;
import io.proleap.cobol.asg.metamodel.valuestmt.LiteralValueStmt;
import io.proleap.cobol.asg.metamodel.valuestmt.ValueStmt;
import io.proleap.cobol.asg.util.PictureUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataDescriptionEntryGroupImpl
extends DataDescriptionEntryImpl
implements DataDescriptionEntryGroup {
    private static final Logger LOG = LogManager.getLogger(DataDescriptionEntryGroupImpl.class);
    protected AlignedClause alignedClause;
    protected BlankWhenZeroClause blankWhenZeroClause;
    protected CommonOwnLocalClause commonOwnLocalClause;
    protected final Cobol85Parser.DataDescriptionEntryFormat1Context ctx;
    protected List<DataDescriptionEntry> dataDescriptionEntries = new ArrayList<DataDescriptionEntry>();
    protected Map<String, DataDescriptionEntriesSymbolTableEntry> dataDescriptionEntriesSymbolTable = new HashMap<String, DataDescriptionEntriesSymbolTableEntry>();
    protected ExternalClause externalClause;
    protected Boolean filler;
    protected Integer fillerNumber;
    protected GlobalClause globalClause;
    protected IntegerStringClause integerStringClause;
    protected JustifiedClause justifiedClause;
    protected List<OccursClause> occursClauses = new ArrayList<OccursClause>();
    protected PictureClause pictureClause;
    protected ReceivedByClause receivedByClause;
    protected RecordAreaClause recordAreaClause;
    protected RedefinesClause redefinesClause;
    protected SignClause signClause;
    protected SynchronizedClause synchronizedClause;
    protected ThreadLocalClause threadLocalClause;
    protected TypeClause typeClause;
    protected TypeDefClause typeDefClause;
    protected UsageClause usageClause;
    protected UsingClause usingClause;
    protected ValueClause valueClause;
    protected WithLowerBoundsClause withLowerBoundsClause;

    public DataDescriptionEntryGroupImpl(String name, DataDescriptionEntryContainer dataDescriptionEntryContainer, ProgramUnit programUnit, Cobol85Parser.DataDescriptionEntryFormat1Context ctx) {
        super(name, dataDescriptionEntryContainer, programUnit, ctx);
        this.ctx = ctx;
    }

    @Override
    public AlignedClause addAlignedClause(Cobol85Parser.DataAlignedClauseContext ctx) {
        AlignedClause result = (AlignedClause)this.getASGElement(ctx);
        if (result == null) {
            result = new AlignedClauseImpl(this.programUnit, ctx);
            result.setAligned(true);
            this.alignedClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public BlankWhenZeroClause addBlankWhenZeroClause(Cobol85Parser.DataBlankWhenZeroClauseContext ctx) {
        BlankWhenZeroClause result = (BlankWhenZeroClause)this.getASGElement(ctx);
        if (result == null) {
            result = new BlankWhenZeroClauseImpl(this.programUnit, ctx);
            result.setBlankWhenZero(true);
            this.blankWhenZeroClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public CommonOwnLocalClause addCommonOwnLocalClause(Cobol85Parser.DataCommonOwnLocalClauseContext ctx) {
        CommonOwnLocalClause result = (CommonOwnLocalClause)this.getASGElement(ctx);
        if (result == null) {
            result = new CommonOwnLocalClauseImpl(this.programUnit, ctx);
            CommonOwnLocalClause.Invariance invariance = ctx.COMMON() != null ? CommonOwnLocalClause.Invariance.COMMON : (ctx.OWN() != null ? CommonOwnLocalClause.Invariance.OWN : (ctx.LOCAL() != null ? CommonOwnLocalClause.Invariance.LOCAL : null));
            result.setInvariance(invariance);
            this.commonOwnLocalClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public void addDataDescriptionEntry(DataDescriptionEntry dataDescriptionEntry) {
        String name = dataDescriptionEntry.getName();
        this.dataDescriptionEntries.add(dataDescriptionEntry);
        this.assureDataDescriptionEntriesSymbolTableEntry(name).addDataDescriptionEntry(dataDescriptionEntry);
    }

    @Override
    public ExternalClause addExternalClause(Cobol85Parser.DataExternalClauseContext ctx) {
        ExternalClause result = (ExternalClause)this.getASGElement(ctx);
        if (result == null) {
            result = new ExternalClauseImpl(this.programUnit, ctx);
            result.setExternal(true);
            if (ctx.literal() != null) {
                LiteralValueStmt byLiteralValueStmt = this.createLiteralValueStmt(ctx.literal());
                result.setByLiteralValueStmt(byLiteralValueStmt);
            }
            this.externalClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public GlobalClause addGlobalClause(Cobol85Parser.DataGlobalClauseContext ctx) {
        GlobalClause result = (GlobalClause)this.getASGElement(ctx);
        if (result == null) {
            result = new GlobalClauseImpl(this.programUnit, ctx);
            result.setGlobal(true);
            this.globalClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public IntegerStringClause addIntegerStringClause(Cobol85Parser.DataIntegerStringClauseContext ctx) {
        IntegerStringClause result = (IntegerStringClause)this.getASGElement(ctx);
        if (result == null) {
            result = new IntegerStringClauseImpl(this.programUnit, ctx);
            IntegerStringClause.PrimitiveType primitiveType = ctx.INTEGER() != null ? IntegerStringClause.PrimitiveType.INTEGER : (ctx.STRING() != null ? IntegerStringClause.PrimitiveType.STRING : null);
            result.setPrimitiveType(primitiveType);
            this.integerStringClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public JustifiedClause addJustifiedClause(Cobol85Parser.DataJustifiedClauseContext ctx) {
        JustifiedClause result = (JustifiedClause)this.getASGElement(ctx);
        if (result == null) {
            result = new JustifiedClauseImpl(this.programUnit, ctx);
            JustifiedClause.Justified justified = ctx.RIGHT() != null ? JustifiedClause.Justified.JUSTIFIED_RIGHT : JustifiedClause.Justified.JUSTIFIED;
            result.setJustified(justified);
            this.justifiedClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public OccursClause addOccursClause(Cobol85Parser.DataOccursClauseContext ctx) {
        OccursClause result = (OccursClause)this.getASGElement(ctx);
        if (result == null) {
            Cobol85Parser.DataOccursToContext dataOccursTo;
            result = new OccursClauseImpl(this.programUnit, ctx);
            if (ctx.integerLiteral() != null) {
                IntegerLiteral from = this.createIntegerLiteral(ctx.integerLiteral());
                result.setFrom(from);
            }
            if (ctx.dataOccursTo() != null && (dataOccursTo = ctx.dataOccursTo()).integerLiteral() != null) {
                IntegerLiteral to = this.createIntegerLiteral(dataOccursTo.integerLiteral());
                result.setTo(to);
            }
            if (ctx.qualifiedDataName() != null) {
                Call dependingOnCall = this.createCall(ctx.qualifiedDataName());
                result.setDependingOnCall(dependingOnCall);
            }
            for (Cobol85Parser.DataOccursSortContext dataOccursSortContext : ctx.dataOccursSort()) {
                result.addOccursSort(dataOccursSortContext);
            }
            for (Cobol85Parser.IndexNameContext indexNameContext : ctx.indexName()) {
                result.addIndex(indexNameContext);
            }
            this.occursClauses.add(result);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public PictureClause addPictureClause(Cobol85Parser.DataPictureClauseContext ctx) {
        PictureClause result = (PictureClause)this.getASGElement(ctx);
        if (result == null) {
            result = new PictureClauseImpl(this.programUnit, ctx);
            Cobol85Parser.PictureStringContext pictureString = ctx.pictureString();
            result.setPictureString(pictureString.getText());
            this.pictureClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ReceivedByClause addReceivedByClause(Cobol85Parser.DataReceivedByClauseContext ctx) {
        ReceivedByClause result = (ReceivedByClause)this.getASGElement(ctx);
        if (result == null) {
            result = new ReceivedByClauseImpl(this.programUnit, ctx);
            ReceivedByClause.ReceivedBy receivedBy = ctx.CONTENT() != null ? ReceivedByClause.ReceivedBy.CONTENT : (ctx.REFERENCE() != null ? ReceivedByClause.ReceivedBy.REFERENCE : (ctx.REF() != null ? ReceivedByClause.ReceivedBy.REFERENCE : null));
            result.setReceivedBy(receivedBy);
            this.receivedByClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public RecordAreaClause addRecordAreaClause(Cobol85Parser.DataRecordAreaClauseContext ctx) {
        RecordAreaClause result = (RecordAreaClause)this.getASGElement(ctx);
        if (result == null) {
            result = new RecordAreaClauseImpl(this.programUnit, ctx);
            result.setRecordArea(true);
            this.recordAreaClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public RedefinesClause addRedefinesClause(Cobol85Parser.DataRedefinesClauseContext ctx) {
        RedefinesClause result = (RedefinesClause)this.getASGElement(ctx);
        if (result == null) {
            result = new RedefinesClauseImpl(this.programUnit, ctx);
            Call redefinesCall = this.createCall(ctx.dataName());
            result.setRedefinesCall(redefinesCall);
            this.redefinesClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public SignClause addSignClause(Cobol85Parser.DataSignClauseContext ctx) {
        SignClause result = (SignClause)this.getASGElement(ctx);
        if (result == null) {
            result = new SignClauseImpl(this.programUnit, ctx);
            SignClause.SignClauseType type = ctx.LEADING() != null ? SignClause.SignClauseType.LEADING : (ctx.TRAILING() != null ? SignClause.SignClauseType.TRAILING : null);
            result.setSignClauseType(type);
            if (ctx.SEPARATE() != null) {
                result.setSeparate(true);
            }
            this.signClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public SynchronizedClause addSynchronizedClause(Cobol85Parser.DataSynchronizedClauseContext ctx) {
        SynchronizedClause result = (SynchronizedClause)this.getASGElement(ctx);
        if (result == null) {
            result = new SynchronizedClauseImpl(this.programUnit, ctx);
            SynchronizedClause.Synchronized sync = ctx.LEFT() != null ? SynchronizedClause.Synchronized.LEFT : (ctx.RIGHT() != null ? SynchronizedClause.Synchronized.RIGHT : null);
            result.setSynchronized(sync);
            this.synchronizedClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ThreadLocalClause addThreadLocalClause(Cobol85Parser.DataThreadLocalClauseContext ctx) {
        ThreadLocalClause result = (ThreadLocalClause)this.getASGElement(ctx);
        if (result == null) {
            result = new ThreadLocalClauseImpl(this.programUnit, ctx);
            result.setThreadLocal(true);
            this.threadLocalClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public TypeClause addTypeClause(Cobol85Parser.DataTypeClauseContext ctx) {
        TypeClause result = (TypeClause)this.getASGElement(ctx);
        if (result == null) {
            result = new TypeClauseImpl(this.programUnit, ctx);
            TypeClause.TimeType timeType = ctx.SHORT_DATE() != null ? TypeClause.TimeType.SHORT_DATE : (ctx.LONG_DATE() != null ? TypeClause.TimeType.LONG_DATE : (ctx.NUMERIC_DATE() != null ? TypeClause.TimeType.NUMERIC_DATE : (ctx.NUMERIC_TIME() != null ? TypeClause.TimeType.NUMERIC_TIME : (ctx.LONG_TIME() != null ? TypeClause.TimeType.LONG_TIME : null))));
            result.setTimeType(timeType);
            this.typeClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public TypeDefClause addTypeDefClause(Cobol85Parser.DataTypeDefClauseContext ctx) {
        TypeDefClause result = (TypeDefClause)this.getASGElement(ctx);
        if (result == null) {
            result = new TypeDefClauseImpl(this.programUnit, ctx);
            result.setTypeDef(true);
            this.typeDefClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public UsageClause addUsageClause(Cobol85Parser.DataUsageClauseContext ctx) {
        UsageClause result = (UsageClause)this.getASGElement(ctx);
        if (result == null) {
            UsageClause.UsageClauseType type;
            result = new UsageClauseImpl(this.programUnit, ctx);
            if (ctx.BINARY() != null) {
                type = UsageClause.UsageClauseType.BINARY;
            } else if (ctx.BIT() != null) {
                type = UsageClause.UsageClauseType.BIT;
            } else if (ctx.COMP() != null || ctx.COMPUTATIONAL() != null) {
                type = UsageClause.UsageClauseType.COMP;
            } else if (ctx.COMP_1() != null || ctx.COMPUTATIONAL_1() != null) {
                type = UsageClause.UsageClauseType.COMP_1;
            } else if (ctx.COMP_2() != null || ctx.COMPUTATIONAL_2() != null) {
                type = UsageClause.UsageClauseType.COMP_2;
            } else if (ctx.COMP_3() != null || ctx.COMPUTATIONAL_3() != null) {
                type = UsageClause.UsageClauseType.COMP_3;
            } else if (ctx.COMP_4() != null || ctx.COMPUTATIONAL_4() != null) {
                type = UsageClause.UsageClauseType.COMP_4;
            } else if (ctx.COMP_5() != null || ctx.COMPUTATIONAL_5() != null) {
                type = UsageClause.UsageClauseType.COMP_5;
            } else if (ctx.CONTROL_POINT() != null) {
                type = UsageClause.UsageClauseType.CONTROL_POINT;
            } else if (ctx.DATE() != null) {
                type = UsageClause.UsageClauseType.DATE;
            } else if (ctx.DISPLAY() != null) {
                type = UsageClause.UsageClauseType.DISPLAY;
            } else if (ctx.DISPLAY_1() != null) {
                type = UsageClause.UsageClauseType.DISPLAY_1;
            } else if (ctx.DOUBLE() != null) {
                type = UsageClause.UsageClauseType.DOUBLE;
            } else if (ctx.EVENT() != null) {
                type = UsageClause.UsageClauseType.EVENT;
            } else if (ctx.FUNCTION_POINTER() != null) {
                type = UsageClause.UsageClauseType.FUNCTION_POINTER;
            } else if (ctx.INDEX() != null) {
                type = UsageClause.UsageClauseType.INDEX;
            } else if (ctx.KANJI() != null) {
                type = UsageClause.UsageClauseType.KANJI;
            } else if (ctx.LOCK() != null) {
                type = UsageClause.UsageClauseType.LOCK;
            } else if (ctx.NATIONAL() != null) {
                type = UsageClause.UsageClauseType.NATIONAL;
            } else if (ctx.PACKED_DECIMAL() != null) {
                type = UsageClause.UsageClauseType.PACKED_DECIMAL;
            } else if (ctx.POINTER() != null) {
                type = UsageClause.UsageClauseType.POINTER;
            } else if (ctx.PROCEDURE_POINTER() != null) {
                type = UsageClause.UsageClauseType.PROCEDURE_POINTER;
            } else if (ctx.REAL() != null) {
                type = UsageClause.UsageClauseType.REAL;
            } else if (ctx.SQL() != null) {
                type = UsageClause.UsageClauseType.SQL;
            } else if (ctx.TASK() != null) {
                type = UsageClause.UsageClauseType.TASK;
            } else {
                LOG.warn("unknown usage at {}", (Object)ctx);
                type = null;
            }
            result.setUsageClauseType(type);
            this.usageClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public UsingClause addUsingClause(Cobol85Parser.DataUsingClauseContext ctx) {
        UsingClause result = (UsingClause)this.getASGElement(ctx);
        if (result == null) {
            UsingClause.UsingClauseType type;
            result = new UsingClauseImpl(this.programUnit, ctx);
            if (ctx.CONVENTION() != null) {
                type = UsingClause.UsingClauseType.CONVENTION;
            } else if (ctx.LANGUAGE() != null) {
                type = UsingClause.UsingClauseType.LANGUAGE;
            } else {
                LOG.warn("unknown type at {}", (Object)ctx);
                type = null;
            }
            result.setUsingClauseType(type);
            ValueStmt ofValueStmt = this.createValueStmt(ctx.cobolWord(), ctx.dataName());
            result.setOfValueStmt(ofValueStmt);
            this.usingClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ValueClause addValueClause(Cobol85Parser.DataValueClauseContext ctx) {
        ValueClause result = (ValueClause)this.getASGElement(ctx);
        if (result == null) {
            result = new ValueClauseImpl(this.programUnit, ctx);
            for (Cobol85Parser.DataValueIntervalContext dataValueIntervalContext : ctx.dataValueInterval()) {
                result.addValueInterval(dataValueIntervalContext);
            }
            this.valueClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public WithLowerBoundsClause addWithLowerBoundClause(Cobol85Parser.DataWithLowerBoundsClauseContext ctx) {
        WithLowerBoundsClause result = (WithLowerBoundsClause)this.getASGElement(ctx);
        if (result == null) {
            result = new WithLowerBoundsClauseImpl(this.programUnit, ctx);
            result.setWithLowerBounds(true);
            this.withLowerBoundsClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    protected DataDescriptionEntriesSymbolTableEntry assureDataDescriptionEntriesSymbolTableEntry(String name) {
        DataDescriptionEntriesSymbolTableEntry dataDescriptionEntriesSymbolTableEntry = this.dataDescriptionEntriesSymbolTable.get(this.getSymbol(name));
        if (dataDescriptionEntriesSymbolTableEntry == null) {
            dataDescriptionEntriesSymbolTableEntry = new DataDescriptionEntriesSymbolTableEntryImpl();
            this.dataDescriptionEntriesSymbolTable.put(this.getSymbol(name), dataDescriptionEntriesSymbolTableEntry);
        }
        return dataDescriptionEntriesSymbolTableEntry;
    }

    @Override
    public AlignedClause getAlignedClause() {
        return this.alignedClause;
    }

    @Override
    public BlankWhenZeroClause getBlankWhenZeroClause() {
        return this.blankWhenZeroClause;
    }

    @Override
    public CommonOwnLocalClause getCommonOwnLocalClause() {
        return this.commonOwnLocalClause;
    }

    @Override
    public List<DataDescriptionEntry> getDataDescriptionEntries() {
        return this.dataDescriptionEntries;
    }

    @Override
    public List<DataDescriptionEntry> getDataDescriptionEntries(String name) {
        return this.dataDescriptionEntriesSymbolTable.get(this.getSymbol(name)).getDataDescriptionEntries();
    }

    @Override
    public DataDescriptionEntry getDataDescriptionEntry(String name) {
        return this.dataDescriptionEntriesSymbolTable.get(this.getSymbol(name)) == null ? null : this.dataDescriptionEntriesSymbolTable.get(this.getSymbol(name)).getDataDescriptionEntry();
    }

    @Override
    public DataDescriptionEntry.DataDescriptionEntryType getDataDescriptionEntryType() {
        DataDescriptionEntry.DataDescriptionEntryType result = 77 == this.levelNumber ? DataDescriptionEntry.DataDescriptionEntryType.SCALAR : DataDescriptionEntry.DataDescriptionEntryType.GROUP;
        return result;
    }

    @Override
    public ExternalClause getExternalClause() {
        return this.externalClause;
    }

    @Override
    public Boolean getFiller() {
        return this.filler;
    }

    @Override
    public Integer getFillerNumber() {
        return this.fillerNumber;
    }

    @Override
    public GlobalClause getGlobalClause() {
        return this.globalClause;
    }

    @Override
    public IntegerStringClause getIntegerStringClause() {
        return this.integerStringClause;
    }

    @Override
    public JustifiedClause getJustifiedClause() {
        return this.justifiedClause;
    }

    @Override
    public List<OccursClause> getOccursClauses() {
        return this.occursClauses;
    }

    @Override
    public PictureClause getPictureClause() {
        return this.pictureClause;
    }

    @Override
    public ReceivedByClause getReceivedByClause() {
        return this.receivedByClause;
    }

    @Override
    public RecordAreaClause getRecordAreaClause() {
        return this.recordAreaClause;
    }

    @Override
    public RedefinesClause getRedefinesClause() {
        return this.redefinesClause;
    }

    @Override
    public SignClause getSignClause() {
        return this.signClause;
    }

    @Override
    public SynchronizedClause getSynchronizedClause() {
        return this.synchronizedClause;
    }

    @Override
    public ThreadLocalClause getThreadLocalClause() {
        return this.threadLocalClause;
    }

    @Override
    public Type getType() {
        Type result;
        if (this.pictureClause != null) {
            String pictureString = this.pictureClause.getPictureString();
            result = PictureUtils.determineType(pictureString);
        } else if (this.valueClause != null) {
            ValueInterval valueInterval = this.valueClause.getValueIntervals().get(0);
            result = valueInterval.getFromValueStmt().getType();
        } else {
            result = !this.dataDescriptionEntries.isEmpty() ? this : null;
        }
        return result;
    }

    @Override
    public TypeClause getTypeClause() {
        return this.typeClause;
    }

    @Override
    public TypeDefClause getTypeDefClause() {
        return this.typeDefClause;
    }

    @Override
    public UsageClause getUsageClause() {
        return this.usageClause;
    }

    @Override
    public UsingClause getUsingClause() {
        return this.usingClause;
    }

    @Override
    public ValueClause getValueClause() {
        return this.valueClause;
    }

    @Override
    public WithLowerBoundsClause getWithLowerBoundsClause() {
        return this.withLowerBoundsClause;
    }

    @Override
    public void setFiller(Boolean filler) {
        this.filler = filler;
    }

    @Override
    public void setFillerNumber(Integer fillerNumber) {
        this.fillerNumber = fillerNumber;
    }
}

