/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.data.report.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.call.ReportCall;
import io.proleap.cobol.asg.metamodel.data.report.ReportDescription;
import io.proleap.cobol.asg.metamodel.data.report.ReportDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.report.ReportGroupDescriptionEntriesSymbolTableEntry;
import io.proleap.cobol.asg.metamodel.data.report.ReportGroupDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.report.ReportGroupDescriptionEntryPrintable;
import io.proleap.cobol.asg.metamodel.data.report.ReportGroupDescriptionEntrySingle;
import io.proleap.cobol.asg.metamodel.data.report.ReportGroupDescriptionEntryVertical;
import io.proleap.cobol.asg.metamodel.data.report.impl.ReportDescriptionEntryImpl;
import io.proleap.cobol.asg.metamodel.data.report.impl.ReportGroupDescriptionEntriesSymbolTableEntryImpl;
import io.proleap.cobol.asg.metamodel.data.report.impl.ReportGroupDescriptionEntryPrintableImpl;
import io.proleap.cobol.asg.metamodel.data.report.impl.ReportGroupDescriptionEntrySingleImpl;
import io.proleap.cobol.asg.metamodel.data.report.impl.ReportGroupDescriptionEntryVerticalImpl;
import io.proleap.cobol.asg.metamodel.impl.CobolDivisionElementImpl;
import io.proleap.cobol.asg.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReportDescriptionImpl
extends CobolDivisionElementImpl
implements ReportDescription {
    private static final Logger LOG = LogManager.getLogger(ReportDescriptionImpl.class);
    protected List<ReportCall> calls = new ArrayList<ReportCall>();
    protected final Cobol85Parser.ReportDescriptionContext ctx;
    protected String name;
    protected ReportDescriptionEntry reportDescriptionEntry;
    protected List<ReportGroupDescriptionEntry> reportGroupDescriptionEntries = new ArrayList<ReportGroupDescriptionEntry>();
    protected Map<String, ReportGroupDescriptionEntriesSymbolTableEntry> reportGroupDescriptionEntriesSymbolTable = new HashMap<String, ReportGroupDescriptionEntriesSymbolTableEntry>();

    public ReportDescriptionImpl(String name, ProgramUnit programUnit, Cobol85Parser.ReportDescriptionContext ctx) {
        super(programUnit, (ParserRuleContext)ctx);
        this.ctx = ctx;
        this.name = name;
    }

    @Override
    public void addCall(ReportCall call) {
        this.calls.add(call);
    }

    @Override
    public ReportDescriptionEntry addReportDescriptionEntry(Cobol85Parser.ReportDescriptionEntryContext ctx) {
        ReportDescriptionEntry result = (ReportDescriptionEntry)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx.reportName());
            result = new ReportDescriptionEntryImpl(name, this.programUnit, ctx);
            if (ctx.reportDescriptionGlobalClause() != null) {
                result.addGlobalClause(ctx.reportDescriptionGlobalClause());
            }
            if (ctx.reportDescriptionPageLimitClause() != null) {
                result.addPageLimitClause(ctx.reportDescriptionPageLimitClause());
            }
            if (ctx.reportDescriptionHeadingClause() != null) {
                result.addHeadingClause(ctx.reportDescriptionHeadingClause());
            }
            if (ctx.reportDescriptionFirstDetailClause() != null) {
                result.addFirstDetailClause(ctx.reportDescriptionFirstDetailClause());
            }
            if (ctx.reportDescriptionLastDetailClause() != null) {
                result.addLastDetailClause(ctx.reportDescriptionLastDetailClause());
            }
            if (ctx.reportDescriptionFootingClause() != null) {
                result.addFootingClause(ctx.reportDescriptionFootingClause());
            }
            result.setReport(this);
            this.reportDescriptionEntry = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ReportGroupDescriptionEntryPrintable addReportGroupDescriptionEntryPrintable(Cobol85Parser.ReportGroupDescriptionEntryFormat3Context ctx) {
        ReportGroupDescriptionEntryPrintable result = (ReportGroupDescriptionEntryPrintable)this.getASGElement(ctx);
        if (result == null) {
            List<Cobol85Parser.ReportGroupIndicateClauseContext> indicateClauseContexts;
            List<Cobol85Parser.ReportGroupResetClauseContext> resetClauseContexts;
            List<Cobol85Parser.ReportGroupSumClauseContext> sumClauseContexts;
            List<Cobol85Parser.ReportGroupValueClauseContext> valueClauseContexts;
            List<Cobol85Parser.ReportGroupSourceClauseContext> sourceClauseContexts;
            List<Cobol85Parser.ReportGroupColumnNumberClauseContext> columnNumberClauseContexts;
            List<Cobol85Parser.ReportGroupLineNumberClauseContext> lineNumberClauseContexts;
            List<Cobol85Parser.ReportGroupBlankWhenZeroClauseContext> blankWhenZeroClauseContexts;
            List<Cobol85Parser.ReportGroupJustifiedClauseContext> justifiedClauseContexts;
            List<Cobol85Parser.ReportGroupSignClauseContext> signClauseContexts;
            List<Cobol85Parser.ReportGroupUsageClauseContext> usageClauseContexts;
            String name = this.determineName(ctx);
            result = new ReportGroupDescriptionEntryPrintableImpl(name, this.programUnit, ctx);
            Integer levelNumber = StringUtils.parseInteger(ctx.integerLiteral().getText());
            result.setLevelNumber(levelNumber);
            List<Cobol85Parser.ReportGroupPictureClauseContext> pictureClauseContexts = ctx.reportGroupPictureClause();
            if (!pictureClauseContexts.isEmpty()) {
                Cobol85Parser.ReportGroupPictureClauseContext pictureClauseContext = pictureClauseContexts.get(0);
                result.addPictureClause(pictureClauseContext);
            }
            if (!(usageClauseContexts = ctx.reportGroupUsageClause()).isEmpty()) {
                Cobol85Parser.ReportGroupUsageClauseContext groupUsageClause = usageClauseContexts.get(0);
                result.addGroupUsageClause(groupUsageClause);
            }
            if (!(signClauseContexts = ctx.reportGroupSignClause()).isEmpty()) {
                Cobol85Parser.ReportGroupSignClauseContext signClauseContext = signClauseContexts.get(0);
                result.addSignClause(signClauseContext);
            }
            if (!(justifiedClauseContexts = ctx.reportGroupJustifiedClause()).isEmpty()) {
                Cobol85Parser.ReportGroupJustifiedClauseContext justifiedClauseContext = justifiedClauseContexts.get(0);
                result.addJustifiedClause(justifiedClauseContext);
            }
            if (!(blankWhenZeroClauseContexts = ctx.reportGroupBlankWhenZeroClause()).isEmpty()) {
                Cobol85Parser.ReportGroupBlankWhenZeroClauseContext blankWhenZeroClauseContext = blankWhenZeroClauseContexts.get(0);
                result.addBlankWhenZeroClause(blankWhenZeroClauseContext);
            }
            if (!(lineNumberClauseContexts = ctx.reportGroupLineNumberClause()).isEmpty()) {
                Cobol85Parser.ReportGroupLineNumberClauseContext lineNumberClauseContext = lineNumberClauseContexts.get(0);
                result.addLineNumberClause(lineNumberClauseContext);
            }
            if (!(columnNumberClauseContexts = ctx.reportGroupColumnNumberClause()).isEmpty()) {
                Cobol85Parser.ReportGroupColumnNumberClauseContext columnNumberClauseContext = columnNumberClauseContexts.get(0);
                result.addColumnNumberClause(columnNumberClauseContext);
            }
            if (!(sourceClauseContexts = ctx.reportGroupSourceClause()).isEmpty()) {
                Cobol85Parser.ReportGroupSourceClauseContext sourceClauseContext = sourceClauseContexts.get(0);
                result.addSourceClause(sourceClauseContext);
            }
            if (!(valueClauseContexts = ctx.reportGroupValueClause()).isEmpty()) {
                Cobol85Parser.ReportGroupValueClauseContext valueClauseContext = valueClauseContexts.get(0);
                result.addValueClause(valueClauseContext);
            }
            if (!(sumClauseContexts = ctx.reportGroupSumClause()).isEmpty()) {
                Cobol85Parser.ReportGroupSumClauseContext sumClauseContext = sumClauseContexts.get(0);
                result.addSumClause(sumClauseContext);
            }
            if (!(resetClauseContexts = ctx.reportGroupResetClause()).isEmpty()) {
                Cobol85Parser.ReportGroupResetClauseContext resetClauseContext = resetClauseContexts.get(0);
                result.addResetClause(resetClauseContext);
            }
            if (!(indicateClauseContexts = ctx.reportGroupIndicateClause()).isEmpty()) {
                Cobol85Parser.ReportGroupIndicateClauseContext indicateClauseContext = indicateClauseContexts.get(0);
                result.addGroupIndicateClause(indicateClauseContext);
            }
            this.reportGroupDescriptionEntries.add(result);
            this.assureReportGroupDescriptionEntriesSymbolTableEntry(name).addReportGroupDescriptionEntry(result);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ReportGroupDescriptionEntrySingle addReportGroupDescriptionEntrySingle(Cobol85Parser.ReportGroupDescriptionEntryFormat2Context ctx) {
        ReportGroupDescriptionEntrySingle result = (ReportGroupDescriptionEntrySingle)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new ReportGroupDescriptionEntrySingleImpl(name, this.programUnit, ctx);
            Integer levelNumber = StringUtils.parseInteger(ctx.integerLiteral().getText());
            result.setLevelNumber(levelNumber);
            if (ctx.reportGroupLineNumberClause() != null) {
                Cobol85Parser.ReportGroupLineNumberClauseContext lineNumberClauseContext = ctx.reportGroupLineNumberClause();
                result.addLineNumberClause(lineNumberClauseContext);
            }
            if (ctx.reportGroupUsageClause() != null) {
                Cobol85Parser.ReportGroupUsageClauseContext usageClauseContext = ctx.reportGroupUsageClause();
                result.addGroupUsageClause(usageClauseContext);
            }
            this.reportGroupDescriptionEntries.add(result);
            this.assureReportGroupDescriptionEntriesSymbolTableEntry(name).addReportGroupDescriptionEntry(result);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ReportGroupDescriptionEntryVertical addReportGroupDescriptionEntryVertical(Cobol85Parser.ReportGroupDescriptionEntryFormat1Context ctx) {
        ReportGroupDescriptionEntryVertical result = (ReportGroupDescriptionEntryVertical)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new ReportGroupDescriptionEntryVerticalImpl(name, this.programUnit, ctx);
            Integer levelNumber = StringUtils.parseInteger(ctx.integerLiteral().getText());
            result.setLevelNumber(levelNumber);
            if (ctx.reportGroupLineNumberClause() != null) {
                Cobol85Parser.ReportGroupLineNumberClauseContext lineNumberClauseContext = ctx.reportGroupLineNumberClause();
                result.addLineNumberClause(lineNumberClauseContext);
            }
            if (ctx.reportGroupNextGroupClause() != null) {
                Cobol85Parser.ReportGroupNextGroupClauseContext nextGroupClause = ctx.reportGroupNextGroupClause();
                result.addNextGroupClause(nextGroupClause);
            }
            if (ctx.reportGroupTypeClause() != null) {
                Cobol85Parser.ReportGroupTypeClauseContext typeClause = ctx.reportGroupTypeClause();
                result.addTypeClause(typeClause);
            }
            if (ctx.reportGroupUsageClause() != null) {
                Cobol85Parser.ReportGroupUsageClauseContext groupUsageClause = ctx.reportGroupUsageClause();
                result.addGroupUsageClause(groupUsageClause);
            }
            this.reportGroupDescriptionEntries.add(result);
            this.assureReportGroupDescriptionEntriesSymbolTableEntry(name).addReportGroupDescriptionEntry(result);
            this.registerASGElement(result);
        }
        return result;
    }

    protected ReportGroupDescriptionEntriesSymbolTableEntry assureReportGroupDescriptionEntriesSymbolTableEntry(String name) {
        ReportGroupDescriptionEntriesSymbolTableEntry reportGroupDescriptionEntriesSymbolTableEntry = this.reportGroupDescriptionEntriesSymbolTable.get(this.getSymbol(name));
        if (reportGroupDescriptionEntriesSymbolTableEntry == null) {
            reportGroupDescriptionEntriesSymbolTableEntry = new ReportGroupDescriptionEntriesSymbolTableEntryImpl();
            this.reportGroupDescriptionEntriesSymbolTable.put(this.getSymbol(name), reportGroupDescriptionEntriesSymbolTableEntry);
        }
        return reportGroupDescriptionEntriesSymbolTableEntry;
    }

    @Override
    public ReportGroupDescriptionEntry createReportGroupDescriptionEntry(ReportGroupDescriptionEntry lastReportGroupDescriptionEntry, Cobol85Parser.ReportGroupDescriptionEntryContext ctx) {
        ReportGroupDescriptionEntry result;
        if (ctx.reportGroupDescriptionEntryFormat1() != null) {
            result = this.addReportGroupDescriptionEntryVertical(ctx.reportGroupDescriptionEntryFormat1());
        } else if (ctx.reportGroupDescriptionEntryFormat2() != null) {
            result = this.addReportGroupDescriptionEntrySingle(ctx.reportGroupDescriptionEntryFormat2());
        } else if (ctx.reportGroupDescriptionEntryFormat3() != null) {
            result = this.addReportGroupDescriptionEntryPrintable(ctx.reportGroupDescriptionEntryFormat3());
        } else {
            LOG.warn("unknown report description entry {}", (Object)ctx);
            result = null;
        }
        if (lastReportGroupDescriptionEntry != null && result != null) {
            this.groupReportGroupDescriptionEntry(lastReportGroupDescriptionEntry, result);
        }
        return result;
    }

    @Override
    public List<ReportCall> getCalls() {
        return this.calls;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ReportDescriptionEntry getReportDescriptionEntry() {
        return this.reportDescriptionEntry;
    }

    @Override
    public List<ReportGroupDescriptionEntry> getReportGroupDescriptionEntries() {
        return this.reportGroupDescriptionEntries;
    }

    @Override
    public List<ReportGroupDescriptionEntry> getReportGroupDescriptionEntries(String name) {
        return this.reportGroupDescriptionEntriesSymbolTable.get(this.getSymbol(name)) == null ? null : this.reportGroupDescriptionEntriesSymbolTable.get(this.getSymbol(name)).getReportGroupDescriptionEntries();
    }

    @Override
    public ReportGroupDescriptionEntry getReportGroupDescriptionEntry(String name) {
        return this.reportGroupDescriptionEntriesSymbolTable.get(this.getSymbol(name)) == null ? null : this.reportGroupDescriptionEntriesSymbolTable.get(this.getSymbol(name)).getReportGroupDescriptionEntry();
    }

    @Override
    public List<ReportGroupDescriptionEntry> getRootReportGroupDescriptionEntries() {
        ArrayList<ReportGroupDescriptionEntry> result = new ArrayList<ReportGroupDescriptionEntry>();
        for (ReportGroupDescriptionEntry reportGroupDescriptionEntry : this.reportGroupDescriptionEntries) {
            if (reportGroupDescriptionEntry.getParentReportGroupDescriptionEntry() != null) continue;
            result.add(reportGroupDescriptionEntry);
        }
        return result;
    }

    protected void groupReportGroupDescriptionEntry(ReportGroupDescriptionEntry lastReportGroupDescriptionEntry, ReportGroupDescriptionEntry reportGroupDescriptionEntry) {
        Integer lastLevelNumber = lastReportGroupDescriptionEntry.getLevelNumber();
        Integer levelNumber = reportGroupDescriptionEntry.getLevelNumber();
        if (levelNumber > lastLevelNumber) {
            lastReportGroupDescriptionEntry.addReportGroupDescriptionEntry(reportGroupDescriptionEntry);
            reportGroupDescriptionEntry.setParentReportGroupDescriptionEntry(lastReportGroupDescriptionEntry);
        } else {
            ReportGroupDescriptionEntry lastParentReportGroupDescriptionEntry = lastReportGroupDescriptionEntry.getParentReportGroupDescriptionEntry();
            if (lastParentReportGroupDescriptionEntry != null) {
                this.groupReportGroupDescriptionEntry(lastParentReportGroupDescriptionEntry, reportGroupDescriptionEntry);
            }
        }
    }
}

