/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.data.report.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.IntegerLiteral;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.data.report.LineNumberClause;
import io.proleap.cobol.asg.metamodel.data.report.ReportGroupDescriptionEntry;
import io.proleap.cobol.asg.metamodel.data.report.UsageClause;
import io.proleap.cobol.asg.metamodel.data.report.impl.LineNumberClauseImpl;
import io.proleap.cobol.asg.metamodel.data.report.impl.UsageClauseImpl;
import io.proleap.cobol.asg.metamodel.impl.CobolDivisionElementImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ReportGroupDescriptionEntryImpl
extends CobolDivisionElementImpl
implements ReportGroupDescriptionEntry {
    private static final Logger LOG = LogManager.getLogger(ReportGroupDescriptionEntryImpl.class);
    protected final ParserRuleContext ctx;
    protected Integer levelNumber;
    protected LineNumberClause lineNumberClause;
    protected final String name;
    protected ReportGroupDescriptionEntry parentReportGroupDescriptionEntry;
    protected List<ReportGroupDescriptionEntry> reportGroupDescriptionEntries = new ArrayList<ReportGroupDescriptionEntry>();
    protected Map<String, ReportGroupDescriptionEntry> reportGroupDescriptionEntriesSymbolTable = new HashMap<String, ReportGroupDescriptionEntry>();
    protected UsageClause usageClause;

    public ReportGroupDescriptionEntryImpl(String name, ProgramUnit programUnit, ParserRuleContext ctx) {
        super(programUnit, ctx);
        this.ctx = ctx;
        this.name = name;
    }

    @Override
    public UsageClause addGroupUsageClause(Cobol85Parser.ReportGroupUsageClauseContext ctx) {
        UsageClause result = (UsageClause)this.getASGElement(ctx);
        if (result == null) {
            UsageClause.UsageClauseType type;
            result = new UsageClauseImpl(this.programUnit, ctx);
            if (ctx.DISPLAY() != null) {
                type = UsageClause.UsageClauseType.DISPLAY;
            } else if (ctx.DISPLAY_1() != null) {
                type = UsageClause.UsageClauseType.DISPLAY_1;
            } else {
                LOG.warn("unknown usage at {}", (Object)ctx);
                type = null;
            }
            result.setUsageClauseType(type);
            this.usageClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public LineNumberClause addLineNumberClause(Cobol85Parser.ReportGroupLineNumberClauseContext ctx) {
        LineNumberClause result = (LineNumberClause)this.getASGElement(ctx);
        if (result == null) {
            IntegerLiteral integerLiteral;
            LineNumberClause.LineNumberClauseType type;
            result = new LineNumberClauseImpl(this.programUnit, ctx);
            if (ctx.reportGroupLineNumberNextPage() != null) {
                type = LineNumberClause.LineNumberClauseType.NEXT_PAGE;
                Cobol85Parser.ReportGroupLineNumberNextPageContext reportGroupLineNumberNextPage = ctx.reportGroupLineNumberNextPage();
                integerLiteral = reportGroupLineNumberNextPage.integerLiteral() != null ? this.createIntegerLiteral(reportGroupLineNumberNextPage.integerLiteral()) : null;
            } else if (ctx.reportGroupLineNumberPlus() != null) {
                type = LineNumberClause.LineNumberClauseType.PLUS;
                Cobol85Parser.ReportGroupLineNumberPlusContext reportGroupLineNumberPlus = ctx.reportGroupLineNumberPlus();
                integerLiteral = reportGroupLineNumberPlus.integerLiteral() != null ? this.createIntegerLiteral(reportGroupLineNumberPlus.integerLiteral()) : null;
            } else {
                LOG.warn("unknown line number at {}", (Object)ctx);
                type = null;
                integerLiteral = null;
            }
            result.setLineNumberClauseType(type);
            result.setIntegerLiteral(integerLiteral);
            this.lineNumberClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public void addReportGroupDescriptionEntry(ReportGroupDescriptionEntry reportGroupDescriptionEntry) {
        String name = reportGroupDescriptionEntry.getName();
        this.reportGroupDescriptionEntries.add(reportGroupDescriptionEntry);
        this.reportGroupDescriptionEntriesSymbolTable.put(this.getSymbol(name), reportGroupDescriptionEntry);
    }

    @Override
    public Integer getLevelNumber() {
        return this.levelNumber;
    }

    @Override
    public LineNumberClause getLineNumberClause() {
        return this.lineNumberClause;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ReportGroupDescriptionEntry getParentReportGroupDescriptionEntry() {
        return this.parentReportGroupDescriptionEntry;
    }

    @Override
    public List<ReportGroupDescriptionEntry> getReportGroupDescriptionEntries() {
        return this.reportGroupDescriptionEntries;
    }

    @Override
    public ReportGroupDescriptionEntry getReportGroupDescriptionEntry(String name) {
        return this.reportGroupDescriptionEntriesSymbolTable.get(this.getSymbol(name));
    }

    @Override
    public UsageClause getUsageClause() {
        return this.usageClause;
    }

    @Override
    public void setLevelNumber(Integer levelNumber) {
        this.levelNumber = levelNumber;
    }

    @Override
    public void setParentReportGroupDescriptionEntry(ReportGroupDescriptionEntry parentReportGroupDescriptionEntry) {
        this.parentReportGroupDescriptionEntry = parentReportGroupDescriptionEntry;
    }

    public String toString() {
        return "name=[" + this.name + "]";
    }
}

