/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.environment.configuration.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.environment.configuration.ConfigurationSection;
import io.proleap.cobol.asg.metamodel.environment.configuration.object.ObjectComputerParagraph;
import io.proleap.cobol.asg.metamodel.environment.configuration.object.impl.ObjectComputerParagraphImpl;
import io.proleap.cobol.asg.metamodel.environment.configuration.source.SourceComputerParagraph;
import io.proleap.cobol.asg.metamodel.environment.configuration.source.impl.SourceComputerParagraphImpl;
import io.proleap.cobol.asg.metamodel.impl.CobolDivisionElementImpl;
import org.antlr.v4.runtime.ParserRuleContext;

public class ConfigurationSectionImpl
extends CobolDivisionElementImpl
implements ConfigurationSection {
    protected final Cobol85Parser.ConfigurationSectionContext ctx;
    protected ObjectComputerParagraph objectComputerParagraph;
    protected SourceComputerParagraph sourceComputerParagraph;

    public ConfigurationSectionImpl(ProgramUnit programUnit, Cobol85Parser.ConfigurationSectionContext ctx) {
        super(programUnit, (ParserRuleContext)ctx);
        this.ctx = ctx;
    }

    @Override
    public ObjectComputerParagraph addObjectComputerParagraph(Cobol85Parser.ObjectComputerParagraphContext ctx) {
        ObjectComputerParagraph result = (ObjectComputerParagraph)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new ObjectComputerParagraphImpl(name, this.programUnit, ctx);
            for (Cobol85Parser.ObjectComputerClauseContext objectComputerClause : ctx.objectComputerClause()) {
                if (objectComputerClause.memorySizeClause() != null) {
                    result.addMemorySizeClause(objectComputerClause.memorySizeClause());
                }
                if (objectComputerClause.diskSizeClause() != null) {
                    result.addDiskSizeClause(objectComputerClause.diskSizeClause());
                }
                if (objectComputerClause.collatingSequenceClause() != null) {
                    result.addCollatingSequenceClause(objectComputerClause.collatingSequenceClause());
                }
                if (objectComputerClause.segmentLimitClause() != null) {
                    result.addSegmentLimitClause(objectComputerClause.segmentLimitClause());
                }
                if (objectComputerClause.characterSetClause() == null) continue;
                result.addCharacterSetClause(objectComputerClause.characterSetClause());
            }
            this.objectComputerParagraph = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public SourceComputerParagraph addSourceComputerParagraph(Cobol85Parser.SourceComputerParagraphContext ctx) {
        SourceComputerParagraph result = (SourceComputerParagraph)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new SourceComputerParagraphImpl(name, this.programUnit, ctx);
            if (ctx.DEBUGGING() != null) {
                result.setDebuggingMode(true);
            }
            this.sourceComputerParagraph = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ObjectComputerParagraph getObjectComputerParagraph() {
        return this.objectComputerParagraph;
    }

    @Override
    public SourceComputerParagraph getSourceComputerParagraph() {
        return this.sourceComputerParagraph;
    }
}

