/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.procedure.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.call.Call;
import io.proleap.cobol.asg.metamodel.impl.ScopeImpl;
import io.proleap.cobol.asg.metamodel.procedure.GivingClause;
import io.proleap.cobol.asg.metamodel.procedure.Paragraph;
import io.proleap.cobol.asg.metamodel.procedure.ParagraphName;
import io.proleap.cobol.asg.metamodel.procedure.ParagraphsSymbolTableEntry;
import io.proleap.cobol.asg.metamodel.procedure.ProcedureDivision;
import io.proleap.cobol.asg.metamodel.procedure.Section;
import io.proleap.cobol.asg.metamodel.procedure.SectionsSymbolTableEntry;
import io.proleap.cobol.asg.metamodel.procedure.UsingClause;
import io.proleap.cobol.asg.metamodel.procedure.declaratives.Declaratives;
import io.proleap.cobol.asg.metamodel.procedure.declaratives.impl.DeclarativesImpl;
import io.proleap.cobol.asg.metamodel.procedure.impl.GivingClauseImpl;
import io.proleap.cobol.asg.metamodel.procedure.impl.ParagraphImpl;
import io.proleap.cobol.asg.metamodel.procedure.impl.ParagraphNameImpl;
import io.proleap.cobol.asg.metamodel.procedure.impl.ParagraphsSymbolTableEntryImpl;
import io.proleap.cobol.asg.metamodel.procedure.impl.SectionImpl;
import io.proleap.cobol.asg.metamodel.procedure.impl.SectionsSymbolTableEntryImpl;
import io.proleap.cobol.asg.metamodel.procedure.impl.UsingClauseImpl;
import io.proleap.cobol.asg.metamodel.valuestmt.ValueStmt;
import io.proleap.cobol.asg.metamodel.valuestmt.impl.LiteralValueStmtImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;

public class ProcedureDivisionImpl
extends ScopeImpl
implements ProcedureDivision {
    protected final Cobol85Parser.ProcedureDivisionContext ctx;
    protected Declaratives declaratives;
    protected GivingClause givingClause;
    protected List<Paragraph> paragraphs = new ArrayList<Paragraph>();
    protected Map<String, ParagraphsSymbolTableEntry> paragraphsSymbolTable = new HashMap<String, ParagraphsSymbolTableEntry>();
    protected List<Section> sections = new ArrayList<Section>();
    protected Map<String, SectionsSymbolTableEntry> sectionsSymbolTable = new HashMap<String, SectionsSymbolTableEntry>();
    protected UsingClause usingClause;

    public ProcedureDivisionImpl(ProgramUnit programUnit, Cobol85Parser.ProcedureDivisionContext ctx) {
        super(programUnit, (ParserRuleContext)ctx);
        this.ctx = ctx;
    }

    @Override
    public Declaratives addDeclaratives(Cobol85Parser.ProcedureDeclarativesContext ctx) {
        Declaratives result = (Declaratives)this.getASGElement(ctx);
        if (result == null) {
            this.declaratives = result = new DeclarativesImpl(this.programUnit, ctx);
            for (Cobol85Parser.ProcedureDeclarativeContext procedureDeclarativeContext : ctx.procedureDeclarative()) {
                result.addDeclarative(procedureDeclarativeContext);
            }
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public GivingClause addGivingClause(Cobol85Parser.ProcedureDivisionGivingClauseContext ctx) {
        GivingClause result = (GivingClause)this.getASGElement(ctx);
        if (result == null) {
            result = new GivingClauseImpl(this.programUnit, ctx);
            Call givingCall = this.createCall(ctx.dataName());
            result.setGivingCall(givingCall);
            this.givingClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public void addParagraph(Paragraph paragraph) {
        String name = paragraph.getName();
        this.paragraphs.add(paragraph);
        this.assureParagraphsSymbolTableEntry(name).addParagraph(paragraph);
    }

    @Override
    public Paragraph addParagraph(Cobol85Parser.ParagraphContext ctx) {
        Paragraph result = (Paragraph)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new ParagraphImpl(name, this.programUnit, ctx);
            this.addParagraph(result);
            ParagraphName paragraphName = this.addParagraphName(ctx.paragraphName());
            result.addParagraphName(paragraphName);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ParagraphName addParagraphName(Cobol85Parser.ParagraphNameContext ctx) {
        ParagraphName result = (ParagraphName)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new ParagraphNameImpl(name, this.programUnit, ctx);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public Section addSection(Cobol85Parser.ProcedureSectionContext ctx) {
        Section result = (Section)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new SectionImpl(name, this.programUnit, ctx);
            this.sections.add(result);
            this.assureSectionsSymbolTableEntry(name).addSection(result);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public UsingClause addUsingClause(Cobol85Parser.ProcedureDivisionUsingClauseContext ctx) {
        UsingClause result = (UsingClause)this.getASGElement(ctx);
        if (result == null) {
            result = new UsingClauseImpl(this.programUnit, ctx);
            for (Cobol85Parser.ProcedureDivisionUsingParameterContext procedureDivisionUsingParameterContext : ctx.procedureDivisionUsingParameter()) {
                result.addUsingParameter(procedureDivisionUsingParameterContext);
            }
            this.usingClause = result;
            this.registerASGElement(result);
        }
        return result;
    }

    public ValueStmt addValueStmt(Cobol85Parser.LiteralContext ctx) {
        ValueStmt result = (ValueStmt)this.getASGElement(ctx);
        if (result == null) {
            result = new LiteralValueStmtImpl(this.programUnit, ctx);
            this.registerASGElement(result);
        }
        return result;
    }

    protected ParagraphsSymbolTableEntry assureParagraphsSymbolTableEntry(String name) {
        ParagraphsSymbolTableEntry paragraphsSymbolTableEntry = this.paragraphsSymbolTable.get(this.getSymbol(name));
        if (paragraphsSymbolTableEntry == null) {
            paragraphsSymbolTableEntry = new ParagraphsSymbolTableEntryImpl();
            this.paragraphsSymbolTable.put(this.getSymbol(name), paragraphsSymbolTableEntry);
        }
        return paragraphsSymbolTableEntry;
    }

    protected SectionsSymbolTableEntry assureSectionsSymbolTableEntry(String name) {
        SectionsSymbolTableEntry sectionsSymbolTableEntry = this.sectionsSymbolTable.get(this.getSymbol(name));
        if (sectionsSymbolTableEntry == null) {
            sectionsSymbolTableEntry = new SectionsSymbolTableEntryImpl();
            this.sectionsSymbolTable.put(this.getSymbol(name), sectionsSymbolTableEntry);
        }
        return sectionsSymbolTableEntry;
    }

    @Override
    public Declaratives getDeclaratives() {
        return this.declaratives;
    }

    @Override
    public GivingClause getGivingClause() {
        return this.givingClause;
    }

    @Override
    public Paragraph getParagraph(String name) {
        return this.paragraphsSymbolTable.get(this.getSymbol(name)) == null ? null : this.paragraphsSymbolTable.get(this.getSymbol(name)).getParagraph();
    }

    @Override
    public List<Paragraph> getParagraphs() {
        return this.paragraphs;
    }

    @Override
    public List<Paragraph> getParagraphs(String name) {
        return this.paragraphsSymbolTable.get(this.getSymbol(name)).getParagraphs();
    }

    @Override
    public List<Paragraph> getRootParagraphs() {
        ArrayList<Paragraph> result = new ArrayList<Paragraph>();
        for (Paragraph paragraph : this.paragraphs) {
            if (paragraph.getSection() != null) continue;
            result.add(paragraph);
        }
        return result;
    }

    @Override
    public Section getSection(String name) {
        return this.sectionsSymbolTable.get(this.getSymbol(name)) == null ? null : this.sectionsSymbolTable.get(this.getSymbol(name)).getSection();
    }

    @Override
    public List<Section> getSections() {
        return this.sections;
    }

    @Override
    public List<Section> getSections(String name) {
        return this.sectionsSymbolTable.get(this.getSymbol(name)).getSections();
    }

    @Override
    public UsingClause getUsingClause() {
        return this.usingClause;
    }
}

