/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.procedure.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.call.SectionCall;
import io.proleap.cobol.asg.metamodel.impl.ScopeImpl;
import io.proleap.cobol.asg.metamodel.procedure.Paragraph;
import io.proleap.cobol.asg.metamodel.procedure.ParagraphName;
import io.proleap.cobol.asg.metamodel.procedure.ParagraphsSymbolTableEntry;
import io.proleap.cobol.asg.metamodel.procedure.Section;
import io.proleap.cobol.asg.metamodel.procedure.impl.ParagraphImpl;
import io.proleap.cobol.asg.metamodel.procedure.impl.ParagraphNameImpl;
import io.proleap.cobol.asg.metamodel.procedure.impl.ParagraphsSymbolTableEntryImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;

public class SectionImpl
extends ScopeImpl
implements Section {
    protected final List<SectionCall> calls = new ArrayList<SectionCall>();
    protected final Cobol85Parser.ProcedureSectionContext ctx;
    protected final String name;
    protected List<Paragraph> paragraphs = new ArrayList<Paragraph>();
    protected Map<String, ParagraphsSymbolTableEntry> paragraphsSymbolTable = new HashMap<String, ParagraphsSymbolTableEntry>();

    public SectionImpl(String name, ProgramUnit programUnit, Cobol85Parser.ProcedureSectionContext ctx) {
        super(programUnit, (ParserRuleContext)ctx);
        this.name = name;
        this.ctx = ctx;
    }

    @Override
    public void addCall(SectionCall sectionCall) {
        this.calls.add(sectionCall);
    }

    @Override
    public Paragraph addParagraph(Cobol85Parser.ParagraphContext ctx) {
        Paragraph result = (Paragraph)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new ParagraphImpl(name, this.programUnit, ctx);
            this.paragraphs.add(result);
            result.setSection(this);
            this.assureParagraphsSymbolTableEntry(name).addParagraph(result);
            this.programUnit.getProcedureDivision().addParagraph(result);
            ParagraphName paragraphName = this.addParagraphName(ctx.paragraphName());
            result.addParagraphName(paragraphName);
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ParagraphName addParagraphName(Cobol85Parser.ParagraphNameContext ctx) {
        ParagraphName result = (ParagraphName)this.getASGElement(ctx);
        if (result == null) {
            String name = this.determineName(ctx);
            result = new ParagraphNameImpl(name, this.programUnit, ctx);
            this.registerASGElement(result);
        }
        return result;
    }

    protected ParagraphsSymbolTableEntry assureParagraphsSymbolTableEntry(String name) {
        ParagraphsSymbolTableEntry paragraphsSymbolTableEntry = this.paragraphsSymbolTable.get(this.getSymbol(name));
        if (paragraphsSymbolTableEntry == null) {
            paragraphsSymbolTableEntry = new ParagraphsSymbolTableEntryImpl();
            this.paragraphsSymbolTable.put(this.getSymbol(name), paragraphsSymbolTableEntry);
        }
        return paragraphsSymbolTableEntry;
    }

    @Override
    public List<SectionCall> getCalls() {
        return this.calls;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Paragraph getParagraph(String name) {
        return this.paragraphsSymbolTable.get(this.getSymbol(name)) == null ? null : this.paragraphsSymbolTable.get(this.getSymbol(name)).getParagraph();
    }

    @Override
    public List<Paragraph> getParagraphs() {
        return this.paragraphs;
    }

    @Override
    public List<Paragraph> getParagraphs(String name) {
        return this.paragraphsSymbolTable.get(this.getSymbol(name)).getParagraphs();
    }

    public String toString() {
        return "name=[" + this.name + "]";
    }
}

