/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.procedure.perform.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.Scope;
import io.proleap.cobol.asg.metamodel.call.Call;
import io.proleap.cobol.asg.metamodel.call.impl.ProcedureCallImpl;
import io.proleap.cobol.asg.metamodel.procedure.Paragraph;
import io.proleap.cobol.asg.metamodel.procedure.StatementType;
import io.proleap.cobol.asg.metamodel.procedure.StatementTypeEnum;
import io.proleap.cobol.asg.metamodel.procedure.impl.StatementImpl;
import io.proleap.cobol.asg.metamodel.procedure.perform.PerformInlineStatement;
import io.proleap.cobol.asg.metamodel.procedure.perform.PerformProcedureStatement;
import io.proleap.cobol.asg.metamodel.procedure.perform.PerformStatement;
import io.proleap.cobol.asg.metamodel.procedure.perform.impl.PerformInlineStatementImpl;
import io.proleap.cobol.asg.metamodel.procedure.perform.impl.PerformProcedureStatementImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PerformStatementImpl
extends StatementImpl
implements PerformStatement {
    private static final Logger LOG = LogManager.getLogger(PerformStatementImpl.class);
    protected final Cobol85Parser.PerformStatementContext ctx;
    protected PerformInlineStatement performInlineStatement;
    protected PerformProcedureStatement performProcedureStatement;
    protected PerformStatement.PerformStatementType performStatementType;
    protected final StatementType statementType = StatementTypeEnum.PERFORM;

    public PerformStatementImpl(ProgramUnit programUnit, Scope scope, Cobol85Parser.PerformStatementContext ctx) {
        super(programUnit, scope, ctx);
        this.ctx = ctx;
    }

    protected List<Call> addCallsThrough(Call firstCall, Call lastCall, Cobol85Parser.PerformProcedureStatementContext ctx) {
        Paragraph paragraph;
        String paragraphName;
        ArrayList<Call> result = new ArrayList<Call>();
        String firstCallName = firstCall.getName();
        String lastCallName = lastCall.getName();
        boolean inThrough = false;
        List<Paragraph> paragraphs = this.programUnit.getProcedureDivision().getParagraphs();
        Iterator<Paragraph> iterator = paragraphs.iterator();
        while (iterator.hasNext() && !(paragraphName = (paragraph = iterator.next()).getName()).equals(lastCallName)) {
            if (paragraphName.equals(firstCallName)) {
                inThrough = true;
                continue;
            }
            if (!inThrough) continue;
            ProcedureCallImpl call = new ProcedureCallImpl(paragraphName, paragraph, this.programUnit, ctx);
            result.add(call);
            this.linkProcedureCallWithParagraph(call, paragraph);
        }
        return result;
    }

    @Override
    public PerformInlineStatement addPerformInlineStatement(Cobol85Parser.PerformInlineStatementContext ctx) {
        PerformInlineStatement result = (PerformInlineStatement)this.getASGElement(ctx);
        if (result == null) {
            result = new PerformInlineStatementImpl(this.programUnit, ctx);
            if (ctx.performType() != null) {
                result.addPerformType(ctx.performType());
            }
            for (Cobol85Parser.StatementContext statementContext : ctx.statement()) {
                result.addStatement(statementContext);
            }
            this.performInlineStatement = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public PerformProcedureStatement addPerformProcedureStatement(Cobol85Parser.PerformProcedureStatementContext ctx) {
        PerformProcedureStatement result = (PerformProcedureStatement)this.getASGElement(ctx);
        if (result == null) {
            result = new PerformProcedureStatementImpl(this.programUnit, ctx);
            List<Cobol85Parser.ProcedureNameContext> procedureNames = ctx.procedureName();
            if (procedureNames.isEmpty()) {
                LOG.warn("no calls in {}.", (Object)ctx);
            } else {
                Call firstCall = this.createCall(procedureNames.get(0));
                result.addCall(firstCall);
                if (procedureNames.size() > 1) {
                    Call lastCall = this.createCall(procedureNames.get(1));
                    List<Call> callsThrough = this.addCallsThrough(firstCall, lastCall, ctx);
                    result.addCalls(callsThrough);
                    result.addCall(lastCall);
                }
            }
            if (ctx.performType() != null) {
                result.addPerformType(ctx.performType());
            }
            this.performProcedureStatement = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public PerformInlineStatement getPerformInlineStatement() {
        return this.performInlineStatement;
    }

    @Override
    public PerformProcedureStatement getPerformProcedureStatement() {
        return this.performProcedureStatement;
    }

    @Override
    public PerformStatement.PerformStatementType getPerformStatementType() {
        return this.performStatementType;
    }

    @Override
    public StatementType getStatementType() {
        return this.statementType;
    }

    @Override
    public void setPerformStatementType(PerformStatement.PerformStatementType performStatementType) {
        this.performStatementType = performStatementType;
    }
}

