/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.metamodel.procedure.receive.impl;

import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.ProgramUnit;
import io.proleap.cobol.asg.metamodel.Scope;
import io.proleap.cobol.asg.metamodel.call.Call;
import io.proleap.cobol.asg.metamodel.procedure.NotOnExceptionClause;
import io.proleap.cobol.asg.metamodel.procedure.OnExceptionClause;
import io.proleap.cobol.asg.metamodel.procedure.StatementType;
import io.proleap.cobol.asg.metamodel.procedure.StatementTypeEnum;
import io.proleap.cobol.asg.metamodel.procedure.impl.StatementImpl;
import io.proleap.cobol.asg.metamodel.procedure.receive.ReceiveFromStatement;
import io.proleap.cobol.asg.metamodel.procedure.receive.ReceiveIntoStatement;
import io.proleap.cobol.asg.metamodel.procedure.receive.ReceiveStatement;
import io.proleap.cobol.asg.metamodel.procedure.receive.impl.ReceiveFromStatementImpl;
import io.proleap.cobol.asg.metamodel.procedure.receive.impl.ReceiveIntoStatementImpl;

public class ReceiveStatementImpl
extends StatementImpl
implements ReceiveStatement {
    protected final Cobol85Parser.ReceiveStatementContext ctx;
    protected NotOnExceptionClause notOnExceptionClause;
    protected OnExceptionClause onExceptionClause;
    protected ReceiveFromStatement receiveFromStatement;
    protected ReceiveIntoStatement receiveIntoStatement;
    protected ReceiveStatement.ReceiveType receiveType;
    protected final StatementType statementType = StatementTypeEnum.RECEIVE;

    public ReceiveStatementImpl(ProgramUnit programUnit, Scope scope, Cobol85Parser.ReceiveStatementContext ctx) {
        super(programUnit, scope, ctx);
        this.ctx = ctx;
    }

    @Override
    public ReceiveFromStatement addReceiveFromStatement(Cobol85Parser.ReceiveFromStatementContext ctx) {
        ReceiveFromStatement result = (ReceiveFromStatement)this.getASGElement(ctx);
        if (result == null) {
            result = new ReceiveFromStatementImpl(this.programUnit, ctx);
            Call dataCall = this.createCall(ctx.dataName());
            result.setDataCall(dataCall);
            result.addFrom(ctx.receiveFrom());
            for (Cobol85Parser.ReceiveBeforeContext receiveBeforeContext : ctx.receiveBefore()) {
                result.addBefore(receiveBeforeContext);
            }
            for (Cobol85Parser.ReceiveWithContext receiveWithContext : ctx.receiveWith()) {
                result.addWith(receiveWithContext);
            }
            for (Cobol85Parser.ReceiveThreadContext receiveThreadContext : ctx.receiveThread()) {
                result.addThread(receiveThreadContext);
            }
            for (Cobol85Parser.ReceiveSizeContext receiveSizeContext : ctx.receiveSize()) {
                result.addSize(receiveSizeContext);
            }
            for (Cobol85Parser.ReceiveStatusContext receiveStatusContext : ctx.receiveStatus()) {
                result.addStatus(receiveStatusContext);
            }
            this.receiveFromStatement = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public ReceiveIntoStatement addReceiveIntoStatement(Cobol85Parser.ReceiveIntoStatementContext ctx) {
        ReceiveIntoStatement result = (ReceiveIntoStatement)this.getASGElement(ctx);
        if (result == null) {
            result = new ReceiveIntoStatementImpl(this.programUnit, ctx);
            Call cdNameCall = this.createCall(ctx.cdName());
            result.setCommunicationDescriptionCall(cdNameCall);
            ReceiveIntoStatement.ReceiveIntoType type = ctx.MESSAGE() != null ? ReceiveIntoStatement.ReceiveIntoType.MESSAGE : (ctx.SEGMENT() != null ? ReceiveIntoStatement.ReceiveIntoType.SEGMENT : null);
            result.setReceiveIntoType(type);
            if (ctx.identifier() != null) {
                Call intoCall = this.createCall(ctx.identifier());
                result.setIntoCall(intoCall);
            }
            if (ctx.receiveNoData() != null) {
                result.addNoData(ctx.receiveNoData());
            }
            if (ctx.receiveWithData() != null) {
                result.addWithData(ctx.receiveWithData());
            }
            this.receiveIntoStatement = result;
            this.registerASGElement(result);
        }
        return result;
    }

    @Override
    public NotOnExceptionClause getNotOnExceptionClause() {
        return this.notOnExceptionClause;
    }

    @Override
    public OnExceptionClause getOnExceptionClause() {
        return this.onExceptionClause;
    }

    @Override
    public ReceiveFromStatement getReceiveFromStatement() {
        return this.receiveFromStatement;
    }

    @Override
    public ReceiveIntoStatement getReceiveIntoStatement() {
        return this.receiveIntoStatement;
    }

    @Override
    public ReceiveStatement.ReceiveType getReceiveType() {
        return this.receiveType;
    }

    @Override
    public StatementType getStatementType() {
        return this.statementType;
    }

    @Override
    public void setNotOnExceptionClause(NotOnExceptionClause notOnExceptionClause) {
        this.notOnExceptionClause = notOnExceptionClause;
    }

    @Override
    public void setOnExceptionClause(OnExceptionClause onExceptionClause) {
        this.onExceptionClause = onExceptionClause;
    }

    @Override
    public void setReceiveType(ReceiveStatement.ReceiveType receiveType) {
        this.receiveType = receiveType;
    }
}

