/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.runner.impl;

import com.google.common.collect.Lists;
import io.proleap.cobol.Cobol85Lexer;
import io.proleap.cobol.Cobol85Parser;
import io.proleap.cobol.asg.metamodel.CompilationUnit;
import io.proleap.cobol.asg.metamodel.Program;
import io.proleap.cobol.asg.metamodel.impl.ProgramImpl;
import io.proleap.cobol.asg.params.CobolParserParams;
import io.proleap.cobol.asg.params.impl.CobolParserParamsImpl;
import io.proleap.cobol.asg.runner.CobolParserRunner;
import io.proleap.cobol.asg.runner.ThrowingErrorListener;
import io.proleap.cobol.asg.visitor.impl.CobolCompilationUnitVisitorImpl;
import io.proleap.cobol.asg.visitor.impl.CobolDataDivisionStep1VisitorImpl;
import io.proleap.cobol.asg.visitor.impl.CobolDataDivisionStep2VisitorImpl;
import io.proleap.cobol.asg.visitor.impl.CobolFileControlClauseVisitorImpl;
import io.proleap.cobol.asg.visitor.impl.CobolFileDescriptionEntryClauseVisitorImpl;
import io.proleap.cobol.asg.visitor.impl.CobolProcedureDivisionVisitorImpl;
import io.proleap.cobol.asg.visitor.impl.CobolProcedureStatementVisitorImpl;
import io.proleap.cobol.asg.visitor.impl.CobolProgramUnitVisitorImpl;
import io.proleap.cobol.preprocessor.CobolPreprocessor;
import io.proleap.cobol.preprocessor.impl.CobolPreprocessorImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CobolParserRunnerImpl
implements CobolParserRunner {
    protected static final Logger LOG = LogManager.getLogger(CobolParserRunnerImpl.class);

    protected void analyze(Program program) {
        this.analyzeProgramUnits(program);
        this.analyzeDataDivisionsStep1(program);
        this.analyzeDataDivisionsStep2(program);
        this.analyzeFileControlClauses(program);
        this.analyzeFileDescriptionEntriesClauses(program);
        this.analyzeProcedureDivisions(program);
        this.analyzeProcedureStatements(program);
    }

    protected void analyzeDataDivisionsStep1(Program program) {
        for (CompilationUnit compilationUnit : program.getCompilationUnits()) {
            CobolDataDivisionStep1VisitorImpl visitor = new CobolDataDivisionStep1VisitorImpl(program);
            LOG.info("Analyzing data divisions of compilation unit {} in step 1.", (Object)compilationUnit.getName());
            visitor.visit((ParseTree)compilationUnit.getCtx());
        }
    }

    protected void analyzeDataDivisionsStep2(Program program) {
        for (CompilationUnit compilationUnit : program.getCompilationUnits()) {
            CobolDataDivisionStep2VisitorImpl visitor = new CobolDataDivisionStep2VisitorImpl(program);
            LOG.info("Analyzing data divisions of compilation unit {} in step 2.", (Object)compilationUnit.getName());
            visitor.visit((ParseTree)compilationUnit.getCtx());
        }
    }

    @Override
    public Program analyzeFile(File cobolFile, CobolPreprocessor.CobolSourceFormatEnum format) throws IOException {
        CobolParserParams params = this.createDefaultParams(cobolFile);
        return this.analyzeFile(cobolFile, format, params);
    }

    @Override
    public Program analyzeFile(File inputFile, CobolPreprocessor.CobolSourceFormatEnum format, CobolParserParams params) throws IOException {
        ProgramImpl program = new ProgramImpl();
        this.parseFile(inputFile, program, format, params);
        this.analyze(program);
        return program;
    }

    protected void analyzeFileControlClauses(Program program) {
        for (CompilationUnit compilationUnit : program.getCompilationUnits()) {
            CobolFileControlClauseVisitorImpl visitor = new CobolFileControlClauseVisitorImpl(program);
            LOG.info("Analyzing file control clauses of compilation unit {}.", (Object)compilationUnit.getName());
            visitor.visit((ParseTree)compilationUnit.getCtx());
        }
    }

    protected void analyzeFileDescriptionEntriesClauses(Program program) {
        for (CompilationUnit compilationUnit : program.getCompilationUnits()) {
            CobolFileDescriptionEntryClauseVisitorImpl visitor = new CobolFileDescriptionEntryClauseVisitorImpl(program);
            LOG.info("Analyzing file description entries of compilation unit {}.", (Object)compilationUnit.getName());
            visitor.visit((ParseTree)compilationUnit.getCtx());
        }
    }

    protected void analyzeProcedureDivisions(Program program) {
        for (CompilationUnit compilationUnit : program.getCompilationUnits()) {
            CobolProcedureDivisionVisitorImpl visitor = new CobolProcedureDivisionVisitorImpl(program);
            LOG.info("Analyzing procedure divisions of compilation unit {}.", (Object)compilationUnit.getName());
            visitor.visit((ParseTree)compilationUnit.getCtx());
        }
    }

    protected void analyzeProcedureStatements(Program program) {
        for (CompilationUnit compilationUnit : program.getCompilationUnits()) {
            CobolProcedureStatementVisitorImpl visitor = new CobolProcedureStatementVisitorImpl(program);
            LOG.info("Analyzing statements of compilation unit {}.", (Object)compilationUnit.getName());
            visitor.visit((ParseTree)compilationUnit.getCtx());
        }
    }

    protected void analyzeProgramUnits(Program program) {
        for (CompilationUnit compilationUnit : program.getCompilationUnits()) {
            CobolProgramUnitVisitorImpl visitor = new CobolProgramUnitVisitorImpl(compilationUnit);
            LOG.info("Analyzing program units of compilation unit {}.", (Object)compilationUnit.getName());
            visitor.visit((ParseTree)compilationUnit.getCtx());
        }
    }

    protected CobolParserParams createDefaultParams(File cobolFile) {
        CobolParserParamsImpl result = new CobolParserParamsImpl();
        File copyBooksDirectory = cobolFile.getParentFile();
        result.setCopyBookDirectories(Lists.newArrayList((Object[])new File[]{copyBooksDirectory}));
        return result;
    }

    protected String getCompilationUnitName(File cobolFile) {
        return StringUtils.capitalize((String)FilenameUtils.removeExtension((String)cobolFile.getName()));
    }

    protected void parseFile(File cobolFile, Program program, CobolPreprocessor.CobolSourceFormatEnum format, CobolParserParams params) throws IOException {
        if (!cobolFile.isFile()) {
            LOG.warn("Could not find file {}", (Object)cobolFile.getAbsolutePath());
        } else {
            String preProcessedInput = new CobolPreprocessorImpl().process(cobolFile, format, params);
            LOG.info("Parsing file {}.", (Object)cobolFile.getName());
            Cobol85Lexer lexer = new Cobol85Lexer((CharStream)CharStreams.fromString((String)preProcessedInput));
            if (!params.getIgnoreSyntaxErrors()) {
                lexer.removeErrorListeners();
                lexer.addErrorListener((ANTLRErrorListener)new ThrowingErrorListener());
            }
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            Cobol85Parser parser = new Cobol85Parser((TokenStream)tokens);
            if (!params.getIgnoreSyntaxErrors()) {
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)new ThrowingErrorListener());
            }
            Cobol85Parser.StartRuleContext ctx = parser.startRule();
            String compilationUnitName = this.getCompilationUnitName(cobolFile);
            List<String> lines = this.splitLines(preProcessedInput);
            CobolCompilationUnitVisitorImpl visitor = new CobolCompilationUnitVisitorImpl(compilationUnitName, lines, tokens, program);
            LOG.info("Collecting units in file {}.", (Object)cobolFile.getName());
            visitor.visit((ParseTree)ctx);
        }
    }

    protected List<String> splitLines(String preProcessedInput) {
        Scanner scanner = new Scanner(preProcessedInput);
        ArrayList<String> result = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            result.add(scanner.nextLine());
        }
        scanner.close();
        return result;
    }
}

