/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.asg.util;

import io.proleap.cobol.asg.metamodel.ASGElement;
import io.proleap.cobol.asg.metamodel.registry.ASGElementRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class ANTLRUtils {
    public static <T extends ASGElement> Collection<T> findAncestors(Class<? extends ASGElement> type, ParseTree from, ASGElementRegistry asgElementRegistry) {
        ParseTree currentCtx = from;
        ArrayList<T> result = new ArrayList<T>();
        while (currentCtx != null) {
            T parent = ANTLRUtils.findParent(type, currentCtx, asgElementRegistry);
            if (parent != null) {
                currentCtx = parent.getCtx();
                result.add(parent);
                continue;
            }
            currentCtx = null;
        }
        return result;
    }

    public static List<ASGElement> findASGElementChildren(ParseTree from, ASGElementRegistry asgElementRegistry) {
        return ANTLRUtils.findChildren(ASGElement.class, from, asgElementRegistry);
    }

    public static <T extends ASGElement> List<T> findChildren(Class<? extends ASGElement> type, ParseTree ctx, ASGElementRegistry asgElementRegistry) {
        List<ParseTree> children = ANTLRUtils.findChildren(ctx);
        ArrayList<ASGElement> result = new ArrayList<ASGElement>();
        for (ParseTree currentChild : children) {
            ASGElement asgElement = asgElementRegistry.getASGElement(currentChild);
            if (asgElement == null || !type.isAssignableFrom(asgElement.getClass())) continue;
            result.add(asgElement);
        }
        return result;
    }

    public static List<ParseTree> findChildren(ParseTree ctx) {
        ArrayList<ParseTree> result = new ArrayList<ParseTree>();
        int n = ctx.getChildCount();
        for (int i = 0; i < n; ++i) {
            ParseTree currentChild = ctx.getChild(i);
            result.add(currentChild);
        }
        return result;
    }

    public static <T extends ASGElement> T findParent(Class<? extends ASGElement> type, ParseTree from, ASGElementRegistry asgElementRegistry) {
        ASGElement result = null;
        ParseTree currentCtx = from;
        while (result == null && currentCtx != null) {
            ASGElement asgElement = asgElementRegistry.getASGElement(currentCtx = currentCtx.getParent());
            if (asgElement == null || !type.isAssignableFrom(asgElement.getClass())) continue;
            result = asgElement;
        }
        return (T)result;
    }
}

