/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.impl;

import com.google.common.collect.Lists;
import io.proleap.cobol.asg.params.CobolParserParams;
import io.proleap.cobol.asg.params.impl.CobolParserParamsImpl;
import io.proleap.cobol.preprocessor.CobolPreprocessor;
import io.proleap.cobol.preprocessor.sub.CobolLine;
import io.proleap.cobol.preprocessor.sub.document.CobolDocumentParser;
import io.proleap.cobol.preprocessor.sub.document.impl.CobolDocumentParserImpl;
import io.proleap.cobol.preprocessor.sub.line.reader.CobolLineReader;
import io.proleap.cobol.preprocessor.sub.line.reader.impl.CobolLineReaderImpl;
import io.proleap.cobol.preprocessor.sub.line.rewriter.CobolCommentEntriesMarker;
import io.proleap.cobol.preprocessor.sub.line.rewriter.CobolInlineCommentEntriesNormalizer;
import io.proleap.cobol.preprocessor.sub.line.rewriter.CobolLineIndicatorProcessor;
import io.proleap.cobol.preprocessor.sub.line.rewriter.impl.CobolCommentEntriesMarkerImpl;
import io.proleap.cobol.preprocessor.sub.line.rewriter.impl.CobolInlineCommentEntriesNormalizerImpl;
import io.proleap.cobol.preprocessor.sub.line.rewriter.impl.CobolLineIndicatorProcessorImpl;
import io.proleap.cobol.preprocessor.sub.line.writer.CobolLineWriter;
import io.proleap.cobol.preprocessor.sub.line.writer.impl.CobolLineWriterImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CobolPreprocessorImpl
implements CobolPreprocessor {
    private static final Logger LOG = LogManager.getLogger(CobolPreprocessorImpl.class);

    protected CobolCommentEntriesMarker createCommentEntriesMarker() {
        return new CobolCommentEntriesMarkerImpl();
    }

    protected CobolParserParams createDefaultParams() {
        CobolParserParamsImpl result = new CobolParserParamsImpl();
        return result;
    }

    protected CobolParserParams createDefaultParams(File cobolFile) {
        CobolParserParams result = this.createDefaultParams();
        File copyBooksDirectory = cobolFile.getParentFile();
        result.setCopyBookDirectories(Lists.newArrayList((Object[])new File[]{copyBooksDirectory}));
        return result;
    }

    protected CobolDocumentParser createDocumentParser() {
        return new CobolDocumentParserImpl();
    }

    protected CobolInlineCommentEntriesNormalizer createInlineCommentEntriesNormalizer() {
        return new CobolInlineCommentEntriesNormalizerImpl();
    }

    protected CobolLineIndicatorProcessor createLineIndicatorProcessor() {
        return new CobolLineIndicatorProcessorImpl();
    }

    protected CobolLineReader createLineReader() {
        return new CobolLineReaderImpl();
    }

    protected CobolLineWriter createLineWriter() {
        return new CobolLineWriterImpl();
    }

    protected String parseDocument(List<CobolLine> lines, CobolPreprocessor.CobolSourceFormatEnum format, CobolParserParams params) {
        String code = this.createLineWriter().serialize(lines);
        String result = this.createDocumentParser().processLines(code, format, params);
        return result;
    }

    @Override
    public String process(File cobolFile, CobolPreprocessor.CobolSourceFormatEnum format) throws IOException {
        return this.process(cobolFile, format, this.createDefaultParams(cobolFile));
    }

    @Override
    public String process(File cobolFile, CobolPreprocessor.CobolSourceFormatEnum format, CobolParserParams params) throws IOException {
        Charset charset = params.getCharset();
        LOG.info("Preprocessing file {} with line format {} and charset {}.", (Object)cobolFile.getName(), (Object)format, (Object)charset);
        FileInputStream inputStream = new FileInputStream(cobolFile);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, charset);
        BufferedReader bufferedInputStreamReader = new BufferedReader(inputStreamReader);
        StringBuffer outputBuffer = new StringBuffer();
        String line = null;
        while ((line = bufferedInputStreamReader.readLine()) != null) {
            outputBuffer.append(line + "\n");
        }
        bufferedInputStreamReader.close();
        String result = this.process(outputBuffer.toString(), format, params);
        return result;
    }

    @Override
    public String process(String cobolSourceCode, CobolPreprocessor.CobolSourceFormatEnum format) {
        return this.process(cobolSourceCode, format, this.createDefaultParams());
    }

    @Override
    public String process(String cobolCode, CobolPreprocessor.CobolSourceFormatEnum format, CobolParserParams params) {
        List<CobolLine> lines = this.readLines(cobolCode, format, params);
        List<CobolLine> rewrittenLines = this.rewriteLines(lines);
        String result = this.parseDocument(rewrittenLines, format, params);
        return result;
    }

    protected List<CobolLine> readLines(String cobolCode, CobolPreprocessor.CobolSourceFormatEnum format, CobolParserParams params) {
        List<CobolLine> lines = this.createLineReader().processLines(cobolCode, format, params);
        return lines;
    }

    protected List<CobolLine> rewriteLines(List<CobolLine> lines) {
        List<CobolLine> lineIndicatorProcessedLines = this.createLineIndicatorProcessor().processLines(lines);
        List<CobolLine> normalizedInlineCommentEntriesLines = this.createInlineCommentEntriesNormalizer().processLines(lineIndicatorProcessedLines);
        List<CobolLine> result = this.createCommentEntriesMarker().processLines(normalizedInlineCommentEntriesLines);
        return result;
    }
}

