/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub;

import com.google.common.base.Strings;
import io.proleap.cobol.asg.params.CobolDialect;
import io.proleap.cobol.preprocessor.CobolPreprocessor;
import io.proleap.cobol.preprocessor.sub.CobolLineTypeEnum;

public class CobolLine {
    protected String commentArea;
    protected String commentAreaOriginal;
    protected String contentAreaA;
    protected String contentAreaAOriginal;
    protected String contentAreaB;
    protected String contentAreaBOriginal;
    protected CobolDialect dialect;
    protected CobolPreprocessor.CobolSourceFormatEnum format;
    protected String indicatorArea;
    protected String indicatorAreaOriginal;
    protected int number;
    protected CobolLine predecessor;
    protected String sequenceArea;
    protected String sequenceAreaOriginal;
    protected CobolLine successor;
    protected CobolLineTypeEnum type;

    public static CobolLine copyCobolLineWithContentArea(String contentArea, CobolLine line) {
        return new CobolLine(line.sequenceArea, line.sequenceAreaOriginal, line.indicatorArea, line.indicatorAreaOriginal, CobolLine.extractContentAreaA(contentArea), line.contentAreaAOriginal, CobolLine.extractContentAreaB(contentArea), line.contentAreaBOriginal, line.commentArea, line.commentAreaOriginal, line.format, line.dialect, line.number, line.type, line.predecessor, line.successor);
    }

    public static CobolLine copyCobolLineWithIndicatorAndContentArea(String indicatorArea, String contentArea, CobolLine line) {
        return new CobolLine(line.sequenceArea, line.sequenceAreaOriginal, indicatorArea, line.indicatorAreaOriginal, CobolLine.extractContentAreaA(contentArea), line.contentAreaAOriginal, CobolLine.extractContentAreaB(contentArea), line.contentAreaBOriginal, line.commentArea, line.commentAreaOriginal, line.format, line.dialect, line.number, line.type, line.predecessor, line.successor);
    }

    public static CobolLine copyCobolLineWithIndicatorArea(String indicatorArea, CobolLine line) {
        return new CobolLine(line.sequenceArea, line.sequenceAreaOriginal, indicatorArea, line.indicatorAreaOriginal, line.contentAreaA, line.contentAreaAOriginal, line.contentAreaB, line.contentAreaBOriginal, line.commentArea, line.commentAreaOriginal, line.format, line.dialect, line.number, line.type, line.predecessor, line.successor);
    }

    public static String createBlankSequenceArea(CobolPreprocessor.CobolSourceFormatEnum format) {
        return CobolPreprocessor.CobolSourceFormatEnum.TANDEM.equals((Object)format) ? "" : Strings.repeat((String)" ", (int)6);
    }

    protected static String extractContentAreaA(String contentArea) {
        return contentArea.length() > 4 ? contentArea.substring(0, 4) : contentArea;
    }

    protected static String extractContentAreaB(String contentArea) {
        return contentArea.length() > 4 ? contentArea.substring(4) : "";
    }

    public static CobolLine newCobolLine(String sequenceArea, String indicatorArea, String contentAreaA, String contentAreaB, String commentArea, CobolPreprocessor.CobolSourceFormatEnum format, CobolDialect dialect, int number, CobolLineTypeEnum type) {
        return new CobolLine(sequenceArea, sequenceArea, indicatorArea, indicatorArea, contentAreaA, contentAreaA, contentAreaB, contentAreaB, commentArea, commentArea, format, dialect, number, type, null, null);
    }

    protected CobolLine(String sequenceArea, String sequenceAreaOriginal, String indicatorArea, String indicatorAreaOriginal, String contentAreaA, String contentAreaAOriginal, String contentAreaB, String contentAreaBOriginal, String commentArea, String commentAreaOriginal, CobolPreprocessor.CobolSourceFormatEnum format, CobolDialect dialect, int number, CobolLineTypeEnum type, CobolLine predecessor, CobolLine successor) {
        this.sequenceArea = sequenceArea;
        this.indicatorArea = indicatorArea;
        this.contentAreaA = contentAreaA;
        this.contentAreaB = contentAreaB;
        this.commentArea = commentArea;
        this.sequenceAreaOriginal = sequenceAreaOriginal;
        this.indicatorAreaOriginal = indicatorAreaOriginal;
        this.contentAreaAOriginal = contentAreaAOriginal;
        this.contentAreaBOriginal = contentAreaBOriginal;
        this.commentAreaOriginal = commentAreaOriginal;
        this.format = format;
        this.dialect = dialect;
        this.number = number;
        this.type = type;
        this.setPredecessor(predecessor);
        this.setSuccessor(successor);
    }

    public String getBlankSequenceArea() {
        return CobolLine.createBlankSequenceArea(this.format);
    }

    public String getCommentArea() {
        return this.commentArea;
    }

    public String getCommentAreaOriginal() {
        return this.commentAreaOriginal;
    }

    public String getContentArea() {
        return this.contentAreaA + this.contentAreaB;
    }

    public String getContentAreaA() {
        return this.contentAreaA;
    }

    public String getContentAreaAOriginal() {
        return this.contentAreaAOriginal;
    }

    public String getContentAreaB() {
        return this.contentAreaB;
    }

    public String getContentAreaBOriginal() {
        return this.contentAreaBOriginal;
    }

    public String getContentAreaOriginal() {
        return this.contentAreaAOriginal + this.contentAreaBOriginal;
    }

    public CobolDialect getDialect() {
        return this.dialect;
    }

    public CobolPreprocessor.CobolSourceFormatEnum getFormat() {
        return this.format;
    }

    public String getIndicatorArea() {
        return this.indicatorArea;
    }

    public String getIndicatorAreaOriginal() {
        return this.indicatorAreaOriginal;
    }

    public int getNumber() {
        return this.number;
    }

    public CobolLine getPredecessor() {
        return this.predecessor;
    }

    public String getSequenceArea() {
        return this.sequenceArea;
    }

    public String getSequenceAreaOriginal() {
        return this.sequenceAreaOriginal;
    }

    public CobolLine getSuccessor() {
        return this.successor;
    }

    public CobolLineTypeEnum getType() {
        return this.type;
    }

    public String serialize() {
        return this.sequenceArea + this.indicatorArea + this.contentAreaA + this.contentAreaB + this.commentArea;
    }

    public void setPredecessor(CobolLine predecessor) {
        this.predecessor = predecessor;
        if (predecessor != null) {
            predecessor.successor = this;
        }
    }

    public void setSuccessor(CobolLine successor) {
        this.successor = successor;
        if (successor != null) {
            successor.predecessor = this;
        }
    }

    public String toString() {
        return this.serialize();
    }
}

