/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub.copybook.impl;

import io.proleap.cobol.Cobol85PreprocessorParser;
import io.proleap.cobol.asg.params.CobolParserParams;
import io.proleap.cobol.preprocessor.sub.copybook.CobolWordCopyBookFinder;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.util.Strings;

public class CobolWordCopyBookFinderImpl
implements CobolWordCopyBookFinder {
    @Override
    public File findCopyBook(CobolParserParams params, Cobol85PreprocessorParser.CobolWordContext ctx) {
        if (params.getCopyBookFiles() != null) {
            for (File copyBookFile : params.getCopyBookFiles()) {
                if (!this.isMatchingCopyBook(copyBookFile, params, ctx)) continue;
                return copyBookFile;
            }
        }
        if (params.getCopyBookDirectories() != null) {
            for (File copyBookDirectory : params.getCopyBookDirectories()) {
                File validCopyBook = this.findCopyBookInDirectory(copyBookDirectory, params, ctx);
                if (validCopyBook == null) continue;
                return validCopyBook;
            }
        }
        return null;
    }

    protected File findCopyBookInDirectory(File copyBooksDirectory, CobolParserParams params, Cobol85PreprocessorParser.CobolWordContext ctx) {
        for (File copyBookCandidate : copyBooksDirectory.listFiles()) {
            if (!this.isMatchingCopyBook(copyBookCandidate, params, ctx)) continue;
            return copyBookCandidate;
        }
        return null;
    }

    protected boolean isMatchingCopyBook(File copyBookCandidate, CobolParserParams params, Cobol85PreprocessorParser.CobolWordContext ctx) {
        String copyBookIdentifier = ctx.getText();
        if (params.getCopyBookExtensions() != null) {
            for (String copyBookExtension : params.getCopyBookExtensions()) {
                if (!this.isMatchingCopyBookWithExtension(copyBookCandidate, copyBookIdentifier, copyBookExtension)) continue;
                return true;
            }
            return false;
        }
        return this.isMatchingCopyBookWithoutExtension(copyBookCandidate, copyBookIdentifier);
    }

    protected boolean isMatchingCopyBookWithExtension(File copyBookCandidate, String copyBookIdentifier, String copyBookExtension) {
        String copyBookFilename = Strings.isBlank((String)copyBookExtension) ? copyBookIdentifier : copyBookIdentifier + "." + copyBookExtension;
        String copyBookCandidateName = copyBookCandidate.getName();
        boolean result = copyBookFilename.equalsIgnoreCase(copyBookCandidateName);
        return result;
    }

    protected boolean isMatchingCopyBookWithoutExtension(File copyBookCandidate, String copyBookIdentifier) {
        String copyBookCandidateBaseName = FilenameUtils.getBaseName((String)copyBookCandidate.getName());
        boolean result = copyBookCandidateBaseName.equalsIgnoreCase(copyBookIdentifier);
        return result;
    }
}

