/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub.copybook.impl;

import io.proleap.cobol.Cobol85PreprocessorParser;
import io.proleap.cobol.asg.params.CobolParserParams;
import io.proleap.cobol.preprocessor.sub.copybook.LiteralCopyBookFinder;
import io.proleap.cobol.preprocessor.sub.util.StringUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;

public class LiteralCopyBookFinderImpl
implements LiteralCopyBookFinder {
    @Override
    public File findCopyBook(CobolParserParams params, Cobol85PreprocessorParser.LiteralContext ctx) {
        if (params.getCopyBookFiles() != null) {
            for (File copyBookFile : params.getCopyBookFiles()) {
                if (!this.isMatchingCopyBook(copyBookFile, null, ctx)) continue;
                return copyBookFile;
            }
        }
        if (params.getCopyBookDirectories() != null) {
            for (File copyBookDirectory : params.getCopyBookDirectories()) {
                File validCopyBook = this.findCopyBookInDirectory(copyBookDirectory, ctx);
                if (validCopyBook == null) continue;
                return validCopyBook;
            }
        }
        return null;
    }

    protected File findCopyBookInDirectory(File copyBooksDirectory, Cobol85PreprocessorParser.LiteralContext ctx) {
        for (File copyBookCandidate : FileUtils.listFiles((File)copyBooksDirectory, null, (boolean)true)) {
            if (!this.isMatchingCopyBook(copyBookCandidate, copyBooksDirectory, ctx)) continue;
            return copyBookCandidate;
        }
        return null;
    }

    protected boolean isMatchingCopyBook(File copyBookCandidate, File cobolCopyDir, Cobol85PreprocessorParser.LiteralContext ctx) {
        String copyBookIdentifier = StringUtils.trimQuotes(ctx.getText()).replace("\\", "/");
        boolean result = cobolCopyDir == null ? this.isMatchingCopyBookRelative(copyBookCandidate, copyBookIdentifier) : this.isMatchingCopyBookAbsolute(copyBookCandidate, cobolCopyDir, copyBookIdentifier);
        return result;
    }

    protected boolean isMatchingCopyBookAbsolute(File copyBookCandidate, File cobolCopyDir, String copyBookIdentifier) {
        Path copyBookCandidateAbsolutePath = Paths.get(copyBookCandidate.getAbsolutePath(), new String[0]).normalize();
        Path copyBookIdentifierAbsolutePath = Paths.get(cobolCopyDir.getAbsolutePath(), copyBookIdentifier).normalize();
        boolean result = copyBookIdentifierAbsolutePath.toString().equalsIgnoreCase(copyBookCandidateAbsolutePath.toString());
        return result;
    }

    protected boolean isMatchingCopyBookRelative(File copyBookCandidate, String copyBookIdentifier) {
        Path copyBookCandidateAbsolutePath = Paths.get(copyBookCandidate.getAbsolutePath(), new String[0]).normalize();
        Path copyBookIdentifierRelativePath = copyBookIdentifier.startsWith("/") || copyBookIdentifier.startsWith("./") || copyBookIdentifier.startsWith("\\") || copyBookIdentifier.startsWith(".\\") ? Paths.get(copyBookIdentifier, new String[0]).normalize() : Paths.get("/" + copyBookIdentifier, new String[0]).normalize();
        boolean result = copyBookCandidateAbsolutePath.toString().toLowerCase().endsWith(copyBookIdentifierRelativePath.toString().toLowerCase());
        return result;
    }
}

